/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.model;

import java.util.TreeMap;
import javax.annotation.Nullable;

public enum BuildState {
    UNKNOWN("Unknown"),
    SUCCESS("Successful"),
    FAILED("Failed");

    private static final TreeMap<String, BuildState> BUILD_STATE_MAPPING;
    private final String state;

    private BuildState(String state) {
        this.state = state;
    }

    public boolean is(@Nullable String stateName) {
        return this.state.equals(stateName);
    }

    public static BuildState getInstance(String state) {
        BuildState buildState = BUILD_STATE_MAPPING.get(state);
        if (buildState == null) {
            throw new IllegalArgumentException("There is no BuildState called '" + state + "'");
        }
        return buildState;
    }

    public String toString() {
        return this.state;
    }

    static {
        BUILD_STATE_MAPPING = new TreeMap<String, BuildState>(String.CASE_INSENSITIVE_ORDER){
            {
                for (BuildState buildState : BuildState.values()) {
                    this.put(buildState.state, buildState);
                }
            }
        };
    }
}

