/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.gadgets;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.application.bamboo.BambooApplicationType;
import com.atlassian.applinks.api.event.ApplicationLinkAddedEvent;
import com.atlassian.applinks.api.event.ApplicationLinkDeletedEvent;
import com.atlassian.applinks.api.event.ApplicationLinkDetailsChangedEvent;
import com.atlassian.applinks.api.event.ApplicationLinksIDChangedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.JiraStartedEvent;
import com.atlassian.jira.plugin.ext.bamboo.applinks.BambooApplicationLinkManager;
import com.atlassian.jira.plugin.ext.bamboo.gadgets.BambooGadgetSpecProvider;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GadgetListener
implements InitializingBean,
DisposableBean {
    private static final Logger log = Logger.getLogger(GadgetListener.class);
    private static final List<String> GADGET_URLS = Lists.newArrayList((Object[])new String[]{"/rest/gadgets/1.0/g/com.atlassian.bamboo.gadgets/charts/bambooCharts.xml", "/rest/gadgets/1.0/g/com.atlassian.bamboo.gadgets/status/planStatus.xml", "/rest/gadgets/1.0/g/com.atlassian.bamboo.gadgets/charts/planSummaryChart.xml", "/rest/gadgets/1.0/g/com.atlassian.bamboo.gadgets/status/cloverCoverage.xml"});
    private final BambooApplicationLinkManager bambooApplicationLinkManager;
    private final BambooGadgetSpecProvider bambooGadgetSpecProvider;
    private final EventPublisher eventPublisher;

    @Autowired
    public GadgetListener(@ComponentImport EventPublisher eventPublisher, BambooApplicationLinkManager bambooApplicationLinkManager, BambooGadgetSpecProvider bambooGadgetSpecProvider) {
        this.bambooApplicationLinkManager = (BambooApplicationLinkManager)Preconditions.checkNotNull((Object)bambooApplicationLinkManager);
        this.bambooGadgetSpecProvider = (BambooGadgetSpecProvider)Preconditions.checkNotNull((Object)bambooGadgetSpecProvider);
        this.eventPublisher = (EventPublisher)Preconditions.checkNotNull((Object)eventPublisher);
    }

    private void createGadgets() {
        for (ApplicationLink applicationLink : this.bambooApplicationLinkManager.getApplicationLinks(BambooApplicationLinkManager.Filter.UNFILTERED)) {
            this.addGadgetsForApplicationLink(applicationLink);
        }
    }

    @EventListener
    public void onEvent(ClearCacheEvent event) {
        this.bambooGadgetSpecProvider.clear();
        this.createGadgets();
    }

    @EventListener
    public void onEvent(ApplicationLinkAddedEvent event) {
        if (event.getApplicationType() instanceof BambooApplicationType) {
            log.info((Object)("Adding gadgets for application link " + event.getApplicationId()));
            this.addGadgetsForApplicationLink(event.getApplicationLink());
        }
    }

    @EventListener
    public void onEvent(ApplicationLinkDeletedEvent event) {
        if (event.getApplicationType() instanceof BambooApplicationType) {
            log.info((Object)("Removing gadgets for application link " + event.getApplicationId()));
            this.bambooGadgetSpecProvider.removeBambooGadgets(event.getApplicationId());
        }
    }

    @EventListener
    public void onEvent(ApplicationLinksIDChangedEvent event) {
        if (event.getApplicationType() instanceof BambooApplicationType) {
            log.info((Object)("Migrating gadgets from application link " + event.getOldApplicationId() + " to " + event.getApplicationId()));
            this.bambooGadgetSpecProvider.migrateBambooGadgets(event.getOldApplicationId(), event.getApplicationId());
        }
    }

    @EventListener
    public void onEvent(ApplicationLinkDetailsChangedEvent event) {
        if (event.getApplicationType() instanceof BambooApplicationType) {
            log.info((Object)("Updating gadgets for application link " + event.getApplicationId()));
            this.bambooGadgetSpecProvider.removeBambooGadgets(event.getApplicationId());
            this.addGadgetsForApplicationLink(event.getApplicationLink());
        }
    }

    private void addGadgetsForApplicationLink(ApplicationLink applicationLink) {
        String host = applicationLink.getDisplayUrl().toASCIIString();
        for (String gadgetUrl : GADGET_URLS) {
            try {
                URI uri = new URI(host + gadgetUrl);
                this.bambooGadgetSpecProvider.addBambooGadget(applicationLink.getId(), uri);
            }
            catch (URISyntaxException e) {
                log.warn((Object)("Could not add bamboo gadgets for " + host), (Throwable)e);
            }
        }
    }

    @EventListener
    public void onJiraStartedEvent(JiraStartedEvent event) {
        this.createGadgets();
    }

    public void afterPropertiesSet() throws Exception {
        this.createGadgets();
        this.eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }
}

