/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.gadgets;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.gadgets.GadgetSpecProvider;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;

@ExportAsService(value={GadgetSpecProvider.class})
@Component
@ThreadSafe
public class BambooGadgetSpecProvider
implements GadgetSpecProvider {
    private static final Logger log = Logger.getLogger(BambooGadgetSpecProvider.class);
    private final Map<ApplicationId, Set<URI>> bambooGadgets = Maps.newLinkedHashMap();

    public Iterable<URI> entries() {
        return this.bambooGadgets.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public boolean contains(URI uri) {
        return Iterables.contains(this.entries(), (Object)uri);
    }

    public void addBambooGadget(ApplicationId appId, URI gadgetUri) {
        log.debug((Object)String.format("Adding Bamboo gadget %s hosted on %s", gadgetUri, appId));
        if (!this.bambooGadgets.containsKey(appId)) {
            this.bambooGadgets.put(appId, new CopyOnWriteArraySet());
        }
        this.bambooGadgets.get(appId).add(gadgetUri);
    }

    public void removeBambooGadgets(ApplicationId appId) {
        this.bambooGadgets.remove(appId);
    }

    public void migrateBambooGadgets(ApplicationId oldId, ApplicationId newId) {
        Set<URI> gadgets = this.bambooGadgets.remove(oldId);
        if (gadgets != null) {
            this.bambooGadgets.put(newId, gadgets);
        }
    }

    public void clear() {
        this.bambooGadgets.clear();
    }
}

