/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.conditions;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.Condition;
import com.atlassian.sal.api.ApplicationProperties;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Scanned
public class IsPriorToJiraVersion
implements Condition {
    private final Integer majorVersion;
    private final Integer minorVersion;
    private Integer maxMajorVersion;
    private Integer maxMinorVersion;

    public IsPriorToJiraVersion(@ComponentImport ApplicationProperties applicationProperties) {
        String versionString = applicationProperties.getVersion();
        String versionRegex = "^(\\d+)\\.(\\d+)";
        Pattern versionPattern = Pattern.compile(versionRegex);
        Matcher versionMatcher = versionPattern.matcher(versionString);
        versionMatcher.find();
        this.majorVersion = Integer.decode(versionMatcher.group(1));
        this.minorVersion = Integer.decode(versionMatcher.group(2));
    }

    public void init(Map<String, String> paramMap) throws PluginParseException {
        this.maxMajorVersion = Integer.decode(paramMap.get("majorVersion"));
        this.maxMinorVersion = Integer.decode(paramMap.get("minorVersion"));
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        return this.majorVersion < this.maxMajorVersion || this.majorVersion.equals(this.maxMajorVersion) && this.minorVersion < this.maxMinorVersion;
    }
}

