/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.conditions;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.Condition;
import com.atlassian.studio.haup.api.SupportedApplication;
import com.atlassian.studio.haup.api.UserApplicationAccessService;
import com.google.common.base.Preconditions;
import java.util.Map;

@Scanned
public class HasViewVersionControlPermission
implements Condition {
    private final FeatureManager featureManager;
    private final JiraAuthenticationContext authContext;
    private final PermissionManager permissionManager;

    public HasViewVersionControlPermission(@ComponentImport FeatureManager featureManager, @ComponentImport JiraAuthenticationContext authContext, @ComponentImport PermissionManager permissionManager) {
        this.authContext = (JiraAuthenticationContext)Preconditions.checkNotNull((Object)authContext);
        this.featureManager = (FeatureManager)Preconditions.checkNotNull((Object)featureManager);
        this.permissionManager = (PermissionManager)Preconditions.checkNotNull((Object)permissionManager);
    }

    public void init(Map<String, String> configParams) {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        UserApplicationAccessService userApplicationAccessService;
        ApplicationUser user = this.authContext.getLoggedInUser();
        if (user == null) {
            return false;
        }
        if (this.featureManager.isOnDemand() && !(userApplicationAccessService = (UserApplicationAccessService)ComponentAccessor.getOSGiComponentInstanceOfType(UserApplicationAccessService.class)).hasAccess(user.getName(), SupportedApplication.BAMBOO)) {
            return false;
        }
        if (context.containsKey("issue")) {
            Issue issue = (Issue)context.get("issue");
            return this.permissionManager.hasPermission(ProjectPermissions.VIEW_DEV_TOOLS, issue, user);
        }
        if (context.containsKey("project")) {
            Project project = (Project)context.get("project");
            return this.permissionManager.hasPermission(ProjectPermissions.VIEW_DEV_TOOLS, project, user);
        }
        return false;
    }
}

