/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.conditions;

import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.Condition;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

@Scanned
public class CanAdministerProjectCondition
implements Condition {
    private final GlobalPermissionManager globalPermissionManager;
    private final JiraAuthenticationContext authContext;
    private final PermissionManager permissionManager;
    private final ProjectManager projectManager;

    public CanAdministerProjectCondition(@ComponentImport GlobalPermissionManager globalPermissionManager, @ComponentImport JiraAuthenticationContext authContext, @ComponentImport PermissionManager permissionManager, @ComponentImport ProjectManager projectManager) {
        this.authContext = (JiraAuthenticationContext)Preconditions.checkNotNull((Object)authContext);
        this.globalPermissionManager = (GlobalPermissionManager)Preconditions.checkNotNull((Object)globalPermissionManager);
        this.permissionManager = (PermissionManager)Preconditions.checkNotNull((Object)permissionManager);
        this.projectManager = (ProjectManager)Preconditions.checkNotNull((Object)projectManager);
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        ApplicationUser user = this.authContext.getLoggedInUser();
        Project project = this.getProject(context);
        if (project == null) {
            return false;
        }
        HttpServletRequest request = ExecutingHttpRequest.get();
        if (request == null) {
            return this.hasPermission(user, project);
        }
        String cacheKey = "atl.jira.permission.request.cache:" + ProjectPermissions.ADMINISTER_PROJECTS.permissionKey() + ":" + user.getKey() + ":" + project.getKey();
        if (request.getAttribute(cacheKey) == null) {
            request.setAttribute(cacheKey, (Object)this.hasPermission(user, project));
        }
        return (Boolean)request.getAttribute(cacheKey);
    }

    private boolean hasPermission(ApplicationUser user, Project project) {
        try {
            return this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user) || this.permissionManager.hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, project, user);
        }
        catch (Exception e) {
            return false;
        }
    }

    private Project getProject(Map<String, Object> context) {
        JiraHelper helper;
        if (context.containsKey("project")) {
            return (Project)context.get("project");
        }
        if (context.containsKey("issue")) {
            return ((Issue)context.get("issue")).getProjectObject();
        }
        if (context.containsKey("helper") && (helper = (JiraHelper)context.get("helper")).getProject() != null) {
            return helper.getProject();
        }
        if (context.containsKey("version")) {
            return ((Version)context.get("version")).getProject();
        }
        if (context.containsKey("component")) {
            Long projectId = ((ProjectComponent)context.get("component")).getProjectId();
            return this.projectManager.getProjectObj(projectId);
        }
        return null;
    }
}

