/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.applinks;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.applinks.api.application.bamboo.BambooApplicationType;
import com.atlassian.applinks.spi.util.TypeAccessor;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.Condition;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.log4j.Logger;

@Scanned
public class BambooApplicationTypeCondition
implements Condition {
    private static final Logger log = Logger.getLogger(BambooApplicationTypeCondition.class);
    private static final Class<BambooApplicationType> BAMBOO_TYPE = BambooApplicationType.class;
    private final TypeAccessor typeAccessor;

    public BambooApplicationTypeCondition(@ComponentImport TypeAccessor typeAccessor) {
        this.typeAccessor = (TypeAccessor)Preconditions.checkNotNull((Object)typeAccessor);
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        ApplicationLink applicationLink = (ApplicationLink)context.get("applicationLink");
        boolean shouldDisplay = true;
        if (applicationLink == null) {
            log.warn((Object)("This page has no applicationLink context. Ignoring " + this.getClass().getSimpleName()));
        } else {
            ApplicationType type = this.typeAccessor.getApplicationType(BAMBOO_TYPE);
            if (type == null) {
                log.warn((Object)("Type '" + BAMBOO_TYPE.getName() + "' specified in " + this.getClass() + " is not installed, condition evaluates to false."));
                shouldDisplay = false;
            } else {
                shouldDisplay = type.getClass().isAssignableFrom(applicationLink.getType().getClass());
            }
        }
        return shouldDisplay;
    }
}

