/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.applinks;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.applinks.api.application.bamboo.BambooApplicationType;
import com.atlassian.applinks.api.event.ApplicationLinksIDChangedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.plugin.devstatus.api.DevStatusSupportedApplicationLinkService;
import com.atlassian.jira.plugin.ext.bamboo.applinks.BambooApplicationLinkManager;
import com.atlassian.jira.plugin.ext.bamboo.optionaldep.DevStatusSupportedAppLinksServiceAccessor;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.capabilities.api.LinkedAppWithCapabilities;
import com.atlassian.plugins.capabilities.api.LinkedApplicationCapabilities;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class BambooApplicationLinkManagerImpl
implements BambooApplicationLinkManager,
InitializingBean,
DisposableBean {
    @VisibleForTesting
    public static final String ENFORCE_JBAM_FEATURE = "jira.bamboo.legacy.force";
    static final String JBAM_ASSOCIATIONS = "jbam-associations";
    static final String DEV_STATUS_DETAIL_DEPLOYMENT_ENVIRONMENT_CAPABILITY = "dev-status-detail-deployment-environment";
    private static final int JIRA_6_2_BUILD_NUMBER = 6200;
    private static final Logger log = Logger.getLogger(BambooApplicationLinkManagerImpl.class);
    private static final String FUSION_PLUGIN_KEY = "com.atlassian.jira.plugins.jira-development-integration-plugin";
    private final ApplicationLinkService applicationLinkService;
    private final EventPublisher eventPublisher;
    private final PluginAccessor pluginAccessor;
    private final LinkedApplicationCapabilities linkedApplicationCapabilities;
    private final BuildUtilsInfo jiraBuildInfo;
    private final FeatureManager featureManager;
    private final DevStatusSupportedAppLinksServiceAccessor devStatusSupportedAppLinksServiceAccessor;
    private final ResettableLazyReference<Map<String, ApplicationId>> projectApplicationLinks = new ResettableLazyReference<Map<String, ApplicationId>>(){

        protected Map<String, ApplicationId> create() {
            HashMap<String, ApplicationId> map = new HashMap<String, ApplicationId>();
            for (ApplicationLink applink : BambooApplicationLinkManagerImpl.this.getApplicationLinks(BambooApplicationLinkManager.Filter.UNFILTERED)) {
                Object projectKeys = applink.getProperty(BambooApplicationLinkManagerImpl.JBAM_ASSOCIATIONS);
                if (projectKeys == null) continue;
                List projectKeyList = (List)projectKeys;
                for (String projectKey : projectKeyList) {
                    map.put(projectKey, applink.getId());
                }
            }
            return map;
        }
    };
    private final Predicate<ApplicationLink> hasDevStatusSummaryCapability = new Predicate<ApplicationLink>(){

        public boolean apply(@Nullable ApplicationLink input) {
            DevStatusSupportedApplicationLinkService devStatusSupportedApplicationLinkService = (DevStatusSupportedApplicationLinkService)BambooApplicationLinkManagerImpl.this.devStatusSupportedAppLinksServiceAccessor.getService();
            return input != null && devStatusSupportedApplicationLinkService != null && devStatusSupportedApplicationLinkService.hasApplicationLink2LOSupport(input);
        }
    };
    private final Predicate<ApplicationLink> hasDeploymentDetailsCapability = new Predicate<ApplicationLink>(){

        public boolean apply(@Nullable ApplicationLink input) {
            Set capable = BambooApplicationLinkManagerImpl.this.linkedApplicationCapabilities.capableOf(BambooApplicationLinkManagerImpl.DEV_STATUS_DETAIL_DEPLOYMENT_ENVIRONMENT_CAPABILITY);
            return input != null && Iterables.any((Iterable)capable, (Predicate)new IsApplicationLinkIdEqual(input));
        }
    };

    @Autowired
    public BambooApplicationLinkManagerImpl(@ComponentImport @Qualifier(value="applicationLinkService") ApplicationLinkService applicationLinkService, @ComponentImport BuildUtilsInfo jiraBuildInfo, @ComponentImport EventPublisher eventPublisher, @ComponentImport FeatureManager featureManager, @ComponentImport LinkedApplicationCapabilities linkedApplicationCapabilities, @ComponentImport PluginAccessor pluginAccessor, DevStatusSupportedAppLinksServiceAccessor devStatusSupportedAppLinksServiceAccessor) {
        this.applicationLinkService = (ApplicationLinkService)Preconditions.checkNotNull((Object)applicationLinkService);
        this.devStatusSupportedAppLinksServiceAccessor = (DevStatusSupportedAppLinksServiceAccessor)Preconditions.checkNotNull((Object)devStatusSupportedAppLinksServiceAccessor);
        this.eventPublisher = (EventPublisher)Preconditions.checkNotNull((Object)eventPublisher);
        this.featureManager = (FeatureManager)Preconditions.checkNotNull((Object)featureManager);
        this.jiraBuildInfo = (BuildUtilsInfo)Preconditions.checkNotNull((Object)jiraBuildInfo);
        this.linkedApplicationCapabilities = (LinkedApplicationCapabilities)Preconditions.checkNotNull((Object)linkedApplicationCapabilities);
        this.pluginAccessor = (PluginAccessor)Preconditions.checkNotNull((Object)pluginAccessor);
    }

    @Override
    public boolean hasApplicationLinks(@Nonnull BambooApplicationLinkManager.Filter filter) {
        return !Iterables.isEmpty(this.getApplicationLinks(filter));
    }

    @Override
    public Iterable<ApplicationLink> getApplicationLinks(@Nonnull BambooApplicationLinkManager.Filter filter) {
        Iterable unfiltered = this.applicationLinkService.getApplicationLinks(BambooApplicationType.class);
        if (this.shouldFilterBambooApplinks()) {
            switch (filter) {
                case SKIP_LINKS_WITH_BUILD_SUMMARY_CAPABILITY_IF_FUSION_ENABLED: {
                    return Iterables.filter((Iterable)unfiltered, (Predicate)Predicates.not(this.hasDevStatusSummaryCapability));
                }
                case SKIP_LINKS_WITH_DEPLOYMENT_SUMMARY_CAPABILITY_IF_FUSION_ENABLED: {
                    return Iterables.filter((Iterable)unfiltered, (Predicate)Predicates.or((Predicate)Predicates.not(this.hasDevStatusSummaryCapability), (Predicate)Predicates.not(this.hasDeploymentDetailsCapability)));
                }
            }
        }
        return unfiltered;
    }

    @Override
    public int getApplicationLinkCount(@Nonnull BambooApplicationLinkManager.Filter filter) {
        return Iterables.size(this.getApplicationLinks(filter));
    }

    @Override
    public ApplicationLink getApplicationLink(String projectKey) {
        Map applicationIdMap = (Map)this.projectApplicationLinks.get();
        if (applicationIdMap.containsKey(projectKey)) {
            ApplicationId appId = (ApplicationId)applicationIdMap.get(projectKey);
            try {
                return this.applicationLinkService.getApplicationLink(appId);
            }
            catch (TypeNotInstalledException e) {
                log.warn((Object)("Application link cannot be found for project '" + projectKey + "' and applicationId '" + appId + "'."));
            }
        }
        return this.getDefaultApplicationLink();
    }

    @Override
    public boolean hasValidApplicationLinkForIssueBuildPanel(String projectKey) {
        ApplicationLink applicationLink = this.getApplicationLink(projectKey);
        return applicationLink != null && (!this.shouldFilterBambooApplinks() || !this.hasDevStatusSummaryCapability.apply((Object)applicationLink));
    }

    @Override
    public ApplicationLink getBambooApplicationLink(String appId) {
        try {
            ApplicationLink applicationLink = this.applicationLinkService.getApplicationLink(new ApplicationId(appId));
            if (!BambooApplicationType.class.isAssignableFrom(applicationLink.getType().getClass())) {
                return null;
            }
            return applicationLink;
        }
        catch (TypeNotInstalledException e) {
            return null;
        }
    }

    @Override
    public Iterable<String> getProjects(String appId) {
        ApplicationLink applink = this.lookupApplicationLink(new ApplicationId(appId));
        Object projectKeys = applink.getProperty(JBAM_ASSOCIATIONS);
        if (projectKeys == null) {
            return ImmutableList.of();
        }
        return (List)projectKeys;
    }

    @Override
    public boolean hasAssociatedProjects(String appId) {
        return !Iterables.isEmpty(this.getProjects(appId));
    }

    @Override
    public boolean hasAssociatedApplicationLink(String projectKey) {
        return ((Map)this.projectApplicationLinks.get()).containsKey(projectKey);
    }

    @Override
    public boolean isAssociated(String projectKey, ApplicationId applicationId) {
        Map applicationIdMap = (Map)this.projectApplicationLinks.get();
        return applicationIdMap.containsKey(projectKey) && ((ApplicationId)applicationIdMap.get(projectKey)).equals((Object)applicationId);
    }

    @Override
    public void associate(String projectKey, ApplicationId appId) {
        ApplicationLink applink = this.lookupApplicationLink(appId);
        Object projectKeys = applink.getProperty(JBAM_ASSOCIATIONS);
        if (projectKeys == null) {
            applink.putProperty(JBAM_ASSOCIATIONS, (Object)ImmutableList.of((Object)projectKey));
        } else {
            List projectKeysList = (List)projectKeys;
            applink.putProperty(JBAM_ASSOCIATIONS, (Object)ImmutableList.builder().addAll((Iterable)projectKeysList).add((Object)projectKey).build());
        }
        this.projectApplicationLinks.reset();
        log.info((Object)("Associated project '" + projectKey + "' with application link '" + appId + "'."));
    }

    @Override
    public void unassociateAll(ApplicationId appId) {
        ApplicationLink applink = this.lookupApplicationLink(appId);
        Object projectKeys = applink.getProperty(JBAM_ASSOCIATIONS);
        if (projectKeys != null) {
            this.projectApplicationLinks.reset();
            applink.removeProperty(JBAM_ASSOCIATIONS);
        }
        log.info((Object)("Unassociated all projects with application link '" + appId + "'."));
    }

    @EventListener
    public void onEvent(ClearCacheEvent event) {
        this.projectApplicationLinks.reset();
    }

    @EventListener
    public void onEvent(ApplicationLinksIDChangedEvent event) {
        Object associations = event.getApplicationLink().getProperty(JBAM_ASSOCIATIONS);
        if (associations != null) {
            this.projectApplicationLinks.reset();
        }
    }

    private ApplicationLink lookupApplicationLink(ApplicationId appId) {
        try {
            return this.applicationLinkService.getApplicationLink(appId);
        }
        catch (TypeNotInstalledException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    private ApplicationLink getDefaultApplicationLink() {
        return this.applicationLinkService.getPrimaryApplicationLink(BambooApplicationType.class);
    }

    protected boolean shouldFilterBambooApplinks() {
        return this.jiraBuildInfo.getApplicationBuildNumber() >= 6200 && this.pluginAccessor.getEnabledPlugin(FUSION_PLUGIN_KEY) != null && !this.featureManager.getDarkFeatures().isFeatureEnabled(ENFORCE_JBAM_FEATURE);
    }

    private class IsApplicationLinkIdEqual
    implements Predicate<LinkedAppWithCapabilities> {
        private final ApplicationLink applicationLink;

        private IsApplicationLinkIdEqual(ApplicationLink applicationLink) {
            this.applicationLink = applicationLink;
        }

        public boolean apply(@Nullable LinkedAppWithCapabilities input) {
            return input != null && input.getApplicationLinkId().equals(this.applicationLink.getId().toString());
        }
    }
}

