/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.web.servlet.plugin.request;

import com.atlassian.web.servlet.api.ServletForwarder;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectInterceptingResponse
extends HttpServletResponseWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(RedirectInterceptingResponse.class);
    private static final URI ROOT_PATH = URI.create("/");
    private static final String SEND_REDIRECT_ONGOING = RedirectInterceptingResponse.class.getName() + ".sendRedirect";
    private final Supplier<Optional<ServletForwarder>> forwarder;
    private final HttpServletRequest request;
    private final HttpServletResponse response;

    public RedirectInterceptingResponse(HttpServletResponse response, Supplier<Optional<ServletForwarder>> forwarder, HttpServletRequest request) {
        super(response);
        this.forwarder = forwarder;
        this.request = request;
        this.response = response;
    }

    public void sendRedirect(String location) throws IOException {
        boolean forwarded = this.forward(location);
        if (!forwarded) {
            this.request.setAttribute(SEND_REDIRECT_ONGOING, (Object)Boolean.TRUE);
            super.sendRedirect(location);
            this.request.setAttribute(SEND_REDIRECT_ONGOING, (Object)Boolean.FALSE);
        }
    }

    private boolean forward(String location) {
        if (Boolean.TRUE == this.request.getAttribute(SEND_REDIRECT_ONGOING)) {
            return false;
        }
        return this.locationWithinCurrentContext(location).flatMap(this::removeContextPrefix).flatMap(uri -> this.forwarder.get().map(fwd -> fwd.forwardSafely(this.request, this.response, uri))).orElse(false);
    }

    private Optional<URI> locationWithinCurrentContext(String location) {
        try {
            return Optional.of(new URI(location)).filter(this::isPathInCurrentContext);
        }
        catch (URISyntaxException e) {
            LOG.warn("Invalid location: " + location, (Throwable)e);
            return Optional.empty();
        }
    }

    private boolean isPathInCurrentContext(URI location) {
        String contextPath = this.request.getContextPath();
        return location.getRawPath().startsWith(contextPath) || !location.getRawPath().startsWith("/");
    }

    private Optional<URI> removeContextPrefix(URI relativeLocation) {
        Optional<URI> contextFreeLocation;
        try {
            URI contextUri = new URI(this.request.getContextPath());
            URI locationRelativeToContext = contextUri.relativize(relativeLocation);
            contextFreeLocation = locationRelativeToContext.equals(relativeLocation) ? Optional.of(relativeLocation) : Optional.of(ROOT_PATH.resolve(locationRelativeToContext));
        }
        catch (URISyntaxException e) {
            LOG.warn("Invalid context path: " + this.request.getContextPath(), (Throwable)e);
            contextFreeLocation = Optional.empty();
        }
        return contextFreeLocation;
    }
}

