/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.web.servlet.plugin;

import com.atlassian.uri.Uri;
import com.atlassian.uri.UriBuilder;
import com.atlassian.web.servlet.api.ServletForwarder;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Qualifier(value="SANITIZING")
@Component
public class SanitizingServletForwarder
implements ServletForwarder {
    public static final String QUALIFIER = "SANITIZING";
    private final ServletForwarder forwarder;

    @Autowired
    public SanitizingServletForwarder(@Qualifier(value="AUTHORIZING") ServletForwarder forwarder) {
        this.forwarder = forwarder;
    }

    public void forward(HttpServletRequest request, HttpServletResponse response, URI location) {
        this.forwarder.forward(request, response, this.sanitize(location));
    }

    private URI sanitize(URI forwardTarget) {
        return new UriBuilder(Uri.fromJavaUri(forwardTarget)).setFragment(null).toUri().toJavaUri();
    }

    public boolean forwardSafely(HttpServletRequest request, HttpServletResponse response, URI location) {
        return this.forwarder.forwardSafely(request, response, this.sanitize(location));
    }
}

