/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.web.servlet.plugin;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.web.servlet.api.ServletForwarder;
import java.net.URI;
import java.util.Optional;
import java.util.function.Consumer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@ExportAsService(value={RememberingServletForwarder.class})
@Qualifier(value="REMEMBERING")
@Component
public class RememberingServletForwarder
implements ServletForwarder {
    public static final String QUALIFIER = "REMEMBERING";
    private final ThreadLocal<Optional<URI>> lastLocation = ThreadLocal.withInitial(Optional::empty);
    private final ServletForwarder forwarder;

    @Autowired
    public RememberingServletForwarder(@Qualifier(value="SANITIZING") ServletForwarder forwarder) {
        this.forwarder = forwarder;
    }

    public void forward(HttpServletRequest request, HttpServletResponse response, URI location) {
        this.rememberLastLocation(location);
        this.forwarder.forward(request, response, location);
    }

    private void rememberLastLocation(URI location) {
        this.lastLocation.set(Optional.of(location));
    }

    public boolean forwardSafely(HttpServletRequest request, HttpServletResponse response, URI location) {
        Optional<URI> previousLastLocation = this.lastLocation.get();
        this.rememberLastLocation(location);
        if (this.forwarder.forwardSafely(request, response, location)) {
            return true;
        }
        this.lastLocation.set(previousLastLocation);
        return false;
    }

    public void forgetLastLocation() {
        this.lastLocation.remove();
    }

    public void consumeLastLocation(Consumer<URI> consumer) {
        this.lastLocation.get().ifPresent(consumer);
    }
}

