/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira.upgrade;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.upgrade.util.LegacyPortletUpgradeTask;
import com.atlassian.jira.upgrade.util.SimpleLegacyPortletUpgradeTask;
import com.opensymphony.module.propertyset.PropertySet;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityStreamPortletUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(ActivityStreamPortletUpgradeTask.class);
    private static final String ORIGINAL_PORTLET_PLUGIN_KEY = "com.atlassian.studio.jira-streams";
    private static final String RENAMED_PORTLET_KEY = "com.atlassian.streams.streams-jira-plugin:activityfeed";
    private static final URI GADGET_URI = URI.create("rest/gadgets/1.0/g/com.atlassian.streams.streams-jira-plugin:activitystream-gadget/gadgets/activitystream-gadget.xml");
    private static final String PROJECT_ID_KEY = "projectid";
    private static final String PROJECT_KEY_KEY = "keys";
    private final LegacyPortletUpgradeTask internalPortletUpgradeTask;

    public ActivityStreamPortletUpgradeTask(final ProjectManager projectManager) {
        this.internalPortletUpgradeTask = new SimpleLegacyPortletUpgradeTask(null, GADGET_URI){

            public Map<String, String> convertUserPrefs(PropertySet propertySet) {
                Map userPrefs = super.convertUserPrefs(propertySet);
                if (userPrefs.containsKey(ActivityStreamPortletUpgradeTask.PROJECT_ID_KEY)) {
                    String[] projectids = ((String)userPrefs.get(ActivityStreamPortletUpgradeTask.PROJECT_ID_KEY)).split("\\|");
                    ArrayList<String> keys = new ArrayList<String>();
                    for (String idString : projectids) {
                        if (idString.trim().length() <= 0) continue;
                        try {
                            long projectId = Long.parseLong(idString);
                            Project project = projectManager.getProjectObj(Long.valueOf(projectId));
                            if (project == null) continue;
                            keys.add(project.getKey());
                        }
                        catch (NumberFormatException nfe) {
                            log.warn("Bad project ids value found: " + idString + ". This portlet configuration may not be migrated properly.");
                        }
                    }
                    if (keys.size() > 0) {
                        StringBuffer sb = new StringBuffer();
                        String sep = "";
                        for (String key : keys) {
                            sb.append(sep);
                            sb.append(key);
                            sep = "|";
                        }
                        userPrefs.put(ActivityStreamPortletUpgradeTask.PROJECT_KEY_KEY, sb.toString());
                    }
                }
                return userPrefs;
            }
        };
    }

    public boolean canUpgrade(String portletKey) {
        return portletKey != null && (portletKey.startsWith(ORIGINAL_PORTLET_PLUGIN_KEY) || portletKey.startsWith(RENAMED_PORTLET_KEY));
    }

    public Map<String, String> convertUserPrefs(PropertySet propertySet) {
        return this.internalPortletUpgradeTask.convertUserPrefs(propertySet);
    }

    public URI getGadgetUri() {
        return GADGET_URI;
    }
}

