/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira.renderer;

import com.atlassian.jira.issue.Issue;
import com.atlassian.streams.api.Html;
import com.atlassian.streams.api.StreamsEntry;
import com.atlassian.streams.api.common.Option;
import com.atlassian.streams.api.renderer.StreamsEntryRendererFactory;
import com.atlassian.streams.spi.renderer.Renderers;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class IssueActivityObjectRendererFactory {
    private final TemplateRenderer templateRenderer;
    private final StreamsEntryRendererFactory rendererFactory;

    public IssueActivityObjectRendererFactory(TemplateRenderer templateRenderer, StreamsEntryRendererFactory rendererFactory) {
        this.templateRenderer = (TemplateRenderer)Preconditions.checkNotNull((Object)templateRenderer, (Object)"templateRenderer");
        this.rendererFactory = (StreamsEntryRendererFactory)Preconditions.checkNotNull((Object)rendererFactory, (Object)"rendererFactory");
    }

    public Function<Iterable<StreamsEntry.ActivityObject>, Option<Html>> newIssueActivityObjectsRenderer(Issue issue) {
        return this.rendererFactory.newActivityObjectsRenderer(this.newIssueActivityObjectRendererWithSummary(issue));
    }

    public Function<StreamsEntry.ActivityObject, Option<Html>> newIssueActivityObjectRendererWithSummary(Issue issue) {
        return new IssueActivityObjectRenderer(issue, true);
    }

    public Function<StreamsEntry.ActivityObject, Option<Html>> newIssueActivityObjectRendererWithoutSummary(Issue issue) {
        return new IssueActivityObjectRenderer(issue, false);
    }

    private final class IssueActivityObjectRenderer
    implements Function<StreamsEntry.ActivityObject, Option<Html>> {
        private final Issue issue;
        private final boolean withSummary;

        public IssueActivityObjectRenderer(Issue issue, boolean withSummary) {
            this.issue = issue;
            this.withSummary = withSummary;
        }

        public Option<Html> apply(StreamsEntry.ActivityObject o) {
            return o.getTitle().map(this.render(o));
        }

        private Function<String, Html> render(final StreamsEntry.ActivityObject o) {
            return new Function<String, Html>(){

                public Html apply(String title) {
                    return new Html(Renderers.render((TemplateRenderer)IssueActivityObjectRendererFactory.this.templateRenderer, (String)"activity-object-link-issue.vm", (Map)ImmutableMap.of((Object)"activityObject", (Object)o, (Object)"issue", (Object)IssueActivityObjectRenderer.this.issue, (Object)"withSummary", (Object)IssueActivityObjectRenderer.this.withSummary)));
                }
            };
        }
    }
}

