/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira.renderer;

import com.atlassian.jira.issue.changehistory.metadata.HistoryMetadata;
import com.atlassian.jira.issue.changehistory.metadata.HistoryMetadataParticipant;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.streams.api.Html;
import com.atlassian.streams.api.StreamsEntry;
import com.atlassian.streams.api.UserProfile;
import com.atlassian.streams.api.common.NonEmptyIterable;
import com.atlassian.streams.api.common.NonEmptyIterables;
import com.atlassian.streams.api.common.Option;
import com.atlassian.streams.api.renderer.StreamsEntryRendererFactory;
import com.atlassian.streams.spi.renderer.Renderers;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringEscapeUtils;

public class HistoryMetadataRendererFactory {
    private final I18nResolver i18nResolver;
    private final StreamsEntryRendererFactory streamsEntryRendererFactory;
    private final Function<HistoryMetadataParticipant, Html> participantRenderer;

    public HistoryMetadataRendererFactory(I18nResolver i18nResolver, StreamsEntryRendererFactory streamsEntryRendererFactory, TemplateRenderer templateRenderer) {
        this(i18nResolver, streamsEntryRendererFactory, HistoryMetadataRendererFactory.newParticipantRenderer(templateRenderer, i18nResolver));
    }

    protected HistoryMetadataRendererFactory(I18nResolver i18nResolver, StreamsEntryRendererFactory streamsEntryRendererFactory, Function<HistoryMetadataParticipant, Html> participantRenderer) {
        this.i18nResolver = (I18nResolver)Preconditions.checkNotNull((Object)i18nResolver, (Object)"i18nResolver");
        this.streamsEntryRendererFactory = (StreamsEntryRendererFactory)Preconditions.checkNotNull((Object)streamsEntryRendererFactory, (Object)"streamsEntryRendererFactory");
        this.participantRenderer = (Function)Preconditions.checkNotNull(participantRenderer, (Object)"participantRenderer");
    }

    public StreamsEntry.Renderer newSuffixRenderer(final StreamsEntry originalEntry, final String suffix) {
        return new StreamsEntry.Renderer(){

            public Html renderTitleAsHtml(StreamsEntry entry) {
                return new Html(originalEntry.renderTitleAsHtml() + " " + StringEscapeUtils.escapeHtml((String)suffix));
            }

            public Option<Html> renderSummaryAsHtml(StreamsEntry entry) {
                return originalEntry.renderSummaryAsHtml();
            }

            public Option<Html> renderContentAsHtml(StreamsEntry entry) {
                return originalEntry.renderContentAsHtml();
            }
        };
    }

    private static Function<HistoryMetadataParticipant, Html> newParticipantRenderer(final TemplateRenderer templateRenderer, final I18nResolver i18nResolver) {
        Preconditions.checkNotNull((Object)templateRenderer, (Object)"templateRenderer");
        Preconditions.checkNotNull((Object)i18nResolver, (Object)"i18nResolver");
        return new Function<HistoryMetadataParticipant, Html>(){

            public Html apply(@Nullable HistoryMetadataParticipant participant) {
                if (participant != null) {
                    return new Html(Renderers.render((TemplateRenderer)templateRenderer, (String)"jira-history-participant.vm", (Map)ImmutableMap.of((Object)"i18n", (Object)i18nResolver, (Object)"participant", (Object)participant)).trim());
                }
                return new Html("");
            }
        };
    }

    public StreamsEntry.Renderer newCustomKeyRenderer(final StreamsEntry originalEntry, final HistoryMetadata historyMetadata) {
        return new StreamsEntry.Renderer(){

            public Html renderTitleAsHtml(StreamsEntry entry) {
                String descriptionKey = historyMetadata.getActivityDescriptionKey();
                Html generatorDisplayName = (Html)HistoryMetadataRendererFactory.this.participantRenderer.apply((Object)historyMetadata.getGenerator());
                Html causeDisplayName = (Html)HistoryMetadataRendererFactory.this.participantRenderer.apply((Object)historyMetadata.getCause());
                NonEmptyIterable emptyAuthor = (NonEmptyIterable)NonEmptyIterables.from(Collections.singleton(new UserProfile.Builder("").build())).get();
                return new Html(HistoryMetadataRendererFactory.this.i18nResolver.getText(descriptionKey, new Serializable[]{originalEntry.renderTitleAsHtml(), (Serializable)HistoryMetadataRendererFactory.this.streamsEntryRendererFactory.newAuthorsRenderer().apply((Object)originalEntry.getAuthors()), new StreamsEntry(StreamsEntry.params((StreamsEntry)originalEntry).authors(emptyAuthor), HistoryMetadataRendererFactory.this.i18nResolver).renderTitleAsHtml(), generatorDisplayName, causeDisplayName}));
            }

            public Option<Html> renderSummaryAsHtml(StreamsEntry entry) {
                return originalEntry.renderSummaryAsHtml();
            }

            public Option<Html> renderContentAsHtml(StreamsEntry entry) {
                return originalEntry.renderContentAsHtml();
            }
        };
    }
}

