/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira.renderer;

import com.atlassian.jira.issue.Issue;
import com.atlassian.streams.api.Html;
import com.atlassian.streams.api.StreamsEntry;
import com.atlassian.streams.api.common.Option;
import com.atlassian.streams.api.renderer.StreamsEntryRendererFactory;
import com.atlassian.streams.jira.JiraHelper;
import com.atlassian.streams.jira.UriProvider;
import com.atlassian.streams.jira.renderer.IssueActivityObjectRendererFactory;
import com.atlassian.streams.spi.renderer.Renderers;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;

public class CreatedIssueRendererFactory {
    private final StreamsEntryRendererFactory rendererFactory;
    private final IssueActivityObjectRendererFactory issueActivityObjectRendererFactory;
    private final TemplateRenderer templateRenderer;
    private final UriProvider uriProvider;
    private final JiraHelper helper;

    public CreatedIssueRendererFactory(StreamsEntryRendererFactory rendererFactory, IssueActivityObjectRendererFactory issueActivityObjectRendererFactory, TemplateRenderer templateRenderer, UriProvider uriProvider, JiraHelper helper) {
        this.rendererFactory = (StreamsEntryRendererFactory)Preconditions.checkNotNull((Object)rendererFactory, (Object)"rendererFactory");
        this.issueActivityObjectRendererFactory = (IssueActivityObjectRendererFactory)Preconditions.checkNotNull((Object)issueActivityObjectRendererFactory, (Object)"issueActivityObjectRendererFactory");
        this.templateRenderer = (TemplateRenderer)Preconditions.checkNotNull((Object)templateRenderer, (Object)"templateRenderer");
        this.uriProvider = (UriProvider)Preconditions.checkNotNull((Object)uriProvider, (Object)"uriProvider");
        this.helper = (JiraHelper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
    }

    public StreamsEntry.Renderer newInstance(Issue issue, URI baseUri, Option<String> initialDescription) {
        return new CreatedRenderer(issue, baseUri, initialDescription);
    }

    private final class CreatedRenderer
    implements StreamsEntry.Renderer {
        private final Function<StreamsEntry, Html> titleRenderer;
        private final Function<Boolean, Option<Html>> renderDescription;

        public CreatedRenderer(Issue issue, URI baseUri, Option<String> initialDescription) {
            this.titleRenderer = CreatedIssueRendererFactory.this.rendererFactory.newTitleRenderer("streams.item.jira.issue.post", CreatedIssueRendererFactory.this.rendererFactory.newAuthorsRenderer(), Option.some(CreatedIssueRendererFactory.this.issueActivityObjectRendererFactory.newIssueActivityObjectsRenderer(issue)), Option.some((Object)CreatedIssueRendererFactory.this.rendererFactory.newActivityObjectRendererWithSummary()));
            this.renderDescription = this.renderDescription(issue, baseUri, initialDescription);
        }

        public Option<Html> renderContentAsHtml(StreamsEntry entry) {
            return (Option)this.renderDescription.apply((Object)false);
        }

        public Option<Html> renderSummaryAsHtml(StreamsEntry entry) {
            return (Option)this.renderDescription.apply((Object)true);
        }

        public Html renderTitleAsHtml(StreamsEntry entry) {
            return (Html)this.titleRenderer.apply((Object)entry);
        }

        private Function<Boolean, Option<Html>> renderDescription(final Issue issue, final URI baseUri, Option<String> initialDescription) {
            final Option description = Option.option((Object)CreatedIssueRendererFactory.this.helper.renderIssueFieldValue(issue, "description", (String)initialDescription.getOrElse((Object)""))).flatMap(Html.trimHtmlToNone());
            return new Function<Boolean, Option<Html>>(){

                public Option<Html> apply(Boolean truncate) {
                    return description.flatMap(this.renderContent(truncate));
                }

                private Function<Html, Option<Html>> renderContent(final boolean truncate) {
                    return new Function<Html, Option<Html>>(){

                        public Option<Html> apply(Html d) {
                            Html description;
                            Html html = description = truncate ? Renderers.truncate((int)250, (Html)d) : d;
                            if (truncate && d.equals((Object)description)) {
                                return Option.none();
                            }
                            ImmutableMap context = ImmutableMap.builder().put((Object)"contentHtml", (Object)description).put((Object)"truncated", (Object)truncate).put((Object)"contentUri", (Object)CreatedIssueRendererFactory.this.uriProvider.getIssueUri(baseUri, issue.getKey())).build();
                            return Option.some((Object)new Html(Renderers.render((TemplateRenderer)CreatedIssueRendererFactory.this.templateRenderer, (String)"jira-content-block.vm", (Map)context)));
                        }
                    };
                }
            };
        }
    }
}

