/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira.renderer;

import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.streams.api.Html;
import com.atlassian.streams.api.StreamsEntry;
import com.atlassian.streams.api.common.Option;
import com.atlassian.streams.api.renderer.StreamsEntryRendererFactory;
import com.atlassian.streams.jira.JiraActivityItem;
import com.atlassian.streams.jira.JiraHelper;
import com.atlassian.streams.jira.renderer.IssueActivityObjectRendererFactory;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;

public class CommentRendererFactory {
    private final StreamsEntryRendererFactory rendererFactory;
    private final IssueActivityObjectRendererFactory issueActivityObjectRendererFactory;
    private final JiraHelper helper;

    public CommentRendererFactory(StreamsEntryRendererFactory rendererFactory, IssueActivityObjectRendererFactory issueActivityObjectRendererFactory, JiraHelper helper) {
        this.rendererFactory = (StreamsEntryRendererFactory)Preconditions.checkNotNull((Object)rendererFactory, (Object)"rendererFactory");
        this.issueActivityObjectRendererFactory = (IssueActivityObjectRendererFactory)Preconditions.checkNotNull((Object)issueActivityObjectRendererFactory, (Object)"issueActivityObjectRendererFactory");
        this.helper = (JiraHelper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
    }

    public StreamsEntry.Renderer newInstance(JiraActivityItem item, Comment comment) {
        return this.rendererFactory.newCommentRenderer((Function)new IssueCommentTitleRenderer(item), (Html)this.helper.renderComment().apply((Object)comment));
    }

    private final class IssueCommentTitleRenderer
    implements Function<StreamsEntry, Html> {
        private final JiraActivityItem item;

        public IssueCommentTitleRenderer(JiraActivityItem item) {
            this.item = item;
        }

        public Html apply(StreamsEntry entry) {
            String key = entry.getTarget().isDefined() ? "streams.title.commented.on" : "streams.title.commented";
            return (Html)this.newIssueTitleRenderer(this.item, key).apply((Object)entry);
        }

        private Function<StreamsEntry, Html> newIssueTitleRenderer(JiraActivityItem item, String key) {
            return CommentRendererFactory.this.rendererFactory.newTitleRenderer(key, CommentRendererFactory.this.rendererFactory.newAuthorsRenderer(), Option.some(CommentRendererFactory.this.issueActivityObjectRendererFactory.newIssueActivityObjectsRenderer(item.getIssue())), Option.some(CommentRendererFactory.this.issueActivityObjectRendererFactory.newIssueActivityObjectRendererWithSummary(item.getIssue())));
        }
    }
}

