/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira.portlet;

import com.atlassian.gadgets.GadgetId;
import com.atlassian.gadgets.GadgetRequestContextFactory;
import com.atlassian.gadgets.GadgetState;
import com.atlassian.gadgets.view.GadgetViewFactory;
import com.atlassian.gadgets.view.ModuleId;
import com.atlassian.gadgets.view.View;
import com.atlassian.gadgets.view.ViewType;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.issuetabpanel.AbstractIssueAction;
import com.atlassian.jira.plugin.issuetabpanel.AbstractIssueTabPanel;
import com.atlassian.jira.plugin.issuetabpanel.IssueAction;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;
import webwork.action.ActionContext;

public class ActivityStreamIssueTab
extends AbstractIssueTabPanel {
    public static final String USER_PROFILE_STREAM_TITLE = "user.profile.stream.panel.title";
    private static final String PREF_IS_CONFIGURED = "isConfigured";
    private static final String GADGET_URI = "rest/gadgets/1.0/g/com.atlassian.streams.streams-jira-plugin/gadgets/activitystream-gadget.xml";
    private static final String PREF_NUMOFENTRIES = "numofentries";
    private static final String NUMOFENTRIES = "20";
    private static final String PREF_IS_CONFIGURABLE = "isConfigurable";
    private static final String RULES_PREF = "rules";
    private final WebResourceManager webResourceManager;
    private final GadgetViewFactory gadgetViewFactory;
    private final GadgetRequestContextFactory gadgetRequestContextFactory;
    private static final String PREF_TITLE_REQUIRED = "titleRequired";
    private static final String PREF_IS_CUSTOMIZED = "isCustomized";
    private static final String PREF_IS_REALLY_CONFIGURED = "isReallyConfigured";
    private static final String PREF_CONTEXT = "renderingContext";
    private static final String CONTEXT = "view-issue";
    private static final String ISSUE_TAB_VIEW_NAME = "issueTab";

    public ActivityStreamIssueTab(WebResourceManager webResourceManager, GadgetViewFactory gadgetViewFactory, GadgetRequestContextFactory gadgetRequestContextFactory) {
        this.webResourceManager = webResourceManager;
        this.gadgetViewFactory = gadgetViewFactory;
        this.gadgetRequestContextFactory = gadgetRequestContextFactory;
    }

    public List<IssueAction> getActions(Issue issue, ApplicationUser user) {
        ArrayList<IssueAction> l = new ArrayList<IssueAction>(1);
        l.add(this.createIssueAction(issue));
        return l;
    }

    private IssueAction createIssueAction(final Issue issue) {
        return new AbstractIssueAction(this.descriptor){

            public Date getTimePerformed() {
                return new Date();
            }

            public boolean isDisplayActionAllTab() {
                return false;
            }

            protected void populateVelocityParams(Map map) {
                MapBuilder prefsBuilder = MapBuilder.newBuilder();
                prefsBuilder.add((Object)ActivityStreamIssueTab.PREF_IS_CONFIGURED, (Object)Boolean.TRUE.toString());
                prefsBuilder.add((Object)ActivityStreamIssueTab.PREF_IS_CONFIGURABLE, (Object)Boolean.FALSE.toString());
                prefsBuilder.add((Object)ActivityStreamIssueTab.PREF_IS_REALLY_CONFIGURED, (Object)Boolean.TRUE.toString());
                prefsBuilder.add((Object)ActivityStreamIssueTab.PREF_NUMOFENTRIES, (Object)ActivityStreamIssueTab.NUMOFENTRIES);
                prefsBuilder.add((Object)ActivityStreamIssueTab.PREF_TITLE_REQUIRED, (Object)Boolean.FALSE.toString());
                prefsBuilder.add((Object)ActivityStreamIssueTab.PREF_IS_CUSTOMIZED, (Object)Boolean.TRUE.toString());
                prefsBuilder.add((Object)ActivityStreamIssueTab.PREF_CONTEXT, (Object)ActivityStreamIssueTab.CONTEXT);
                try {
                    JSONObject issueKeyRule = new JSONObject().put("provider", (Object)"streams").put("rule", (Object)"issue-key").put("operator", (Object)"is").put("value", (Object)issue.getKey()).put("type", (Object)"string");
                    JSONObject projectRule = new JSONObject().put("provider", (Object)"streams").put("rule", (Object)"key").put("operator", (Object)"is").put("value", (Collection)ImmutableList.of((Object)issue.getProjectObject().getKey())).put("type", (Object)"select");
                    JSONObject globalProvider = new JSONObject().put("provider", (Object)"streams").put(ActivityStreamIssueTab.RULES_PREF, (Collection)ImmutableList.of((Object)issueKeyRule, (Object)projectRule));
                    JSONObject rules = new JSONObject().put("providers", (Collection)ImmutableList.of((Object)globalProvider));
                    prefsBuilder.add((Object)ActivityStreamIssueTab.RULES_PREF, (Object)rules.toString());
                }
                catch (Exception ex) {
                    throw new RuntimeException("Error adding JSON pref", ex);
                }
                GadgetState gadget = GadgetState.gadget((GadgetId)GadgetId.valueOf((String)"stream")).specUri(URI.create(ActivityStreamIssueTab.GADGET_URI)).userPrefs(prefsBuilder.toMap()).build();
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    OutputStreamWriter gadgetWriter = new OutputStreamWriter(baos);
                    View settings = new View.Builder().viewType(ViewType.valueOf((String)ActivityStreamIssueTab.ISSUE_TAB_VIEW_NAME)).writable(false).build();
                    ActivityStreamIssueTab.this.gadgetViewFactory.createGadgetView(gadget, ModuleId.valueOf((long)0L), settings, ActivityStreamIssueTab.this.gadgetRequestContextFactory.get(ActionContext.getRequest())).writeTo((Writer)gadgetWriter);
                    ((Writer)gadgetWriter).flush();
                    prefsBuilder.add((Object)"gadgetHtml", (Object)baos.toString());
                }
                catch (IOException e) {
                    throw new RuntimeException("Error rendering activity stream gadget.", e);
                }
                map.putAll(prefsBuilder.toMap());
            }
        };
    }

    public boolean showPanel(Issue issue, ApplicationUser user) {
        return true;
    }

    static {
        try {
            ViewType.createViewType((String)ISSUE_TAB_VIEW_NAME, (String[])new String[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

