/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira.changehistory;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.changehistory.ChangeHistory;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.streams.jira.changehistory.IssueHistory;
import com.atlassian.streams.jira.changehistory.IssueHistoryReader;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

class SingleIssueHistoryReader
implements IssueHistoryReader {
    private final ChangeHistoryManager changeHistoryManager;

    public SingleIssueHistoryReader(ChangeHistoryManager changeHistoryManager) {
        this.changeHistoryManager = changeHistoryManager;
    }

    @Override
    public Iterable<IssueHistory> getChangeHistoriesForUser(final Iterable<Issue> issues, final ApplicationUser remoteUser) {
        return new Iterable<IssueHistory>(){

            @Override
            public Iterator<IssueHistory> iterator() {
                return new SingleIssueIterator(issues.iterator(), remoteUser);
            }
        };
    }

    private class SingleIssueIterator
    implements Iterator<IssueHistory> {
        private final Iterator<Issue> issues;
        private final ApplicationUser remoteUser;

        public SingleIssueIterator(Iterator<Issue> issues, ApplicationUser remoteUser) {
            this.issues = issues;
            this.remoteUser = remoteUser;
        }

        @Override
        public boolean hasNext() {
            return this.issues.hasNext();
        }

        @Override
        public IssueHistory next() {
            Issue nextIssue = this.issues.next();
            List nextChangeHistories = SingleIssueHistoryReader.this.changeHistoryManager.getChangeHistoriesForUser(nextIssue, this.remoteUser);
            return new IssueHistory(nextIssue, (ImmutableCollection<ChangeHistory>)ImmutableList.copyOf((Collection)nextChangeHistories));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

