/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira.builder;

import com.atlassian.jira.issue.changehistory.metadata.HistoryMetadata;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.streams.api.StreamsEntry;
import com.atlassian.streams.api.common.Option;
import com.atlassian.streams.jira.AggregatedJiraActivityItem;
import com.atlassian.streams.jira.JiraActivityItem;
import com.atlassian.streams.jira.builder.GeneralUpdateEntryBuilder;
import com.atlassian.streams.jira.builder.StatusChangeEntryBuilder;
import com.atlassian.streams.jira.renderer.HistoryMetadataRendererFactory;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.net.URI;
import org.ofbiz.core.entity.GenericValue;

public class HistoryMetadataEntryBuilder {
    private final StatusChangeEntryBuilder statusChangeEntryBuilder;
    private final GeneralUpdateEntryBuilder generalUpdateEntryBuilder;
    private final HistoryMetadataRendererFactory historyMetadataRendererFactory;
    private final I18nResolver i18nResolver;

    public HistoryMetadataEntryBuilder(StatusChangeEntryBuilder statusChangeEntryBuilder, GeneralUpdateEntryBuilder generalUpdateEntryBuilder, HistoryMetadataRendererFactory historyMetadataRendererFactory, I18nResolver i18nResolver) {
        this.statusChangeEntryBuilder = (StatusChangeEntryBuilder)Preconditions.checkNotNull((Object)statusChangeEntryBuilder, (Object)"statusChangeEntryBuilder");
        this.generalUpdateEntryBuilder = (GeneralUpdateEntryBuilder)Preconditions.checkNotNull((Object)generalUpdateEntryBuilder, (Object)"generalUpdateEntryBuilder");
        this.historyMetadataRendererFactory = (HistoryMetadataRendererFactory)Preconditions.checkNotNull((Object)historyMetadataRendererFactory, (Object)"historyMetadataRendererFactory");
        this.i18nResolver = (I18nResolver)Preconditions.checkNotNull((Object)i18nResolver, (Object)"i18nResolver");
    }

    public Option<StreamsEntry> buildStatusChangeEntry(JiraActivityItem item, URI baseUri, GenericValue genericValue) {
        return this.statusChangeEntryBuilder.build(item, baseUri, genericValue).map((Function)new DecorateWithMetadata(item.getHistoryMetadata()));
    }

    public Option<StreamsEntry> buildGeneralUpdateEntry(URI baseUri, AggregatedJiraActivityItem aggregatedItem) {
        return this.generalUpdateEntryBuilder.build(baseUri, aggregatedItem).map((Function)new DecorateWithMetadata(aggregatedItem.getActivityItem().getHistoryMetadata()));
    }

    private final class DecorateWithMetadata
    implements Function<StreamsEntry, StreamsEntry> {
        private final Option<HistoryMetadata> maybeMetadata;

        private DecorateWithMetadata(Option<HistoryMetadata> maybeMetadata) {
            this.maybeMetadata = maybeMetadata;
        }

        public StreamsEntry apply(StreamsEntry original) {
            if (this.maybeMetadata.isDefined()) {
                HistoryMetadata historyMetadata = (HistoryMetadata)this.maybeMetadata.get();
                String descriptionKey = historyMetadata.getActivityDescriptionKey();
                if (!Strings.isNullOrEmpty((String)descriptionKey) && !HistoryMetadataEntryBuilder.this.i18nResolver.getRawText(descriptionKey).equals(descriptionKey)) {
                    return new StreamsEntry(StreamsEntry.params((StreamsEntry)original).renderer(HistoryMetadataEntryBuilder.this.historyMetadataRendererFactory.newCustomKeyRenderer(original, historyMetadata)), HistoryMetadataEntryBuilder.this.i18nResolver);
                }
                if (!Strings.isNullOrEmpty((String)historyMetadata.getActivityDescription())) {
                    return new StreamsEntry(StreamsEntry.params((StreamsEntry)original).renderer(HistoryMetadataEntryBuilder.this.historyMetadataRendererFactory.newSuffixRenderer(original, historyMetadata.getActivityDescription())), HistoryMetadataEntryBuilder.this.i18nResolver);
                }
            }
            return original;
        }
    }
}

