/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira.builder;

import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.streams.api.ActivityRequest;
import com.atlassian.streams.api.ActivityVerbs;
import com.atlassian.streams.api.StreamsEntry;
import com.atlassian.streams.api.common.ImmutableNonEmptyList;
import com.atlassian.streams.api.common.NonEmptyIterable;
import com.atlassian.streams.api.common.Option;
import com.atlassian.streams.jira.JiraActivityItem;
import com.atlassian.streams.jira.JiraHelper;
import com.atlassian.streams.jira.renderer.CommentRendererFactory;
import com.atlassian.streams.spi.StreamsI18nResolver;
import com.atlassian.streams.spi.StreamsUriBuilder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.Iterator;

public class CommentEntryBuilder {
    private static final String COMMENT_CATEGORY = "comment";
    private final JiraHelper helper;
    private final CommentRendererFactory rendererFactory;
    private final StreamsI18nResolver i18nResolver;

    CommentEntryBuilder(JiraHelper helper, CommentRendererFactory rendererFactory, StreamsI18nResolver i18nResolver) {
        this.helper = (JiraHelper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
        this.rendererFactory = (CommentRendererFactory)Preconditions.checkNotNull((Object)rendererFactory, (Object)"rendererFactory");
        this.i18nResolver = (StreamsI18nResolver)Preconditions.checkNotNull((Object)i18nResolver, (Object)"i18nResolver");
    }

    public Option<StreamsEntry> build(JiraActivityItem item, ActivityRequest request) {
        Iterator iterator = item.getComment().iterator();
        if (iterator.hasNext()) {
            Comment comment = (Comment)iterator.next();
            URI baseUri = request.getContextUri();
            return Option.some((Object)new StreamsEntry(this.helper.newCommentBuilder(baseUri, item).authors((NonEmptyIterable)ImmutableNonEmptyList.of((Object)this.helper.getUserProfile(baseUri).apply((Object)JiraHelper.getNameFor(comment.getAuthorApplicationUser())))).categories((Iterable)ImmutableList.of((Object)COMMENT_CATEGORY)).inReplyTo(Option.some((Object)new StreamsUriBuilder().setUrl(this.helper.getIssueUri(baseUri, item).toASCIIString()).getUri())).verb(ActivityVerbs.post()).addActivityObject(this.helper.buildActivityObject(baseUri, comment)).target(Option.some((Object)this.helper.buildActivityObject(comment.getIssue(), baseUri, item.getDisplaySummary()))).renderer(this.rendererFactory.newInstance(item, comment)), (I18nResolver)this.i18nResolver));
        }
        return Option.none();
    }
}

