/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira.builder;

import com.atlassian.jira.issue.changehistory.ChangeHistory;
import com.atlassian.jira.issue.changehistory.metadata.HistoryMetadata;
import com.atlassian.jira.issue.changehistory.metadata.HistoryMetadataManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.streams.api.ActivityRequest;
import com.atlassian.streams.api.ActivityVerb;
import com.atlassian.streams.api.StreamsEntry;
import com.atlassian.streams.api.common.Option;
import com.atlassian.streams.jira.AggregatedJiraActivityItem;
import com.atlassian.streams.jira.ChangeItems;
import com.atlassian.streams.jira.JiraActivityItem;
import com.atlassian.streams.jira.JiraActivityVerbs;
import com.atlassian.streams.jira.builder.HistoryMetadataEntryBuilder;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Iterator;
import org.ofbiz.core.entity.GenericValue;

public class ChangeEntryBuilder {
    private final HistoryMetadataEntryBuilder historyMetadataEntryBuilder;
    private final HistoryMetadataManager historyMetadataManager;
    private final JiraAuthenticationContext authenticationContext;

    ChangeEntryBuilder(HistoryMetadataEntryBuilder historyMetadataEntryBuilder, HistoryMetadataManager historyMetadataManager, JiraAuthenticationContext authenticationContext) {
        this.historyMetadataEntryBuilder = (HistoryMetadataEntryBuilder)Preconditions.checkNotNull((Object)historyMetadataEntryBuilder, (Object)"historyMetadataEntryBuilder");
        this.historyMetadataManager = (HistoryMetadataManager)Preconditions.checkNotNull((Object)historyMetadataManager, (Object)"historyMetadataManager");
        this.authenticationContext = (JiraAuthenticationContext)Preconditions.checkNotNull((Object)authenticationContext, (Object)"authenticationContext");
    }

    public Option<StreamsEntry> build(AggregatedJiraActivityItem aggregatedItem, ActivityRequest request) {
        this.fetchMetadata(aggregatedItem);
        URI baseUri = request.getContextUri();
        if (this.isTransitionVerb(aggregatedItem)) {
            JiraActivityItem item = aggregatedItem.getActivityItem();
            return this.historyMetadataEntryBuilder.buildStatusChangeEntry(item, baseUri, (GenericValue)Iterables.find(ChangeItems.getChangeItems(item), ChangeItems.isStatusUpdate()));
        }
        return this.historyMetadataEntryBuilder.buildGeneralUpdateEntry(baseUri, aggregatedItem);
    }

    private void fetchMetadata(AggregatedJiraActivityItem aggregatedItem) {
        JiraActivityItem activityItem = aggregatedItem.getActivityItem();
        if (activityItem.getChangeHistory().isDefined()) {
            HistoryMetadataManager.HistoryMetadataResult historyMetadata = this.historyMetadataManager.getHistoryMetadata((ChangeHistory)activityItem.getChangeHistory().get(), this.authenticationContext.getUser());
            activityItem.setHistoryMetadata((Option<HistoryMetadata>)Option.option((Object)historyMetadata.getHistoryMetadata()));
        }
    }

    private boolean isTransitionVerb(AggregatedJiraActivityItem aggregatedItem) {
        if (!aggregatedItem.getRelatedActivityItems().isDefined()) {
            ActivityVerb verb = (ActivityVerb)aggregatedItem.getActivity().second();
            if (JiraActivityVerbs.transition().equals(verb)) {
                return true;
            }
            Iterator iterator = verb.parent().iterator();
            if (iterator.hasNext()) {
                ActivityVerb childVerb = (ActivityVerb)iterator.next();
                return JiraActivityVerbs.transition().equals(childVerb);
            }
        }
        return false;
    }
}

