/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira;

import com.atlassian.core.util.thumbnail.Thumbnail;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.streams.api.common.uri.Uris;
import com.atlassian.streams.jira.JiraActivityItem;
import com.google.common.base.Preconditions;
import java.net.URI;

public class UriProvider {
    private static final String ISSUE_URI = "/browse/";
    private final WebResourceManager webResourceManager;

    UriProvider(WebResourceManager webResourceManager) {
        this.webResourceManager = (WebResourceManager)Preconditions.checkNotNull((Object)webResourceManager, (Object)"webResourceManager");
    }

    public URI getIssueUri(URI baseUri, JiraActivityItem activityItem) {
        return this.getIssueUri(baseUri, activityItem.getIssue());
    }

    public URI getIssueUri(URI baseUri, Issue issue) {
        return this.getIssueUri(baseUri, issue.getKey());
    }

    public URI getIssueUri(URI baseUri, String issueKey) {
        return URI.create(this.getIssueUriStr(baseUri, issueKey));
    }

    private String getIssueUriStr(URI baseUri, String issueKey) {
        return baseUri + ISSUE_URI + issueKey;
    }

    public URI getIssueCommentUri(URI baseUri, Comment comment) {
        return URI.create(this.getIssueUriStr(baseUri, comment.getIssue().getKey()) + "?focusedCommentId=" + comment.getId() + "&page=com.atlassian.jira.plugin.system.issuetabpanels:comment-tabpanel#comment-" + comment.getId());
    }

    public URI getAttachmentUri(URI baseUri, Attachment attachment) {
        return URI.create(baseUri.toASCIIString() + "/secure/attachment/" + attachment.getId() + "/" + Uris.encode((String)attachment.getFilename()));
    }

    public URI getThumbnailUri(URI baseUri, Thumbnail thumbnail) {
        return URI.create(baseUri.toASCIIString() + "/secure/thumbnail/" + thumbnail.getAttachmentId() + "/" + Uris.encode((String)thumbnail.getFilename()));
    }

    public URI getComponentUri(URI baseUri, Issue issue, ProjectComponent component) {
        return this.getComponentUri(baseUri, issue.getProjectObject(), component);
    }

    public URI getComponentUri(URI baseUri, Project project, ProjectComponent component) {
        return this.getComponentUri(baseUri, project.getKey(), component.getId());
    }

    public URI getComponentUri(URI baseUri, String projectKey, Long componentId) {
        return URI.create(baseUri.toASCIIString() + ISSUE_URI + projectKey + "/component/" + componentId.toString());
    }

    public URI getFixForVersionUri(URI baseUri, Version version) {
        return this.getFixForVersionUri(baseUri, version.getProjectObject().getKey(), version.getId());
    }

    public URI getFixForVersionUri(URI baseUri, String projectKey, Long versionId) {
        return URI.create(baseUri.toASCIIString() + ISSUE_URI + projectKey + "/fixforversion/" + versionId.toString());
    }

    public URI getWikiRendererCssUri() {
        return URI.create(this.webResourceManager.getStaticPluginResource("jira.webresources:global-static", "wiki-renderer.css", UrlMode.ABSOLUTE)).normalize();
    }

    public URI getBrokenThumbnailUri(URI baseUri) {
        return URI.create(baseUri.toASCIIString() + "/images/broken_thumbnail.png");
    }
}

