/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira;

import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.streams.api.common.Option;
import com.atlassian.streams.spi.EntityResolver;
import com.google.common.base.Preconditions;

public class ProjectEntityResolver
implements EntityResolver {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ProjectService projectService;

    public ProjectEntityResolver(JiraAuthenticationContext jiraAuthenticationContext, ProjectService projectService) {
        this.jiraAuthenticationContext = (JiraAuthenticationContext)Preconditions.checkNotNull((Object)jiraAuthenticationContext);
        this.projectService = (ProjectService)Preconditions.checkNotNull((Object)projectService);
    }

    public Option<Object> apply(String key) {
        ApplicationUser loggedInUser = this.jiraAuthenticationContext.getLoggedInUser();
        ProjectService.GetProjectResult projectByKey = this.projectService.getProjectByKey(loggedInUser, key);
        Option option = projectByKey.isValid() ? Option.some((Object)projectByKey.getProject()) : Option.none();
        return option;
    }
}

