/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira;

import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.EmailFormatter;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.streams.api.UserProfile;
import com.atlassian.streams.api.common.Option;
import com.atlassian.streams.spi.StreamsI18nResolver;
import com.atlassian.streams.spi.UserProfileAccessor;
import com.google.common.base.Preconditions;
import java.net.URI;

public class JiraUserProfileAccessor
implements UserProfileAccessor {
    private static final int AVATAR_PIXELS = AvatarManager.ImageSize.LARGE.getPixels();
    private final ApplicationProperties applicationProperties;
    private final EmailFormatter emailFormatter;
    private final JiraAuthenticationContext authenticationContext;
    private final UserUtil userUtil;
    private final UserManager userManager;
    private final AvatarManager avatarManager;
    private final StreamsI18nResolver i18nResolver;

    public JiraUserProfileAccessor(UserUtil userUtil, ApplicationProperties applicationProperties, EmailFormatter emailFormatter, JiraAuthenticationContext authenticationContext, UserManager userManager, AvatarManager avatarManager, StreamsI18nResolver i18nResolver) {
        this.userUtil = (UserUtil)Preconditions.checkNotNull((Object)userUtil, (Object)"userUtil");
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties, (Object)"applicationProperties");
        this.emailFormatter = (EmailFormatter)Preconditions.checkNotNull((Object)emailFormatter, (Object)"emailFormatter");
        this.authenticationContext = (JiraAuthenticationContext)Preconditions.checkNotNull((Object)authenticationContext, (Object)"authenticationContext");
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager, (Object)"userManager");
        this.avatarManager = (AvatarManager)Preconditions.checkNotNull((Object)avatarManager, (Object)"avatarManager");
        this.i18nResolver = (StreamsI18nResolver)Preconditions.checkNotNull((Object)i18nResolver, (Object)"i18nResolver");
    }

    private URI getUserProfileUri(URI baseUri, String username) {
        String baseUriStr = baseUri == null ? this.applicationProperties.getBaseUrl() : baseUri.toASCIIString();
        return URI.create(baseUriStr + this.userManager.getUserProfile(username).getProfilePageUri().toASCIIString());
    }

    private URI getProfilePictureUri(URI baseUri, String username) {
        URI uri = this.userManager.getUserProfile(username).getProfilePictureUri(AVATAR_PIXELS, AVATAR_PIXELS);
        if (uri != null) {
            if (uri.isAbsolute()) {
                return uri;
            }
            String baseUriStr = baseUri == null ? this.applicationProperties.getBaseUrl() : baseUri.toASCIIString();
            return URI.create(baseUriStr + uri.toString()).normalize();
        }
        return this.getAnonymousProfilePictureUri(baseUri);
    }

    public UserProfile getAnonymousUserProfile(URI baseUri) {
        return new UserProfile.Builder(this.i18nResolver.getText("streams.jira.authors.unknown.username")).fullName(this.i18nResolver.getText("streams.jira.authors.unknown.fullname")).email(Option.none(String.class)).profilePageUri(Option.none(URI.class)).profilePictureUri(Option.some((Object)this.getAnonymousProfilePictureUri(baseUri))).build();
    }

    private URI getAnonymousProfilePictureUri(URI baseUri) {
        String baseUriStr = baseUri == null ? this.applicationProperties.getBaseUrl() : baseUri.toASCIIString();
        return URI.create(baseUriStr + "/secure/useravatar?avatarId=" + this.avatarManager.getAnonymousAvatarId());
    }

    public UserProfile getUserProfile(String username) {
        return this.getUserProfile(URI.create(this.applicationProperties.getBaseUrl()), username);
    }

    public UserProfile getAnonymousUserProfile() {
        return this.getAnonymousUserProfile(URI.create(this.applicationProperties.getBaseUrl()));
    }

    public UserProfile getUserProfile(URI baseUri, String username) {
        if (username == null) {
            return this.getAnonymousUserProfile(baseUri);
        }
        ApplicationUser user = this.userUtil.getUserByName(username);
        if (user != null) {
            String email = this.emailFormatter.emailVisible(this.authenticationContext.getLoggedInUser()) ? user.getEmailAddress() : null;
            return new UserProfile.Builder(username).fullName(user.getDisplayName()).email(Option.option((Object)email)).profilePageUri(Option.some((Object)this.getUserProfileUri(baseUri, username))).profilePictureUri(Option.some((Object)this.getProfilePictureUri(baseUri, username))).build();
        }
        return new UserProfile.Builder(username).profilePictureUri(Option.some((Object)this.getAnonymousProfilePictureUri(baseUri))).build();
    }
}

