/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.streams.spi.StreamsValidator;

public class JiraStreamsValidator
implements StreamsValidator {
    private final ProjectManager projectManager;
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext authenticationContext;

    public JiraStreamsValidator(ProjectManager projectManager, PermissionManager permissionManager, JiraAuthenticationContext authenticationContext) {
        this.projectManager = projectManager;
        this.permissionManager = permissionManager;
        this.authenticationContext = authenticationContext;
    }

    public boolean isValidKey(String key) {
        Project project = this.projectManager.getProjectObjByKey(key);
        return project != null && this.permissionManager.hasPermission(10, project, this.authenticationContext.getUser());
    }
}

