/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira;

import com.atlassian.jira.util.thread.JiraThreadLocalUtil;
import com.atlassian.streams.spi.SessionManager;
import com.google.common.base.Supplier;
import org.apache.log4j.Logger;

public class JiraSessionManager
implements SessionManager {
    private final JiraThreadLocalUtil jiraThreadLocalUtil;
    private static final Logger logger = Logger.getLogger(JiraSessionManager.class);

    public JiraSessionManager(JiraThreadLocalUtil jiraThreadLocalUtil) {
        this.jiraThreadLocalUtil = jiraThreadLocalUtil;
    }

    public <T> T withSession(Supplier<T> s) {
        this.jiraThreadLocalUtil.preCall();
        try {
            Object object = s.get();
            return (T)object;
        }
        finally {
            this.jiraThreadLocalUtil.postCall(logger, null);
        }
    }
}

