/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.vote.VoteManager;
import com.atlassian.jira.issue.watchers.WatcherManager;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.streams.jira.JiraInlineActionHandler;
import com.google.common.collect.Iterables;
import java.util.Objects;

public class JiraInlineActionHandlerImpl
implements JiraInlineActionHandler {
    private final WatcherManager watcherManager;
    private final IssueManager issueManager;
    private final JiraAuthenticationContext authenticationContext;
    private final VoteManager voteManager;
    private final PermissionManager permissionManager;

    public JiraInlineActionHandlerImpl(WatcherManager watcherManager, IssueManager issueManager, JiraAuthenticationContext authenticationContext, VoteManager voteManager, PermissionManager permissionManager) {
        this.watcherManager = Objects.requireNonNull(watcherManager, "watcherManager");
        this.issueManager = Objects.requireNonNull(issueManager, "issueManager");
        this.authenticationContext = Objects.requireNonNull(authenticationContext, "authenticationContext");
        this.voteManager = Objects.requireNonNull(voteManager, "voteManager");
        this.permissionManager = Objects.requireNonNull(permissionManager, "permissionManager");
    }

    @Override
    public boolean startWatching(String issueKey) {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        MutableIssue issue = this.issueManager.getIssueObject(issueKey);
        if (!this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, (Issue)issue, user)) {
            return false;
        }
        int previousWatcherCount = Iterables.size((Iterable)this.watcherManager.getCurrentWatcherUsernames((Issue)issue));
        this.watcherManager.startWatching(user, (Issue)issue);
        int updatedWatcherCount = Iterables.size((Iterable)this.watcherManager.getCurrentWatcherUsernames((Issue)issue));
        return updatedWatcherCount == previousWatcherCount + 1;
    }

    @Override
    public boolean hasPreviouslyWatched(String issueKey) {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        MutableIssue issue = this.issueManager.getIssueObject(issueKey);
        return this.watcherManager.isWatching(user, (Issue)issue);
    }

    @Override
    public boolean voteOnIssue(String issueKey) {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        MutableIssue issue = this.issueManager.getIssueObject(issueKey);
        if (!this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, (Issue)issue, user)) {
            return false;
        }
        return this.voteManager.addVote(user, (Issue)issue);
    }

    @Override
    public boolean hasPreviouslyVoted(String issueKey) {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        MutableIssue issue = this.issueManager.getIssueObject(issueKey);
        return this.voteManager.hasVoted(user, (Issue)issue);
    }
}

