/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira;

import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.streams.api.ActivityObjectType;
import com.atlassian.streams.api.ActivityObjectTypes;
import com.atlassian.streams.api.ActivityVerb;
import com.atlassian.streams.api.ActivityVerbs;
import com.atlassian.streams.api.StreamsFilterType;
import com.atlassian.streams.api.common.Pair;
import com.atlassian.streams.jira.JiraActivityObjectTypes;
import com.atlassian.streams.jira.JiraActivityVerbs;
import com.atlassian.streams.spi.ActivityOptions;
import com.atlassian.streams.spi.StreamsFilterOption;
import com.atlassian.streams.spi.StreamsFilterOptionProvider;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.Map;

public class JiraFilterOptionProvider
implements StreamsFilterOptionProvider {
    public static final String ISSUE_TYPE = "issue_type";
    public static final String PROJECT_CATEGORY = "project_category";
    public static final Iterable<Pair<ActivityObjectType, ActivityVerb>> activities = ImmutableList.builder().add((Object)Pair.pair((Object)JiraActivityObjectTypes.issue(), (Object)ActivityVerbs.post())).add((Object)Pair.pair((Object)JiraActivityObjectTypes.issue(), (Object)ActivityVerbs.update())).add((Object)Pair.pair((Object)JiraActivityObjectTypes.issue(), (Object)JiraActivityVerbs.transition())).add((Object)Pair.pair((Object)JiraActivityObjectTypes.issue(), (Object)JiraActivityVerbs.reopen())).add((Object)Pair.pair((Object)JiraActivityObjectTypes.issue(), (Object)JiraActivityVerbs.close())).add((Object)Pair.pair((Object)JiraActivityObjectTypes.issue(), (Object)JiraActivityVerbs.open())).add((Object)Pair.pair((Object)JiraActivityObjectTypes.issue(), (Object)JiraActivityVerbs.resolve())).add((Object)Pair.pair((Object)JiraActivityObjectTypes.issue(), (Object)JiraActivityVerbs.start())).add((Object)Pair.pair((Object)JiraActivityObjectTypes.issue(), (Object)JiraActivityVerbs.stop())).add((Object)Pair.pair((Object)ActivityObjectTypes.comment(), (Object)ActivityVerbs.post())).add((Object)Pair.pair((Object)ActivityObjectTypes.file(), (Object)ActivityVerbs.post())).build();
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext authenticationContext;
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final I18nResolver i18nResolver;
    private final Function<Pair<ActivityObjectType, ActivityVerb>, StreamsFilterOptionProvider.ActivityOption> toActivityOption;
    private static final Function<IssueType, String> toIssueTypeKey = new Function<IssueType, String>(){

        public String apply(IssueType type) {
            return type.getId();
        }
    };
    private static final Function<IssueType, String> toIssueTypeLabel = new Function<IssueType, String>(){

        public String apply(IssueType type) {
            return type.getNameTranslation();
        }
    };
    private final Function<Project, Iterable<IssueType>> toIssueTypeIterable = new Function<Project, Iterable<IssueType>>(){

        public Iterable<IssueType> apply(Project project) {
            return JiraFilterOptionProvider.this.issueTypeSchemeManager.getIssueTypesForProject(project);
        }
    };
    private final Function<Project, ProjectCategory> TO_PROJECT_CATEGORY = new Function<Project, ProjectCategory>(){

        public ProjectCategory apply(Project project) {
            return project.getProjectCategoryObject();
        }
    };
    private static final Function<ProjectCategory, String> TO_PROJECT_CATEGORY_KEY = new Function<ProjectCategory, String>(){

        public String apply(ProjectCategory category) {
            return String.valueOf(category.getId());
        }
    };
    private static final Function<Iterable<ProjectCategory>, String> TO_PROJECT_CATEGORY_LABEL = new Function<Iterable<ProjectCategory>, String>(){

        public String apply(Iterable<ProjectCategory> categories) {
            Preconditions.checkArgument((Iterables.size(categories) > 0 ? 1 : 0) != 0);
            return categories.iterator().next().getName();
        }
    };
    private static final Predicate<Project> PROJECT_HAS_CATEGORY = new Predicate<Project>(){

        public boolean apply(Project input) {
            return input.getProjectCategoryObject() != null;
        }
    };

    public JiraFilterOptionProvider(PermissionManager permissionManager, JiraAuthenticationContext authenticationContext, IssueTypeSchemeManager issueTypeSchemeManager, I18nResolver i18nResolver) {
        this.permissionManager = (PermissionManager)Preconditions.checkNotNull((Object)permissionManager, (Object)"permissionManager");
        this.authenticationContext = (JiraAuthenticationContext)Preconditions.checkNotNull((Object)authenticationContext, (Object)"authenticationContext");
        this.issueTypeSchemeManager = (IssueTypeSchemeManager)Preconditions.checkNotNull((Object)issueTypeSchemeManager, (Object)"issueTypeSchemeManager");
        this.i18nResolver = (I18nResolver)Preconditions.checkNotNull((Object)i18nResolver, (Object)"i18nResolver");
        this.toActivityOption = ActivityOptions.toActivityOption((I18nResolver)i18nResolver, (String)"streams.filter.jira");
    }

    public Iterable<StreamsFilterOption> getFilterOptions() {
        return ImmutableList.of((Object)this.getIssueTypeFilter(), (Object)this.getProjectCategoryFilter());
    }

    public Iterable<StreamsFilterOptionProvider.ActivityOption> getActivities() {
        return Iterables.transform(activities, this.toActivityOption);
    }

    private StreamsFilterOption getIssueTypeFilter() {
        return new StreamsFilterOption.Builder(ISSUE_TYPE, StreamsFilterType.SELECT).displayName(this.i18nResolver.getText("streams.filter.jira.issue.type")).helpTextI18nKey("streams.filter.help.jira.issue.type").i18nKey("streams.filter.jira.issue.type").unique(true).values(this.getIssueTypes()).build();
    }

    private StreamsFilterOption getProjectCategoryFilter() {
        return new StreamsFilterOption.Builder(PROJECT_CATEGORY, StreamsFilterType.SELECT).displayName(this.i18nResolver.getText("streams.filter.jira.project.category")).helpTextI18nKey("streams.filter.help.jira.project.category").i18nKey("streams.filter.jira.project.category").unique(true).values(this.getProjectCategories()).build();
    }

    private Map<String, String> getProjectCategories() {
        return Maps.transformValues((Map)Multimaps.index((Iterable)Sets.newHashSet((Iterable)Iterables.transform((Iterable)Iterables.filter(this.getAllProjects(), PROJECT_HAS_CATEGORY), this.TO_PROJECT_CATEGORY)), TO_PROJECT_CATEGORY_KEY).asMap(), TO_PROJECT_CATEGORY_LABEL);
    }

    private Map<String, String> getIssueTypes() {
        return Maps.transformValues((Map)Maps.uniqueIndex((Iterable)Sets.newHashSet((Iterable)Iterables.concat((Iterable)Iterables.transform(this.getAllProjects(), this.toIssueTypeIterable))), toIssueTypeKey), toIssueTypeLabel);
    }

    private Iterable<Project> getAllProjects() {
        return this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, this.authenticationContext.getLoggedInUser());
    }
}

