/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira;

import com.atlassian.streams.api.ActivityObjectType;
import com.atlassian.streams.api.ActivityVerb;
import com.atlassian.streams.api.ActivityVerbs;
import com.atlassian.streams.api.common.Pair;
import com.atlassian.streams.jira.AggregatedJiraActivityItem;
import com.atlassian.streams.jira.ChangeItems;
import com.atlassian.streams.jira.JiraActivityItem;
import com.atlassian.streams.jira.JiraActivityItemAggregator;
import com.atlassian.streams.jira.JiraActivityObjectTypes;
import com.atlassian.streams.jira.JiraActivityVerbs;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.ReadableDuration;
import org.ofbiz.core.entity.GenericValue;

public class JiraActivityItemAggregatorImpl
implements JiraActivityItemAggregator {
    @Override
    public Iterable<AggregatedJiraActivityItem> aggregate(Iterable<JiraActivityItem> activityItems) {
        ImmutableList activities = ImmutableList.copyOf(activityItems);
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (int i = 0; i < activities.size(); ++i) {
            JiraActivityItem item = (JiraActivityItem)activities.get(i);
            if (this.linkUpdate(item)) {
                if (this.previouslyLinked((List<JiraActivityItem>)activities, i)) continue;
                builder.add((Object)this.getAggregatedIssueLinks((List<JiraActivityItem>)activities, i));
                continue;
            }
            builder.add((Object)new AggregatedJiraActivityItem(item));
        }
        return builder.build();
    }

    private AggregatedJiraActivityItem getAggregatedIssueLinks(List<JiraActivityItem> activities, int currentIndex) {
        JiraActivityItem firstActivity = activities.get(currentIndex);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = currentIndex + 1; i < activities.size() && !this.dateDiffIsLongerThanASecond(firstActivity, activities.get(i)); ++i) {
            if (!this.isLinked(firstActivity, activities.get(i))) continue;
            builder.add((Object)activities.get(i));
        }
        ImmutableList relatedItems = builder.build();
        if (Iterables.isEmpty((Iterable)relatedItems)) {
            return new AggregatedJiraActivityItem(firstActivity);
        }
        return new AggregatedJiraActivityItem(firstActivity, (Iterable<JiraActivityItem>)builder.build(), (Pair<ActivityObjectType, ActivityVerb>)Pair.pair((Object)JiraActivityObjectTypes.issue(), (Object)JiraActivityVerbs.link()));
    }

    private boolean previouslyLinked(List<JiraActivityItem> activities, int currentIndex) {
        JiraActivityItem secondActivity = activities.get(currentIndex);
        for (int i = currentIndex - 1; i >= 0; --i) {
            if (this.dateDiffIsLongerThanASecond(activities.get(i), secondActivity)) {
                return false;
            }
            if (!this.isLinked(secondActivity, activities.get(i))) continue;
            return true;
        }
        return false;
    }

    private boolean linkUpdate(JiraActivityItem item) {
        Iterable<GenericValue> changeItems;
        if (Pair.pair((Object)JiraActivityObjectTypes.issue(), (Object)ActivityVerbs.update()).equals(item.getActivity()) && Iterables.size(changeItems = ChangeItems.getChangeItems(item)) == 1) {
            return ChangeItems.isLinkUpdate((GenericValue)Iterables.getOnlyElement(changeItems));
        }
        return false;
    }

    private boolean isLinked(JiraActivityItem first, JiraActivityItem second) {
        if (!this.linkUpdate(second)) {
            return false;
        }
        String issueKey = first.getIssue().getKey();
        GenericValue changeItem1 = ChangeItems.getFirstChangeItem(first);
        GenericValue changeItem2 = ChangeItems.getFirstChangeItem(second);
        if (StringUtils.isBlank((String)changeItem1.getString("newvalue")) && !StringUtils.isBlank((String)changeItem1.getString("oldvalue"))) {
            return issueKey.equals(changeItem2.getString("oldvalue"));
        }
        return issueKey.equals(changeItem2.getString("newvalue"));
    }

    private boolean dateDiffIsLongerThanASecond(JiraActivityItem first, JiraActivityItem second) {
        return this.dateDiffIsLongerThanASecond(first.getDate().getTime(), second.getDate().getTime());
    }

    private boolean dateDiffIsLongerThanASecond(long first, long second) {
        return new Interval(Math.min(first, second), Math.max(first, second)).toDuration().isLongerThan((ReadableDuration)Duration.standardSeconds((long)1L));
    }
}

