/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.changehistory.ChangeHistory;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.streams.api.ActivityObjectType;
import com.atlassian.streams.api.ActivityObjectTypes;
import com.atlassian.streams.api.ActivityVerb;
import com.atlassian.streams.api.ActivityVerbs;
import com.atlassian.streams.api.common.Option;
import com.atlassian.streams.api.common.Pair;
import com.atlassian.streams.jira.ChangeItems;
import com.atlassian.streams.jira.JiraActivityItem;
import com.atlassian.streams.jira.JiraActivityObjectTypes;
import com.atlassian.streams.jira.JiraHelper;
import com.atlassian.streams.jira.JiraStreamsActivityProvider;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericValue;

class IssueActivityExtractor {
    private final ApplicationUser user;
    private final CommentManager commentManager;
    private final JiraHelper helper;
    private final ImmutableList.Builder<JiraActivityItem> builder;
    private final JiraStreamsActivityProvider.ChangeHistoryQuery changeHistories;
    private final Predicate<String> inUsers;
    private final Predicate<Date> containsDate;
    private final Predicate<Pair<ActivityObjectType, ActivityVerb>> inJiraActivities;
    private final Predicate<GenericValue> summary = new Predicate<GenericValue>(){

        public boolean apply(GenericValue item) {
            return "summary".equals(item.getString("field").toLowerCase());
        }
    };
    private final Predicate<GenericValue> description = new Predicate<GenericValue>(){

        public boolean apply(GenericValue item) {
            return "description".equals(item.getString("field").toLowerCase());
        }
    };

    IssueActivityExtractor(ApplicationUser user, CommentManager commentManager, JiraHelper helper, ImmutableList.Builder<JiraActivityItem> builder, JiraStreamsActivityProvider.ChangeHistoryQuery changeHistories, Predicate<String> inUsers, Predicate<Date> containsDate, Predicate<Pair<ActivityObjectType, ActivityVerb>> inJiraActivities) {
        this.user = user;
        this.commentManager = commentManager;
        this.helper = helper;
        this.builder = builder;
        this.changeHistories = changeHistories;
        this.inUsers = inUsers;
        this.containsDate = containsDate;
        this.inJiraActivities = inJiraActivities;
    }

    public void extract(Issue issue) {
        List<ChangeHistory> histories = this.changeHistories.sortedChangeHistories(issue);
        Option issueSummary = this.getInitialSummary(issue, histories);
        if (issue.getCreator() != null && this.inUsers.apply((Object)issue.getCreator().getName()) && this.containsDate.apply((Object)issue.getCreated()) && this.inJiraActivities.apply((Object)Pair.pair((Object)JiraActivityObjectTypes.issue(), (Object)ActivityVerbs.post()))) {
            this.builder.add((Object)new JiraActivityItem(issue, (String)issueSummary.getOrElse((Object)""), (Pair<ActivityObjectType, ActivityVerb>)Pair.pair((Object)JiraActivityObjectTypes.issue(), (Object)ActivityVerbs.post()), this.getInitialDescription(issue, histories)));
        }
        ArrayList comments = new ArrayList();
        comments.addAll(this.commentManager.getCommentsForUser(issue, this.user));
        for (ChangeHistory changeHistory : histories) {
            Option<Pair<ActivityObjectType, ActivityVerb>> activityOption = this.helper.jiraActivity(changeHistory);
            if (!activityOption.isDefined()) continue;
            Pair activity = (Pair)activityOption.get();
            if (!this.containsDate.apply((Object)changeHistory.getTimePerformed()) || !this.inJiraActivities.apply((Object)activity)) continue;
            issueSummary = Option.option((Object)this.getNewSummaryIfChanged(changeHistory).getOrElse(issueSummary.get()));
            if (!this.inUsers.apply((Object)this.getUserNameFromApplicationUser(changeHistory.getAuthorObject()))) continue;
            Iterator iter = comments.iterator();
            Option comment = Option.none();
            while (iter.hasNext()) {
                Comment c = (Comment)iter.next();
                if (!IssueActivityExtractor.areRelated(changeHistory, c)) continue;
                iter.remove();
                comment = Option.some((Object)c);
                break;
            }
            if (comment.isDefined()) {
                this.builder.add((Object)new JiraActivityItem(issue, (String)issueSummary.getOrElse((Object)""), (Pair<ActivityObjectType, ActivityVerb>)activity, (Comment)comment.get(), changeHistory));
                continue;
            }
            this.builder.add((Object)new JiraActivityItem(issue, (String)issueSummary.getOrElse((Object)""), (Pair<ActivityObjectType, ActivityVerb>)activity, changeHistory));
        }
        for (Comment comment : comments) {
            if (!this.inUsers.apply((Object)this.getUserNameFromApplicationUser(comment.getAuthorApplicationUser())) || !this.containsDate.apply((Object)comment.getCreated()) || !this.inJiraActivities.apply((Object)Pair.pair((Object)ActivityObjectTypes.comment(), (Object)ActivityVerbs.post()))) continue;
            this.builder.add((Object)new JiraActivityItem(issue, (String)this.issueSummaryAtTimeOfComment(comment, issue, histories).getOrElse((Object)""), (Pair<ActivityObjectType, ActivityVerb>)Pair.pair((Object)ActivityObjectTypes.comment(), (Object)ActivityVerbs.post()), comment));
        }
    }

    private Option<String> issueSummaryAtTimeOfComment(Comment comment, Issue issue, Iterable<ChangeHistory> histories) {
        String issueSummary = null;
        long commentCreateTime = comment.getCreated().getTime();
        for (ChangeHistory changeHistory : histories) {
            long changeHistoryCreateTime = changeHistory.getTimePerformed().getTime();
            if (changeHistoryCreateTime >= commentCreateTime && !IssueActivityExtractor.isCloseEnough(changeHistoryCreateTime, commentCreateTime)) continue;
            Iterator iterator = this.getNewSummaryIfChanged(changeHistory).iterator();
            while (iterator.hasNext()) {
                String newSummary;
                issueSummary = newSummary = (String)iterator.next();
            }
        }
        if (!StringUtils.isBlank(issueSummary)) {
            return Option.option(issueSummary);
        }
        return this.getInitialSummary(issue, histories);
    }

    private Option<String> getInitialSummary(Issue issue, Iterable<ChangeHistory> histories) {
        for (ChangeHistory changeHistory : histories) {
            Iterator iterator = this.getSummaryIfChanged(changeHistory, true).iterator();
            if (!iterator.hasNext()) continue;
            String oldSummary = (String)iterator.next();
            return Option.option((Object)oldSummary);
        }
        return Option.option((Object)issue.getSummary());
    }

    private Option<String> getNewSummaryIfChanged(ChangeHistory changeHistory) {
        return this.getSummaryIfChanged(changeHistory, false);
    }

    private Option<String> getSummaryIfChanged(ChangeHistory changeHistory, boolean old) {
        for (GenericValue changeItem : Iterables.filter(ChangeItems.getChangeItems(changeHistory), this.summary)) {
            String summary = changeItem.getString(old ? "oldstring" : "newstring");
            if (StringUtils.isBlank((String)summary)) continue;
            return Option.some((Object)summary);
        }
        return Option.none();
    }

    private Option<String> getInitialDescription(Issue issue, Iterable<ChangeHistory> histories) {
        for (ChangeHistory changeHistory : histories) {
            Iterator iterator = Iterables.filter(ChangeItems.getChangeItems(changeHistory), this.description).iterator();
            if (!iterator.hasNext()) continue;
            GenericValue changeItem = (GenericValue)iterator.next();
            return Option.option((Object)changeItem.getString("oldstring"));
        }
        return Option.option((Object)issue.getDescription());
    }

    private static boolean areRelated(ChangeHistory change, Comment comment) {
        return StringUtils.equals((String)ApplicationUsers.getKeyFor((ApplicationUser)comment.getAuthorApplicationUser()), (String)change.getAuthor()) && IssueActivityExtractor.isCloseEnough(comment.getCreated().getTime(), change.getTimePerformed().getTime());
    }

    private static boolean isCloseEnough(long time1, long time2) {
        return Math.abs(time1 - time2) < 200L;
    }

    private String getUserNameFromApplicationUser(ApplicationUser user) {
        if (user == null) {
            return null;
        }
        return user.getUsername();
    }
}

