/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.beehive.db;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.core.LockRegistry;
import com.atlassian.beehive.core.ManagedClusterLockService;
import com.atlassian.beehive.db.ClusterNodeHeartbeatService;
import com.atlassian.beehive.db.DatabaseClusterLock;
import com.atlassian.beehive.db.spi.ClusterLockDao;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;

public class DatabaseClusterLockService
implements ManagedClusterLockService {
    private final ClusterLockDao clusterLockDao;
    private final ClusterNodeHeartbeatService clusterNodeHeartbeatService;
    private final LockRegistry<DatabaseClusterLock> registry = new LockRegistry<DatabaseClusterLock>(){

        protected DatabaseClusterLock createLock(String lockName) {
            return new DatabaseClusterLock(lockName, DatabaseClusterLockService.this.clusterLockDao, DatabaseClusterLockService.this.clusterNodeHeartbeatService);
        }
    };

    public DatabaseClusterLockService(ClusterLockDao clusterLockDao, ClusterNodeHeartbeatService clusterNodeHeartbeatService) {
        this.clusterLockDao = clusterLockDao;
        this.clusterNodeHeartbeatService = clusterNodeHeartbeatService;
    }

    public Collection<DatabaseClusterLock> getAllKnownClusterLocks() {
        return this.registry.getAllKnownClusterLocks();
    }

    public ClusterLock getLockForName(@Nonnull String lockName) {
        return this.registry.getLockForName(lockName);
    }

    @PostConstruct
    public void cleanUpOrphanLocks() {
        this.clusterLockDao.deleteLocksHeldByNode(this.clusterNodeHeartbeatService.getNodeId());
    }
}

