/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.github.web;

import com.atlassian.gzipfilter.org.apache.commons.lang.StringUtils;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.plugins.importer.github.config.ConfigBean;
import com.atlassian.jira.plugins.importer.github.config.SchemeStatusMapping;
import com.atlassian.jira.plugins.importer.github.rest.workflow.WorkflowService;
import com.atlassian.jira.plugins.importer.github.web.GithubImportProcessSupport;
import com.atlassian.jira.plugins.importer.tracking.UsageTrackingService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowScheme;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.ObjectMapper;
import webwork.action.ActionContext;

public class GithubWorkflowPage
extends GithubImportProcessSupport {
    public static final String SCHEME_SELECT_ID = "workflowSchemeSelect";
    private final WorkflowService workflowService;

    public GithubWorkflowPage(@ComponentImport UsageTrackingService usageTrackingService, @ComponentImport WebInterfaceManager webInterfaceManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport ProjectManager projectManager, @ComponentImport IssueTypeSchemeManager issueTypeSchemeManager, @ComponentImport WorkflowSchemeManager workflowSchemeManager) {
        super(usageTrackingService, webInterfaceManager, pluginAccessor, projectManager, issueTypeSchemeManager, workflowSchemeManager);
        this.workflowService = new WorkflowService(ComponentAccessor.getWorkflowManager(), workflowSchemeManager, this.getConstantsManager());
    }

    public String getWorkflowName() {
        Optional<WorkflowScheme> workflowScheme = this.getWorkflowScheme();
        return workflowScheme.isPresent() ? ((WorkflowScheme)workflowScheme.get()).getName() : "???";
    }

    private Optional<WorkflowScheme> getWorkflowScheme() {
        Iterable schemes = Iterables.transform(this.getExistingDestinationProjects(), (Function)new Function<Project, WorkflowScheme>(){

            public WorkflowScheme apply(@Nullable Project input) {
                return GithubWorkflowPage.this.workflowSchemeManager.getWorkflowSchemeObj(input);
            }
        });
        return Optional.fromNullable((Object)Iterables.getFirst((Iterable)Iterables.filter((Iterable)schemes, (Predicate)Predicates.notNull()), null));
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        return super.doExecute();
    }

    protected void doValidation() {
        Map actionParams = ActionContext.getSingleValueParameters();
        String workflowSchemeName = (String)actionParams.get(SCHEME_SELECT_ID);
        if (StringUtils.isBlank((String)workflowSchemeName)) {
            this.addError(SCHEME_SELECT_ID, this.getText("com.atlassian.jira.plugins.importer.github.workflow.error.noScheme"));
            this.getConfigBean().setSchemeStatusMapping(null);
        } else {
            this.populateStatusMappings();
        }
        super.doValidation();
    }

    private void populateStatusMappings() {
        Map actionParams = ActionContext.getSingleValueParameters();
        String workflowSchemeName = (String)actionParams.get(SCHEME_SELECT_ID);
        if ("[DEFAULT-WORKFLOW-SCHEME]".equals(workflowSchemeName)) {
            workflowSchemeName = null;
        }
        Collection<JiraWorkflow> workflows = this.workflowService.getSchemeWorkflows(workflowSchemeName);
        SchemeStatusMapping schemeStatusMapping = new SchemeStatusMapping(workflowSchemeName);
        for (JiraWorkflow workflow : workflows) {
            String openStatus = (String)actionParams.get(workflow.getName() + "_open_status");
            String closedStatus = (String)actionParams.get(workflow.getName() + "_closed_status");
            SchemeStatusMapping.JiraStatusMapping statusMapping = new SchemeStatusMapping.JiraStatusMapping(openStatus, closedStatus);
            schemeStatusMapping.getWorkflowIdToStatusMapping().put(workflow.getName(), statusMapping);
        }
        this.getConfigBean().setSchemeStatusMapping(schemeStatusMapping);
    }

    public String getFormTitle() {
        return this.getText("com.atlassian.jira.plugins.importer.github.workflow.title");
    }

    public Map<String, String> getWorkflowSchemeValues() {
        List<Project> existingDestinationProjects = this.getExistingDestinationProjects();
        if (existingDestinationProjects.size() > 0) {
            String name = this.getSchemeName();
            return ImmutableMap.of((Object)name, (Object)name);
        }
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("[DEFAULT-WORKFLOW-SCHEME]", this.workflowService.getDefaultSchemeName());
        for (String schemeName : this.workflowService.getSchemeNames()) {
            values.put(schemeName, schemeName);
        }
        return values;
    }

    private String getSchemeName() {
        Project project = this.getExistingDestinationProjects().get(0);
        AssignableWorkflowScheme workflowScheme = this.workflowSchemeManager.getWorkflowSchemeObj(project);
        return workflowScheme.getName();
    }

    public String getSelectedWorkflowSchemeKey() {
        SchemeStatusMapping schemeStatusMapping = this.getConfigBean().getSchemeStatusMapping();
        Map<String, String> workflowSchemeValues = this.getWorkflowSchemeValues();
        String keyFromExistingMapping = null;
        if (schemeStatusMapping != null) {
            keyFromExistingMapping = schemeStatusMapping.getWorkflowSchemeName() == null ? "[DEFAULT-WORKFLOW-SCHEME]" : schemeStatusMapping.getWorkflowSchemeName();
        }
        if (workflowSchemeValues.containsKey(keyFromExistingMapping)) {
            return keyFromExistingMapping;
        }
        if (workflowSchemeValues.size() == 1) {
            return workflowSchemeValues.keySet().iterator().next();
        }
        return "";
    }

    public String getStatusMappingJSON() {
        SchemeStatusMapping schemeStatusMapping = this.getConfigBean().getSchemeStatusMapping();
        Map<String, SchemeStatusMapping.JiraStatusMapping> workflowIdToStatusMapping = schemeStatusMapping != null ? schemeStatusMapping.getWorkflowIdToStatusMapping() : new HashMap<String, SchemeStatusMapping.JiraStatusMapping>();
        try {
            return new ObjectMapper().writeValueAsString(workflowIdToStatusMapping);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ConfigBean getConfigBean() {
        try {
            if (this.getController() == null || this.getController().getImportProcessBeanFromSession() == null) {
                throw new IllegalStateException("Importer not intialized");
            }
            ConfigBean configBean = (ConfigBean)this.getController().getImportProcessBeanFromSession().getConfigBean();
            return configBean;
        }
        catch (ClassCastException e) {
            throw new RuntimeException(e);
        }
    }

    public String getSchemeSelectId() {
        return SCHEME_SELECT_ID;
    }
}

