/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.github.web;

import com.atlassian.jira.plugins.importer.github.GithubImportProcessBean;
import com.atlassian.jira.plugins.importer.github.config.ConfigBean;
import com.atlassian.jira.plugins.importer.github.fetch.DataFetchJob;
import com.atlassian.jira.plugins.importer.github.util.VoidOut;
import com.atlassian.jira.plugins.importer.tracking.UsageTrackingService;
import com.atlassian.jira.plugins.importer.web.AbstractSetupPage;
import com.atlassian.jira.task.TaskContext;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.WebInterfaceManager;
import java.util.List;
import java.util.concurrent.Callable;
import webwork.action.ActionContext;

public class GithubFetchDataPage
extends AbstractSetupPage {
    private static final String SELECTED_PROJECTS_KEY = "SELECTED_PROJECTS_KEY";
    private final TaskManager taskManager;

    public GithubFetchDataPage(@ComponentImport UsageTrackingService usageTrackingService, @ComponentImport WebInterfaceManager webInterfaceManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport TaskManager taskManager) {
        super(usageTrackingService, webInterfaceManager, pluginAccessor);
        this.taskManager = taskManager;
    }

    public String doDefault() throws Exception {
        FetchState fetchState = this.getFetchState();
        if (fetchState == FetchState.NOT_STARTED) {
            this.startFetchJob();
        } else if (this.isSelectionUnchanged()) {
            if (fetchState == FetchState.RUNNING) {
                // empty if block
            }
            if (fetchState == FetchState.FINISHED) {
                return this.getRedirect(this.getImporterBaseUrlWithSlash() + "GithubLabelMappingPage!default.jspa?externalSystem=" + this.getExternalSystem() + "&atl_token=" + this.getXsrfToken());
            }
        } else {
            if (fetchState == FetchState.RUNNING) {
                throw new IllegalStateException("Project selection has changed during a running fetch");
            }
            if (fetchState == FetchState.FINISHED) {
                this.startFetchJob();
            }
        }
        return "input";
    }

    private void startFetchJob() {
        final ConfigBean configBean = this.getConfigBean();
        final DataFetchJob dataFetchJob = this.getProcessBean().getDataFetchJob();
        Callable<VoidOut> task = new Callable<VoidOut>(){

            @Override
            public VoidOut call() throws Exception {
                dataFetchJob.run(configBean.getSelectedProjects());
                return null;
            }
        };
        this.taskManager.submitTask((Callable)task, "GitHub importer fetch data task", (TaskContext)new EmptyTaskContext());
        ActionContext.getSession().put(SELECTED_PROJECTS_KEY, configBean.getSelectedProjects());
    }

    private boolean isSelectionUnchanged() {
        List previouslySelected = (List)ActionContext.getSession().get(SELECTED_PROJECTS_KEY);
        if (previouslySelected != null) {
            return previouslySelected.containsAll(this.getConfigBean().getSelectedProjects());
        }
        throw new IllegalStateException();
    }

    private FetchState getFetchState() {
        FetchState fetchState = this.getProcessBean().getDataFetchJob().isRunning() ? FetchState.RUNNING : (this.getProcessBean().getGithubDataService().hasDataBeenLoaded() ? FetchState.FINISHED : FetchState.NOT_STARTED);
        return fetchState;
    }

    public String getExternalSystem() {
        return "com.atlassian.jira.plugins.jira-importers-github-plugin:githubImporterKey";
    }

    private ConfigBean getConfigBean() {
        return (ConfigBean)this.getProcessBean().getConfigBean();
    }

    private GithubImportProcessBean getProcessBean() {
        try {
            if (this.getController() == null || this.getController().getImportProcessBeanFromSession() == null) {
                throw new IllegalStateException("Importer not intialized");
            }
            return (GithubImportProcessBean)this.getController().getImportProcessBeanFromSession();
        }
        catch (ClassCastException e) {
            throw new RuntimeException(e);
        }
    }

    public String getFormTitle() {
        return this.getText("com.atlassian.jira.plugins.importer.github.fetchData.title");
    }

    private static final class EmptyTaskContext
    implements TaskContext {
        private EmptyTaskContext() {
        }

        public String buildProgressURL(Long aLong) {
            return null;
        }
    }

    static enum FetchState {
        NOT_STARTED,
        RUNNING,
        FINISHED;

    }
}

