/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.github.config;

import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomField;
import com.atlassian.jira.plugins.importer.github.config.SchemeStatusMapping;
import com.atlassian.jira.plugins.importer.github.fetch.GithubDataService;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingDefinition;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingDefinitionsFactory;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingHelper;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingHelperImpl;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractConfigBean2;
import com.atlassian.modzdetector.IOUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;

public class ConfigBean
extends AbstractConfigBean2 {
    public static final String LABEL_TO_ISSUE_TYPE = "labelToIssueType";
    public static final String LABEL_TO_RESOLUTION = "labelToResolution";
    public static final String SCHEME_STATUS = "schemeStatusMapping";
    private final GithubDataService githubDataService;
    private Map<String, Integer> issueTypeMapping = Maps.newHashMap();
    private Map<String, Integer> resolutionMappings = Maps.newHashMap();
    private boolean autoLabels = true;
    private boolean isGithubEnterprise = false;
    private SchemeStatusMapping schemeStatusMapping;
    private String githubUrl;
    private Map<String, IssueType> defaultIssueTypesForProjectKey = Maps.newHashMap();

    public ConfigBean(GithubDataService githubDataService) {
        this.githubDataService = githubDataService;
    }

    public List<String> getExternalProjectNames() {
        try {
            return Lists.newArrayList(this.githubDataService.getAllProjectNames());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getSelectedProjects() {
        ArrayList<String> selected = new ArrayList<String>();
        for (String projectName : this.getExternalProjectNames()) {
            if (!this.isProjectSelected(projectName)) continue;
            selected.add(projectName);
        }
        return selected;
    }

    public List<ExternalCustomField> getCustomFields() {
        return Lists.newArrayList();
    }

    public List<String> getLinkNamesFromDb() {
        return Lists.newArrayList();
    }

    public ValueMappingHelper initializeValueMappingHelper() {
        ValueMappingDefinitionsFactory mappingDefinitionFactory = new ValueMappingDefinitionsFactory(){

            public List<ValueMappingDefinition> createMappingDefinitions(ValueMappingHelper valueMappingHelper) {
                return Lists.newArrayList();
            }
        };
        return new ValueMappingHelperImpl(this.getWorkflowSchemeManager(), this.getWorkflowManager(), mappingDefinitionFactory, this.getConstantsManager());
    }

    public void copyToNewProperties(Map<String, Object> configFile) {
        super.copyToNewProperties(configFile);
        configFile.put(LABEL_TO_ISSUE_TYPE, this.issueTypeMapping);
        configFile.put(LABEL_TO_RESOLUTION, this.resolutionMappings);
        configFile.put(SCHEME_STATUS, this.schemeStatusMapping);
    }

    public void copyFromProperties(InputStream is) throws Exception {
        byte[] bytes = IOUtils.toByteArray((InputStream)is);
        super.copyFromProperties((InputStream)new ByteArrayInputStream(bytes));
        ObjectMapper mapper = new ObjectMapper();
        Map configCopy = (Map)mapper.readValue((InputStream)new ByteArrayInputStream(bytes), Map.class);
        this.issueTypeMapping = (Map)configCopy.get(LABEL_TO_ISSUE_TYPE);
        this.resolutionMappings = (Map)configCopy.get(LABEL_TO_RESOLUTION);
        this.schemeStatusMapping = SchemeStatusMapping.fromMap((HashMap)configCopy.get(SCHEME_STATUS));
    }

    public GithubDataService getGithubDataService() {
        return this.githubDataService;
    }

    public Map<String, Integer> getResolutionMappings() {
        return this.resolutionMappings;
    }

    public void setResolutionMappings(Map<String, Integer> resolutionMappings) {
        this.resolutionMappings = resolutionMappings;
    }

    public Map<String, Integer> getIssueTypeMapping() {
        return this.issueTypeMapping;
    }

    public void setIssueTypeMapping(Map<String, Integer> issueTypeMapping) {
        this.issueTypeMapping = issueTypeMapping;
    }

    public boolean isAutoLabels() {
        return this.autoLabels;
    }

    public void setAutoLabels(boolean autoLabels) {
        this.autoLabels = autoLabels;
    }

    public boolean isGithubEnterprise() {
        return this.isGithubEnterprise;
    }

    public void setGithubEnterprise(boolean githubEnterprise) {
        this.isGithubEnterprise = githubEnterprise;
    }

    public SchemeStatusMapping getSchemeStatusMapping() {
        return this.schemeStatusMapping;
    }

    public void setSchemeStatusMapping(SchemeStatusMapping schemeStatusMapping) {
        this.schemeStatusMapping = schemeStatusMapping;
    }

    public String getGithubUrl() {
        return this.githubUrl;
    }

    public void setGithubUrl(String githubUrl) {
        this.githubUrl = githubUrl;
    }

    public void setDefaultIssueTypesForProjectKey(Map<String, IssueType> defaultIssueTypesForProjectKey) {
        this.defaultIssueTypesForProjectKey = defaultIssueTypesForProjectKey;
    }

    public IssueType getDefaultIssueType(String projectKey) {
        return this.defaultIssueTypesForProjectKey.get(projectKey);
    }
}

