/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.consumer.core;

import com.atlassian.oauth.Consumer;
import com.atlassian.oauth.Request;
import com.atlassian.oauth.ServiceProvider;
import com.atlassian.oauth.bridge.Consumers;
import com.atlassian.oauth.bridge.consumer.ConsumerTokens;
import com.atlassian.oauth.consumer.ConsumerService;
import com.atlassian.oauth.consumer.ConsumerToken;
import com.atlassian.oauth.consumer.ConsumerTokenStore;
import com.atlassian.oauth.consumer.OAuthConsumerNotFoundException;
import com.atlassian.oauth.consumer.OAuthSigningException;
import com.atlassian.oauth.consumer.core.ConsumerServiceStore;
import com.atlassian.oauth.consumer.core.HostConsumerAndSecretProvider;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivateKey;
import java.util.Collection;
import java.util.Map;
import net.oauth.OAuth;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerServiceImpl
implements ConsumerService {
    private final ConsumerServiceStore store;
    private final ConsumerTokenStore tokenStore;
    private final HostConsumerAndSecretProvider hostCasProvider;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public ConsumerServiceImpl(ConsumerServiceStore store, ConsumerTokenStore tokenStore, HostConsumerAndSecretProvider hostCasProvider) {
        this.store = (ConsumerServiceStore)Preconditions.checkNotNull((Object)store, (Object)"store");
        this.tokenStore = (ConsumerTokenStore)Preconditions.checkNotNull((Object)tokenStore, (Object)"tokenStore");
        this.hostCasProvider = (HostConsumerAndSecretProvider)Preconditions.checkNotNull((Object)hostCasProvider, (Object)"hostCasProvider");
    }

    public Consumer getConsumer() {
        return this.hostCasProvider.get().getConsumer();
    }

    public Consumer getConsumer(String service) {
        if (StringUtils.isEmpty((String)service)) {
            throw new IllegalArgumentException("service is an empty string");
        }
        ConsumerServiceStore.ConsumerAndSecret cas = this.store.get(service);
        if (cas == null) {
            return null;
        }
        return cas.getConsumer();
    }

    public Consumer getConsumerByKey(String consumerKey) {
        if (StringUtils.isEmpty((String)consumerKey)) {
            throw new IllegalArgumentException("consumerKey is an empty string");
        }
        ConsumerServiceStore.ConsumerAndSecret cas = this.store.getByKey(consumerKey);
        if (cas == null) {
            return null;
        }
        return cas.getConsumer();
    }

    public void removeConsumerByKey(String consumerKey) {
        if (StringUtils.isEmpty((String)consumerKey)) {
            throw new IllegalArgumentException("consumerKey is an empty string");
        }
        this.tokenStore.removeTokensForConsumer(consumerKey);
        this.store.removeByKey(consumerKey);
    }

    public Iterable<Consumer> getAllServiceProviders() {
        return this.store.getAllServiceProviders();
    }

    public Consumer updateHostConsumerInformation(String name, String description, URI callback) {
        ConsumerServiceStore.ConsumerAndSecret cas = this.hostCasProvider.get();
        Consumer oldConsumer = cas.getConsumer();
        Consumer newConsumer = Consumer.key((String)oldConsumer.getKey()).signatureMethod(oldConsumer.getSignatureMethod()).publicKey(oldConsumer.getPublicKey()).name(name).description(description).callback(callback).build();
        cas = newConsumer.getSignatureMethod() == Consumer.SignatureMethod.HMAC_SHA1 ? new ConsumerServiceStore.ConsumerAndSecret(cas.getServiceName(), newConsumer, cas.getSharedSecret()) : new ConsumerServiceStore.ConsumerAndSecret(cas.getServiceName(), newConsumer, cas.getPrivateKey());
        return this.hostCasProvider.put(cas).getConsumer();
    }

    public void add(String service, Consumer consumer, PrivateKey privateKey) {
        this.store.put(service, new ConsumerServiceStore.ConsumerAndSecret(service, consumer, privateKey));
    }

    public void add(String service, Consumer consumer, String sharedSecret) {
        this.store.put(service, new ConsumerServiceStore.ConsumerAndSecret(service, consumer, sharedSecret));
    }

    public Request sign(Request request, ServiceProvider serviceProvider) {
        return this.sign(request, this.hostCasProvider.get(), serviceProvider);
    }

    public Request sign(Request request, String consumerKey, ServiceProvider serviceProvider) {
        return this.sign(request, this.getConsumerAndSecret(consumerKey), serviceProvider);
    }

    public Request sign(Request request, ServiceProvider serviceProvider, ConsumerToken token) {
        ConsumerServiceStore.ConsumerAndSecret cas = this.getConsumerAndSecret(token.getConsumer().getKey());
        OAuthAccessor accessor = this.asOAuthAccessor(token, cas, serviceProvider);
        return this.sign(request, accessor);
    }

    private ConsumerServiceStore.ConsumerAndSecret getConsumerAndSecret(String consumerKey) {
        ConsumerServiceStore.ConsumerAndSecret cas = this.store.getByKey(consumerKey);
        if (cas == null && !(cas = this.hostCasProvider.get()).getConsumer().getKey().equals(consumerKey)) {
            throw new OAuthConsumerNotFoundException("Consumer with key '" + consumerKey + "' could not be found");
        }
        return cas;
    }

    private Request sign(Request request, ConsumerServiceStore.ConsumerAndSecret cas, ServiceProvider serviceProvider) {
        return this.sign(request, new OAuthAccessor(this.asOAuthConsumer(cas, serviceProvider)));
    }

    private OAuthConsumer asOAuthConsumer(ConsumerServiceStore.ConsumerAndSecret cas, ServiceProvider serviceProvider) {
        if (cas.getConsumer().getSignatureMethod() == Consumer.SignatureMethod.RSA_SHA1) {
            return Consumers.asOAuthConsumer(cas.getConsumer(), cas.getPrivateKey(), serviceProvider);
        }
        return Consumers.asOAuthConsumer(cas.getConsumer(), cas.getSharedSecret(), serviceProvider);
    }

    private OAuthAccessor asOAuthAccessor(ConsumerToken token, ConsumerServiceStore.ConsumerAndSecret cas, ServiceProvider serviceProvider) {
        if (cas.getConsumer().getSignatureMethod() == Consumer.SignatureMethod.RSA_SHA1) {
            return ConsumerTokens.asOAuthAccessor(token, cas.getPrivateKey(), serviceProvider);
        }
        return ConsumerTokens.asOAuthAccessor(token, cas.getSharedSecret(), serviceProvider);
    }

    private Request sign(Request request, OAuthAccessor accessor) {
        try {
            OAuthMessage oauthMessage = accessor.newRequestMessage(request.getMethod().name(), request.getUri().normalize().toString(), this.asOAuthParameters(request.getParameters()));
            this.log.debug("Signed request {}", (Object)oauthMessage);
            return new Request(request.getMethod(), request.getUri(), this.fromOAuthParameters(oauthMessage.getParameters()));
        }
        catch (OAuthException e) {
            throw new OAuthSigningException("Failed to sign the request", (Throwable)e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private Collection<OAuth.Parameter> asOAuthParameters(Iterable<Request.Parameter> params) {
        return Lists.newArrayList((Iterable)Iterables.transform(params, (Function)new Function<Request.Parameter, OAuth.Parameter>(){

            public OAuth.Parameter apply(Request.Parameter p) {
                return new OAuth.Parameter(p.getName(), p.getValue());
            }
        }));
    }

    private Iterable<Request.Parameter> fromOAuthParameters(Collection<Map.Entry<String, String>> params) {
        return Iterables.transform(params, (Function)new Function<Map.Entry<String, String>, Request.Parameter>(){

            public Request.Parameter apply(Map.Entry<String, String> p) {
                return new Request.Parameter(p.getKey(), p.getValue());
            }
        });
    }
}

