/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.bridge.serviceprovider;

import com.atlassian.oauth.ServiceProvider;
import com.atlassian.oauth.Token;
import com.atlassian.oauth.bridge.Consumers;
import com.atlassian.oauth.bridge.Tokens;
import com.atlassian.oauth.serviceprovider.ServiceProviderToken;
import com.google.common.base.Preconditions;
import net.oauth.OAuthAccessor;

public final class ServiceProviderTokens {
    public static OAuthAccessor asOAuthAccessor(ServiceProviderToken token, ServiceProvider serviceProvider) {
        Preconditions.checkNotNull((Object)token, (Object)"token");
        Preconditions.checkNotNull((Object)serviceProvider, (Object)"serviceProvider");
        OAuthAccessor accessor = new OAuthAccessor(Consumers.asOAuthConsumer(token.getConsumer(), serviceProvider));
        ServiceProviderTokens.setTokenData(accessor, token);
        return accessor;
    }

    private static void setTokenData(OAuthAccessor accessor, ServiceProviderToken token) {
        Tokens.setCommonTokenData(accessor, (Token)token);
        if (token.isRequestToken()) {
            if (token.getAuthorization() == ServiceProviderToken.Authorization.AUTHORIZED) {
                accessor.setProperty("user", token.getUser());
                accessor.setProperty("authorized", true);
            } else if (token.getAuthorization() == ServiceProviderToken.Authorization.DENIED) {
                accessor.setProperty("user", token.getUser());
                accessor.setProperty("authorized", false);
            }
        } else {
            accessor.accessToken = token.getToken();
            accessor.setProperty("user", token.getUser());
            accessor.setProperty("authorized", true);
        }
        accessor.tokenSecret = token.getTokenSecret();
        accessor.setProperty("creationTime", token.getCreationTime());
    }
}

