/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.oauth.consumer;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.propertyset.JiraPropertySetFactory;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.oauth.Consumer;
import com.atlassian.oauth.consumer.ConsumerService;
import com.atlassian.oauth.consumer.ConsumerToken;
import com.atlassian.oauth.consumer.ConsumerTokenStore;
import com.opensymphony.module.propertyset.PropertySet;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.GuardedBy;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class OfBizConsumerTokenStore
implements ConsumerTokenStore {
    public static final String TABLE = "OAuthConsumerToken";
    public static final String PROPERTY_SET_KEY = "OAuthConsumerToken";
    private final OfBizDelegator delegator;
    private final JiraPropertySetFactory propertySetFactory;

    public OfBizConsumerTokenStore(OfBizDelegator delegator, JiraPropertySetFactory propertySetFactory) {
        Assertions.notNull((String)"delegator", (Object)delegator);
        Assertions.notNull((String)"propertySetFactory", (Object)propertySetFactory);
        this.propertySetFactory = propertySetFactory;
        this.delegator = delegator;
    }

    public ConsumerToken get(ConsumerTokenStore.Key key) {
        Assertions.notNull((String)"key", (Object)key);
        List consumerTokenGVs = this.delegator.findByAnd("OAuthConsumerToken", MapBuilder.newBuilder().add((Object)"tokenKey", (Object)key.toString()).toMap());
        if (!consumerTokenGVs.isEmpty()) {
            return this.createTokenFromGV((GenericValue)consumerTokenGVs.get(0));
        }
        return null;
    }

    public Map<ConsumerTokenStore.Key, ConsumerToken> getConsumerTokens(String consumerKey) {
        Assertions.notNull((String)"consumerKey", (Object)consumerKey);
        List consumerTokenGVs = this.delegator.findByAnd("OAuthConsumerToken", MapBuilder.newBuilder().add((Object)"consumerKey", (Object)consumerKey).toMap());
        HashMap<ConsumerTokenStore.Key, ConsumerToken> consumerTokenMap = new HashMap<ConsumerTokenStore.Key, ConsumerToken>();
        for (GenericValue consumerTokenGV : consumerTokenGVs) {
            ConsumerTokenStore.Key tokenKey = new ConsumerTokenStore.Key(consumerTokenGV.getString("tokenKey"));
            ConsumerToken token = this.createTokenFromGV(consumerTokenGV);
            consumerTokenMap.put(tokenKey, token);
        }
        return consumerTokenMap;
    }

    public ConsumerToken put(ConsumerTokenStore.Key key, ConsumerToken token) {
        Assertions.notNull((String)"key", (Object)key);
        Assertions.notNull((String)"token", (Object)token);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        Map fieldValues = MapBuilder.newBuilder().add((Object)"tokenKey", (Object)key.toString()).add((Object)"created", (Object)now).add((Object)"token", (Object)token.getToken()).add((Object)"tokenSecret", (Object)token.getTokenSecret()).add((Object)"tokenType", (Object)(token.isAccessToken() ? TokenType.ACCESS.toString() : TokenType.REQUEST.toString())).add((Object)"consumerKey", (Object)token.getConsumer().getKey()).toMap();
        List consumerTokenGVs = this.delegator.findByAnd("OAuthConsumerToken", MapBuilder.newBuilder().add((Object)"tokenKey", (Object)key.toString()).toMap());
        if (!consumerTokenGVs.isEmpty()) {
            GenericValue gv = (GenericValue)consumerTokenGVs.get(0);
            gv.setNonPKFields(fieldValues);
            try {
                gv.store();
                this.setTokenProperties(gv.getLong("id"), token.getProperties());
            }
            catch (GenericEntityException e) {
                throw new DataAccessException((Throwable)e);
            }
        } else {
            GenericValue gv = this.delegator.createValue("OAuthConsumerToken", fieldValues);
            this.setTokenProperties(gv.getLong("id"), token.getProperties());
        }
        return this.get(key);
    }

    public void remove(ConsumerTokenStore.Key key) {
        Assertions.notNull((String)"key", (Object)key);
        List consumerTokenGVs = this.delegator.findByAnd("OAuthConsumerToken", MapBuilder.newBuilder().add((Object)"tokenKey", (Object)key.toString()).toMap());
        if (!consumerTokenGVs.isEmpty()) {
            GenericValue tokenGv = (GenericValue)consumerTokenGVs.get(0);
            Long tokenId = tokenGv.getLong("id");
            this.delegator.removeValue(tokenGv);
            this.setTokenProperties(tokenId, Collections.emptyMap());
        }
    }

    public void removeTokensForConsumer(String consumerKey) {
        Assertions.notNull((String)"consumerKey", (Object)consumerKey);
        List consumerTokenGVs = this.delegator.findByAnd("OAuthConsumerToken", MapBuilder.newBuilder().add((Object)"consumerKey", (Object)consumerKey).toMap());
        for (GenericValue tokenGv : consumerTokenGVs) {
            Long tokenId = tokenGv.getLong("id");
            this.delegator.removeValue(tokenGv);
            this.setTokenProperties(tokenId, Collections.emptyMap());
        }
    }

    private ConsumerToken createTokenFromGV(GenericValue gv) {
        Consumer consumer = this.getConsumerService().getConsumerByKey(gv.getString("consumerKey"));
        if (this.isAccessToken(gv.getString("tokenType"))) {
            return ((ConsumerToken.ConsumerTokenBuilder)((ConsumerToken.ConsumerTokenBuilder)((ConsumerToken.ConsumerTokenBuilder)ConsumerToken.newAccessToken((String)gv.getString("token")).tokenSecret(gv.getString("tokenSecret"))).consumer(consumer)).properties(this.getTokenProperties(gv.getLong("id")))).build();
        }
        return ((ConsumerToken.ConsumerTokenBuilder)((ConsumerToken.ConsumerTokenBuilder)((ConsumerToken.ConsumerTokenBuilder)ConsumerToken.newRequestToken((String)gv.getString("token")).tokenSecret(gv.getString("tokenSecret"))).consumer(consumer)).properties(this.getTokenProperties(gv.getLong("id")))).build();
    }

    private Map<String, String> getTokenProperties(Long tokenId) {
        PropertySet propertySet = this.propertySetFactory.buildCachingPropertySet("OAuthConsumerToken", tokenId, true);
        MapBuilder ret = MapBuilder.newBuilder();
        Collection keys = propertySet.getKeys();
        for (String key : keys) {
            ret.add((Object)key, (Object)propertySet.getText(key));
        }
        return ret.toMap();
    }

    @GuardedBy(value="external-lock")
    private void setTokenProperties(Long tokenId, Map<String, String> props) {
        PropertySet propertySet = this.propertySetFactory.buildCachingPropertySet("OAuthConsumerToken", tokenId, true);
        Collection keys = propertySet.getKeys();
        for (String key : keys) {
            propertySet.remove(key);
        }
        Set<Map.Entry<String, String>> entries = props.entrySet();
        for (Map.Entry<String, String> prop : entries) {
            propertySet.setText(prop.getKey(), prop.getValue());
        }
    }

    private boolean isAccessToken(String tokenType) {
        return TokenType.ACCESS.equals((Object)TokenType.valueOf(tokenType));
    }

    protected ConsumerService getConsumerService() {
        return (ConsumerService)ComponentAccessor.getOSGiComponentInstanceOfType(ConsumerService.class);
    }

    static enum TokenType {
        ACCESS,
        REQUEST;

    }

    public static final class Columns {
        public static final String ID = "id";
        public static final String KEY = "tokenKey";
        public static final String CREATED = "created";
        public static final String TOKEN = "token";
        public static final String TOKEN_SECRET = "tokenSecret";
        public static final String TYPE = "tokenType";
        public static final String CONSUMER_KEY = "consumerKey";
    }
}

