/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.oauth.consumer;

import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.oauth.Consumer;
import com.atlassian.oauth.consumer.ConsumerCreationException;
import com.atlassian.oauth.consumer.core.ConsumerServiceStore;
import com.atlassian.oauth.util.RSAKeys;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class OfBizConsumerStore
implements ConsumerServiceStore {
    private final OfBizDelegator ofBizDelegator;
    public static final String TABLE = "OAuthConsumer";

    public OfBizConsumerStore(OfBizDelegator ofBizDelegator) {
        this.ofBizDelegator = ofBizDelegator;
    }

    @Override
    public ConsumerServiceStore.ConsumerAndSecret get(String service) {
        Assertions.notNull((String)"service", (Object)service);
        List cosumerGVs = this.ofBizDelegator.findByAnd(TABLE, MapBuilder.newBuilder().add((Object)"service", (Object)service).toMap());
        if (!cosumerGVs.isEmpty()) {
            return this.createConsumerFromGV((GenericValue)cosumerGVs.get(0));
        }
        return null;
    }

    @Override
    public ConsumerServiceStore.ConsumerAndSecret getByKey(String key) {
        Assertions.notNull((String)"key", (Object)key);
        List cosumerGVs = this.ofBizDelegator.findByAnd(TABLE, MapBuilder.newBuilder().add((Object)"consumerKey", (Object)key).toMap());
        if (!cosumerGVs.isEmpty()) {
            return this.createConsumerFromGV((GenericValue)cosumerGVs.get(0));
        }
        return null;
    }

    @Override
    public void put(String service, ConsumerServiceStore.ConsumerAndSecret cas) {
        Assertions.notNull((String)"service", (Object)service);
        Assertions.notNull((String)"cas", (Object)cas);
        Assertions.notNull((String)"cas.consumer", (Object)cas.getConsumer());
        Timestamp now = new Timestamp(System.currentTimeMillis());
        URI callback = cas.getConsumer().getCallback();
        MapBuilder fieldValuesBuilder = MapBuilder.newBuilder().add((Object)"service", (Object)service).add((Object)"consumerKey", (Object)cas.getConsumer().getKey()).add((Object)"created", (Object)now).add((Object)"name", (Object)cas.getConsumer().getName()).add((Object)"signatureMethod", (Object)cas.getConsumer().getSignatureMethod().name()).add((Object)"description", (Object)(cas.getConsumer().getDescription() == null ? "" : cas.getConsumer().getDescription())).add((Object)"callback", (Object)(callback != null ? callback.toASCIIString() : null));
        if (cas.getConsumer().getSignatureMethod() == Consumer.SignatureMethod.HMAC_SHA1) {
            fieldValuesBuilder.add((Object)"sharedSecret", (Object)cas.getSharedSecret());
        } else {
            String publicKey = RSAKeys.toPemEncoding((Key)cas.getConsumer().getPublicKey());
            String privateKey = RSAKeys.toPemEncoding((Key)cas.getPrivateKey());
            fieldValuesBuilder.add((Object)"publicKey", (Object)publicKey);
            fieldValuesBuilder.add((Object)"privateKey", (Object)privateKey);
        }
        Map fieldValues = fieldValuesBuilder.toMap();
        List consumerGVs = this.ofBizDelegator.findByAnd(TABLE, MapBuilder.newBuilder().add((Object)"service", (Object)service).toMap());
        if (!consumerGVs.isEmpty()) {
            GenericValue gv = (GenericValue)consumerGVs.get(0);
            gv.setNonPKFields(fieldValues);
            try {
                gv.store();
            }
            catch (GenericEntityException e) {
                throw new DataAccessException((Throwable)e);
            }
        } else {
            this.ofBizDelegator.createValue(TABLE, fieldValues);
        }
    }

    @Override
    public void removeByKey(String key) {
        Assertions.notNull((String)"key", (Object)key);
        this.ofBizDelegator.removeByAnd(TABLE, MapBuilder.newBuilder().add((Object)"consumerKey", (Object)key).toMap());
    }

    @Override
    public Iterable<Consumer> getAllServiceProviders() {
        List consumerGVs = this.ofBizDelegator.findAll(TABLE);
        Collection serviceProvidersWithoutHost = CollectionUtil.filter((Collection)consumerGVs, (Predicate)new Predicate<GenericValue>(){

            public boolean evaluate(GenericValue input) {
                return !"__HOST_SERVICE__".equals(input.getString("service"));
            }
        });
        return CollectionUtil.transform((Iterable)serviceProvidersWithoutHost, (Function)new Function<GenericValue, Consumer>(){

            public Consumer get(GenericValue input) {
                return OfBizConsumerStore.this.createConsumerFromGV(input).getConsumer();
            }
        });
    }

    private ConsumerServiceStore.ConsumerAndSecret createConsumerFromGV(GenericValue consumerGV) {
        try {
            Consumer consumer = this.newConsumer(consumerGV);
            if (consumer.getSignatureMethod() == Consumer.SignatureMethod.HMAC_SHA1) {
                return new ConsumerServiceStore.ConsumerAndSecret(consumerGV.getString("service"), consumer, consumerGV.getString("sharedSecret"));
            }
            PrivateKey privateKey = RSAKeys.fromPemEncodingToPrivateKey((String)consumerGV.getString("privateKey"));
            return new ConsumerServiceStore.ConsumerAndSecret(consumerGV.getString("service"), consumer, privateKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ConsumerCreationException("No encryption provider with the RSA algorithm installed", (Throwable)e);
        }
        catch (InvalidKeySpecException e) {
            throw new ConsumerCreationException("Invalid public key found in store", (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new ConsumerCreationException("Callback URI in store is not a valid URI", (Throwable)e);
        }
    }

    private Consumer newConsumer(GenericValue consumerGV) throws URISyntaxException, NoSuchAlgorithmException, InvalidKeySpecException {
        Consumer.SignatureMethod signatureMethod = Consumer.SignatureMethod.valueOf((String)consumerGV.getString("signatureMethod"));
        String uriString = consumerGV.getString("callback");
        URI callBack = null;
        if (StringUtils.isNotEmpty((String)uriString)) {
            callBack = new URI(uriString);
        }
        String description = consumerGV.getString("description") == null ? "" : consumerGV.getString("description");
        Consumer.InstanceBuilder builder = Consumer.key((String)consumerGV.getString("consumerKey")).name(consumerGV.getString("name")).description(description).callback(callBack).signatureMethod(signatureMethod);
        if (signatureMethod == Consumer.SignatureMethod.RSA_SHA1) {
            PublicKey publicKey = RSAKeys.fromPemEncodingToPublicKey((String)consumerGV.getString("publicKey"));
            builder.publicKey(publicKey);
        }
        return builder.build();
    }

    public static class Columns {
        public static final String ID = "id";
        public static final String CREATED = "created";
        public static final String NAME = "name";
        public static final String KEY = "consumerKey";
        public static final String SERVICE = "service";
        public static final String PUBLIC_KEY = "publicKey";
        public static final String PRIVATE_KEY = "privateKey";
        public static final String DESCRIPTION = "description";
        public static final String CALLBACK = "callback";
        public static final String SIGNATURE_METHOD = "signatureMethod";
        public static final String SHARED_SECRET = "sharedSecret";
    }
}

