/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.oauth.consumer;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.map.CacheObject;
import com.atlassian.oauth.Consumer;
import com.atlassian.oauth.consumer.core.ConsumerServiceStore;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class CachingConsumerStore
implements ConsumerServiceStore,
InitializingBean,
DisposableBean {
    private final ConsumerCache cache;
    private final ConsumerServiceStore delegateStore;
    private final EventPublisher eventPublisher;

    public CachingConsumerStore(ConsumerServiceStore delegateStore, EventPublisher eventPublisher, CacheManager cacheManager) {
        Assertions.notNull((String)"delegateStore", (Object)delegateStore);
        this.cache = new ConsumerCache(cacheManager, delegateStore);
        this.delegateStore = delegateStore;
        this.eventPublisher = eventPublisher;
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void clearCaches(ClearCacheEvent event) {
        this.cache.clear();
    }

    @Override
    public ConsumerServiceStore.ConsumerAndSecret get(String service) {
        Assertions.notNull((String)"service", (Object)service);
        return this.cache.getByService(service);
    }

    @Override
    public ConsumerServiceStore.ConsumerAndSecret getByKey(String key) {
        Assertions.notNull((String)"key", (Object)key);
        String service = this.cache.getServiceForKey(key);
        return service == null ? null : this.get(service);
    }

    @Override
    public void put(String service, ConsumerServiceStore.ConsumerAndSecret cas) {
        Assertions.notNull((String)"service", (Object)service);
        Assertions.notNull((String)"cas", (Object)cas);
        Assertions.notNull((String)"cas.consumer", (Object)cas.getConsumer());
        this.delegateStore.put(service, cas);
        this.cache.removeByService(cas);
    }

    @Override
    public void removeByKey(String key) {
        Assertions.notNull((String)"key", (Object)key);
        try {
            this.delegateStore.removeByKey(key);
        }
        finally {
            this.cache.removeByKey(key);
        }
    }

    @Override
    public Iterable<Consumer> getAllServiceProviders() {
        return this.delegateStore.getAllServiceProviders();
    }

    private static class ConsumerCache {
        private final Cache<String, CacheObject<ConsumerServiceStore.ConsumerAndSecret>> consumerCache;
        private final Cache<String, CacheObject<String>> cacheByKey;
        private final ConsumerServiceStore delegateStore;

        private ConsumerCache(CacheManager cacheManager, ConsumerServiceStore delegateStore) {
            this.delegateStore = delegateStore;
            this.consumerCache = cacheManager.getCache(CachingConsumerStore.class.getName() + ".consumerCache", (CacheLoader)new ConsumerCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
            this.cacheByKey = cacheManager.getCache(CachingConsumerStore.class.getName() + ".cacheByKey", (CacheLoader)new ConsumerCacheByKeyLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
        }

        public ConsumerServiceStore.ConsumerAndSecret getByService(String service) {
            return (ConsumerServiceStore.ConsumerAndSecret)((CacheObject)this.consumerCache.get((Object)service)).getValue();
        }

        public String getServiceForKey(String key) {
            return (String)((CacheObject)this.cacheByKey.get((Object)key)).getValue();
        }

        public void removeByService(ConsumerServiceStore.ConsumerAndSecret cas) {
            this.consumerCache.remove((Object)cas.getServiceName());
            this.cacheByKey.remove((Object)cas.getConsumer().getKey());
        }

        public void removeByKey(String key) {
            String service = (String)((CacheObject)this.cacheByKey.get((Object)key)).getValue();
            this.cacheByKey.remove((Object)key);
            if (service != null) {
                this.consumerCache.remove((Object)service);
            }
        }

        public void clear() {
            this.consumerCache.removeAll();
            this.cacheByKey.removeAll();
        }

        private class ConsumerCacheByKeyLoader
        implements CacheLoader<String, CacheObject<String>> {
            private ConsumerCacheByKeyLoader() {
            }

            public CacheObject<String> load(@Nonnull String key) {
                ConsumerServiceStore.ConsumerAndSecret consumerAndSecret = ConsumerCache.this.delegateStore.getByKey(key);
                if (consumerAndSecret == null) {
                    return CacheObject.NULL();
                }
                return CacheObject.wrap((Object)consumerAndSecret.getServiceName());
            }
        }

        private class ConsumerCacheLoader
        implements CacheLoader<String, CacheObject<ConsumerServiceStore.ConsumerAndSecret>> {
            private ConsumerCacheLoader() {
            }

            public CacheObject<ConsumerServiceStore.ConsumerAndSecret> load(@Nonnull String key) {
                return CacheObject.wrap((Object)ConsumerCache.this.delegateStore.get(key));
            }
        }
    }
}

