/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.inviteuser;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.plugin.inviteuser.Invitation;
import com.atlassian.jira.plugin.inviteuser.InvitationMailService;
import com.atlassian.jira.plugin.inviteuser.InvitationManager;
import com.atlassian.jira.plugin.inviteuser.InvitationStore;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;

public class InvitationManagerImpl
implements InvitationManager {
    private final InvitationStore invitationStore;
    private final InvitationMailService invitationMailService;
    private final ApplicationRoleManager roleManager;

    public InvitationManagerImpl(InvitationStore invitationStore, InvitationMailService invitationMailService, ApplicationRoleManager roleManager) {
        this.invitationStore = invitationStore;
        this.invitationMailService = invitationMailService;
        this.roleManager = roleManager;
    }

    @Override
    public Invitation getInvitationByToken(String token) {
        return this.invitationStore.getInvitationByToken(token);
    }

    @Override
    public Collection<Invitation> getInvitationsByEmail(String emailAddress) {
        return this.invitationStore.getInvitationsByEmail(emailAddress);
    }

    @Override
    public Collection<Invitation> getAllInvitations() {
        return this.invitationStore.getAllInvitations();
    }

    @Override
    public Invitation sendInvitation(ApplicationUser from, String emailAddress, Date expiry, @Nonnull Set<ApplicationKey> applicationKeys) {
        Preconditions.checkNotNull(applicationKeys);
        if (this.roleManager.rolesEnabled()) {
            Preconditions.checkArgument((applicationKeys.size() > 0 ? 1 : 0) != 0, (Object)"Can not send invitation without application keys when roles are enabled");
        }
        Invitation invitation = new Invitation(emailAddress, this.generateToken(), expiry, from.getName(), applicationKeys);
        this.invitationStore.addInvitation(invitation);
        this.invitationMailService.sendInvitationEmail(from, invitation);
        return invitation;
    }

    @Override
    public int redeemInvitationsByEmail(String emailAddress) {
        return this.invitationStore.redeemInvitationsByEmail(emailAddress);
    }

    @Override
    public void removeInvitationByToken(String token) {
        this.invitationStore.removeInvitationByToken(token);
    }

    @Override
    public int removeInvitationsByEmail(String emailAddress) {
        return this.invitationStore.removeInvitationsByEmail(emailAddress);
    }

    private String generateToken() {
        String token = UUID.randomUUID().toString();
        while (this.getInvitationByToken(token) != null) {
            token = UUID.randomUUID().toString();
        }
        return token;
    }
}

