/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.administration.quicksearch.jira.spi;

import com.atlassian.administration.quicksearch.internal.ContextMapProvider;
import com.atlassian.administration.quicksearch.internal.NullContextMapProvider;
import com.atlassian.administration.quicksearch.jira.spi.JiraContextHelper;
import com.atlassian.administration.quicksearch.spi.UserContext;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;

public class JiraUserContext
implements UserContext {
    private final HttpServletRequest request;
    private final JiraAuthenticationContext authenticationContext;
    private final I18nResolver resolver;
    private final JiraHelper jiraHelper;

    public JiraUserContext(HttpServletRequest request, JiraAuthenticationContext authenticationContext, I18nResolver resolver, ContextMapProvider contextMapProvider) {
        this.request = (HttpServletRequest)Preconditions.checkNotNull((Object)request, (Object)"request");
        this.authenticationContext = (JiraAuthenticationContext)Preconditions.checkNotNull((Object)authenticationContext, (Object)"authenticationContext");
        this.resolver = resolver;
        this.jiraHelper = JiraContextHelper.createJiraHelper(request, this.getContextMap(request, contextMapProvider));
    }

    public JiraUserContext(HttpServletRequest request, JiraAuthenticationContext authenticationContext, I18nResolver resolver) {
        this(request, authenticationContext, resolver, NullContextMapProvider.INSTANCE);
    }

    private Map<String, Object> getContextMap(HttpServletRequest request, ContextMapProvider contextMapProvider) {
        return ((ContextMapProvider)Preconditions.checkNotNull((Object)contextMapProvider, (Object)"contextMapProvider")).addContextTo(Collections.<String, Object>emptyMap(), request);
    }

    @Override
    public String getUsername() {
        return this.getUser() != null ? this.getUser().getName() : null;
    }

    @Override
    public boolean isAuthenticated() {
        return this.getUser() != null;
    }

    public ApplicationUser getUser() {
        return this.authenticationContext.getUser();
    }

    @Override
    @Nonnull
    public Locale getLocale() {
        return this.authenticationContext.getLocale();
    }

    @Override
    @Nonnull
    public I18nResolver getI18nResolver() {
        return this.resolver;
    }

    @Override
    @Nonnull
    public HttpServletRequest getRequest() {
        return this.request;
    }

    @Override
    @Nonnull
    public Map<String, Object> getContextMap() {
        return this.jiraHelper.getContextParams();
    }

    public JiraHelper getJiraHelper() {
        return this.jiraHelper;
    }
}

