/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.administration.quicksearch.impl.spi.ondemand;

import com.atlassian.administration.quicksearch.impl.spi.AdminLinkSectionBean;
import com.atlassian.administration.quicksearch.impl.spi.DefaultAdminLinkManager;
import com.atlassian.administration.quicksearch.internal.OnDemandDetector;
import com.atlassian.administration.quicksearch.spi.AdminLink;
import com.atlassian.administration.quicksearch.spi.AdminLinkSection;
import com.atlassian.administration.quicksearch.spi.UserContext;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;

public class OnDemandAwareAdminLinkManager
extends DefaultAdminLinkManager {
    private final OnDemandDetector onDemandDetector;

    public OnDemandAwareAdminLinkManager(WebInterfaceManager webInterfaceManager, OnDemandDetector onDemandDetector) {
        super(webInterfaceManager);
        this.onDemandDetector = onDemandDetector;
    }

    @Nonnull
    protected Map<String, String> defaultSections() {
        return Collections.emptyMap();
    }

    @Override
    @Nonnull
    public final AdminLinkSection getSection(String location, UserContext userContext) {
        String defaultSectionLabel = this.defaultSections().get(location);
        if (this.onDemandDefaultSection(defaultSectionLabel)) {
            AdminLinkSection original = super.getSection(location, userContext);
            AdminLinkSectionBean withLabel = new AdminLinkSectionBean(original.getId(), defaultSectionLabel, original.getParameters(), original.getLocation(), original.getSections(), original.getLinks());
            return new AdminLinkSectionBean(null, null, null, location, (Iterable<AdminLinkSection>)ImmutableList.of((Object)withLabel), Collections.<AdminLink>emptyList());
        }
        return super.getSection(location, userContext);
    }

    private boolean onDemandDefaultSection(String defaultSectionLabel) {
        return defaultSectionLabel != null && this.onDemandDetector.isOnDemandMode();
    }
}

