/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.admin.ldap;

import com.atlassian.crowd.directory.GenericLDAP;
import com.atlassian.crowd.embedded.admin.ldap.LdapDirectoryConfiguration;
import org.apache.commons.lang.math.NumberUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

public final class LdapDirectoryConfigurationValidator
implements Validator {
    public boolean supports(Class clazz) {
        return LdapDirectoryConfiguration.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        String ldapAutoAddGroups;
        LdapDirectoryConfiguration configuration = (LdapDirectoryConfiguration)target;
        if (NumberUtils.toLong(configuration.getLdapCacheSynchroniseIntervalInMin()) < 1L) {
            errors.rejectValue("ldapCacheSynchroniseIntervalInMin", "invalid");
        }
        if ((ldapAutoAddGroups = configuration.getLdapAutoAddGroups()) != null && ldapAutoAddGroups.indexOf(124) != -1) {
            errors.rejectValue("ldapAutoAddGroups", "invalid");
        }
        if (!GenericLDAP.class.getName().equals(configuration.getType())) {
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"ldapBasedn", (String)"required");
        }
    }
}

