/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.admin;

import com.atlassian.crowd.directory.DelegatedAuthenticationDirectory;
import com.atlassian.crowd.directory.InternalDirectory;
import com.atlassian.crowd.directory.RemoteCrowdDirectory;
import com.atlassian.crowd.embedded.admin.DirectoryMapper;
import com.atlassian.crowd.embedded.admin.crowd.CrowdDirectoryConfiguration;
import com.atlassian.crowd.embedded.admin.crowd.CrowdPermissionOption;
import com.atlassian.crowd.embedded.admin.delegatingldap.DelegatingLdapDirectoryConfiguration;
import com.atlassian.crowd.embedded.admin.directory.CrowdDirectoryAttributes;
import com.atlassian.crowd.embedded.admin.directory.LdapDelegatingDirectoryAttributes;
import com.atlassian.crowd.embedded.admin.directory.LdapDirectoryAttributes;
import com.atlassian.crowd.embedded.admin.internal.InternalDirectoryConfiguration;
import com.atlassian.crowd.embedded.admin.jirajdbc.JiraJdbcDirectoryConfiguration;
import com.atlassian.crowd.embedded.admin.ldap.LdapDirectoryConfiguration;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PermissionOption;
import com.atlassian.crowd.embedded.impl.ImmutableDirectory;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.springframework.beans.BeanUtils;

public final class DefaultDirectoryMapper
implements DirectoryMapper {
    @Override
    public Directory buildCrowdDirectory(CrowdDirectoryConfiguration configuration) {
        ImmutableDirectory.Builder builder = this.createBuilder();
        builder.setAllowedOperations(configuration.getCrowdPermissionOption().getAllowedOperations());
        builder.setActive(configuration.isActive());
        builder.setId(Long.valueOf(configuration.getDirectoryId()));
        builder.setImplementationClass(RemoteCrowdDirectory.class.getName());
        builder.setName(configuration.getName());
        builder.setType(DirectoryType.CROWD);
        CrowdDirectoryAttributes attributes = new CrowdDirectoryAttributes();
        BeanUtils.copyProperties((Object)configuration, (Object)attributes);
        attributes.setCrowdServerSynchroniseIntervalInSeconds(Long.toString(configuration.getCrowdServerSynchroniseIntervalInMin() * 60L));
        builder.setAttributes(attributes.toAttributesMap());
        return builder.toDirectory();
    }

    @Override
    public Directory buildLdapDirectory(LdapDirectoryConfiguration configuration) {
        ImmutableDirectory.Builder builder = this.createBuilder();
        builder.setActive(configuration.isActive());
        builder.setAllowedOperations(configuration.getLdapPermissionOption().getAllowedOperations());
        builder.setEncryptionType(configuration.getLdapUserEncryption());
        builder.setId(Long.valueOf(configuration.getDirectoryId()));
        builder.setImplementationClass(configuration.getType());
        builder.setName(configuration.getName());
        builder.setType(DirectoryType.CONNECTOR);
        LdapDirectoryAttributes attributes = new LdapDirectoryAttributes();
        BeanUtils.copyProperties((Object)configuration, (Object)attributes);
        attributes.setIncrementalSyncEnabled(configuration.isCrowdSyncIncrementalEnabled());
        if (configuration.getLdapPermissionOption() == PermissionOption.READ_ONLY_LOCAL_GROUPS) {
            attributes.setLdapAutoAddGroups(DefaultDirectoryMapper.commaWhitespaceSeparatedGroupsToPipeSeparatedGroups(configuration.getLdapAutoAddGroups()));
        } else {
            attributes.setLdapAutoAddGroups("");
        }
        builder.setAttributes(attributes.toAttributesMap());
        return builder.toDirectory();
    }

    @Override
    public Directory buildDelegatingLdapDirectory(DelegatingLdapDirectoryConfiguration configuration) {
        ImmutableDirectory.Builder builder = this.createBuilder();
        builder.setActive(configuration.isActive());
        builder.setId(Long.valueOf(configuration.getDirectoryId()));
        builder.setImplementationClass(DelegatedAuthenticationDirectory.class.getName());
        builder.setName(configuration.getName());
        builder.setType(DirectoryType.DELEGATING);
        LdapDelegatingDirectoryAttributes attributes = new LdapDelegatingDirectoryAttributes();
        BeanUtils.copyProperties((Object)configuration, (Object)attributes);
        attributes.setDelegatedToClass(configuration.getType());
        EnumSet<OperationType> allowedOperations = EnumSet.allOf(OperationType.class);
        if (configuration.isCreateUserOnAuth()) {
            if (configuration.isUpdateUserOnAuth()) {
                attributes.setUpdateUserOnAuth(true);
                allowedOperations.remove(OperationType.UPDATE_USER);
            } else {
                attributes.setUpdateUserOnAuth(false);
            }
            attributes.setLdapAutoAddGroups(DefaultDirectoryMapper.commaWhitespaceSeparatedGroupsToPipeSeparatedGroups(configuration.getLdapAutoAddGroups()));
        } else {
            attributes.setUpdateUserOnAuth(false);
            attributes.setLdapAutoAddGroups("");
        }
        builder.setAllowedOperations(allowedOperations);
        builder.setAttributes(attributes.toAttributesMap());
        return builder.toDirectory();
    }

    @Override
    public Directory buildInternalDirectory(InternalDirectoryConfiguration configuration) {
        ImmutableDirectory.Builder builder = this.createBuilder();
        builder.setAllowedOperations(EnumSet.allOf(OperationType.class));
        builder.setActive(configuration.isActive());
        builder.setId(Long.valueOf(configuration.getDirectoryId()));
        builder.setImplementationClass(InternalDirectory.class.getName());
        builder.setName(configuration.getName());
        builder.setType(DirectoryType.INTERNAL);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("user_encryption_method", "atlassian-security");
        map.put("useNestedGroups", Boolean.valueOf(configuration.isNestedGroupsEnabled()).toString());
        builder.setAttributes(map);
        return builder.toDirectory();
    }

    @Override
    public Directory buildJiraJdbcDirectory(JiraJdbcDirectoryConfiguration configuration) {
        ImmutableDirectory.Builder builder = this.createBuilder();
        builder.setAllowedOperations(EnumSet.of(OperationType.UPDATE_USER));
        builder.setActive(configuration.isActive());
        builder.setId(Long.valueOf(configuration.getDirectoryId()));
        builder.setImplementationClass("com.atlassian.confluence.user.crowd.jira.JiraJdbcRemoteDirectory");
        builder.setName(configuration.getName());
        builder.setType(DirectoryType.CUSTOM);
        builder.setAttributes(Collections.singletonMap("jirajdbc.datasource.url", configuration.getDatasourceJndiName()));
        return builder.toDirectory();
    }

    private ImmutableDirectory.Builder createBuilder() {
        ImmutableDirectory.Builder builder = ImmutableDirectory.newBuilder();
        Date now = new Date();
        builder.setCreatedDate(now);
        builder.setUpdatedDate(now);
        return builder;
    }

    @Override
    public CrowdDirectoryConfiguration toCrowdConfiguration(Directory directory) {
        CrowdDirectoryConfiguration configuration = new CrowdDirectoryConfiguration();
        configuration.setCrowdPermissionOption(CrowdPermissionOption.fromAllowedOperations(directory.getAllowedOperations()));
        configuration.setDirectoryId(directory.getId() != null ? directory.getId() : 0L);
        configuration.setActive(directory.isActive());
        configuration.setName(directory.getName());
        CrowdDirectoryAttributes attributes = CrowdDirectoryAttributes.fromAttributesMap(directory.getAttributes());
        BeanUtils.copyProperties((Object)attributes, (Object)configuration);
        configuration.setCrowdServerSynchroniseIntervalInMin(NumberUtils.toLong(attributes.getCrowdServerSynchroniseIntervalInSeconds()) / 60L);
        return configuration;
    }

    @Override
    public LdapDirectoryConfiguration toLdapConfiguration(Directory directory) {
        LdapDirectoryConfiguration configuration = new LdapDirectoryConfiguration();
        configuration.setLdapPermissionOption(PermissionOption.fromAllowedOperations((Set)directory.getAllowedOperations()));
        configuration.setActive(directory.isActive());
        configuration.setLdapUserEncryption(directory.getEncryptionType());
        configuration.setDirectoryId(directory.getId() != null ? directory.getId() : 0L);
        configuration.setType(directory.getImplementationClass());
        configuration.setName(directory.getName());
        LdapDirectoryAttributes attributes = LdapDirectoryAttributes.fromAttributesMap(directory.getAttributes());
        BeanUtils.copyProperties((Object)attributes, (Object)configuration);
        configuration.setCrowdSyncIncrementalEnabled(attributes.isIncrementalSyncEnabled());
        configuration.setLdapAutoAddGroups(DefaultDirectoryMapper.pipeSeparatedGroupsToCommaSeparatedGroups(attributes.getLdapAutoAddGroups()));
        return configuration;
    }

    @Override
    public DelegatingLdapDirectoryConfiguration toDelegatingLdapConfiguration(Directory directory) {
        DelegatingLdapDirectoryConfiguration configuration = new DelegatingLdapDirectoryConfiguration();
        configuration.setDirectoryId(directory.getId() != null ? directory.getId() : 0L);
        configuration.setActive(directory.isActive());
        configuration.setName(directory.getName());
        LdapDelegatingDirectoryAttributes attributes = LdapDelegatingDirectoryAttributes.fromAttributesMap(directory.getAttributes());
        BeanUtils.copyProperties((Object)attributes, (Object)configuration);
        configuration.setType(attributes.getDelegatedToClass());
        String ldapAutoAddGroups = attributes.getLdapAutoAddGroups();
        if (ldapAutoAddGroups != null) {
            configuration.setLdapAutoAddGroups(DefaultDirectoryMapper.pipeSeparatedGroupsToCommaSeparatedGroups(ldapAutoAddGroups));
        } else {
            configuration.setLdapAutoAddGroups("");
        }
        return configuration;
    }

    @Override
    public JiraJdbcDirectoryConfiguration toJiraJdbcConfiguration(Directory directory) {
        JiraJdbcDirectoryConfiguration configuration = new JiraJdbcDirectoryConfiguration();
        configuration.setDirectoryId(directory.getId() != null ? directory.getId() : 0L);
        configuration.setActive(directory.isActive());
        configuration.setName(directory.getName());
        configuration.setDatasourceJndiName((String)directory.getAttributes().get("jirajdbc.datasource.url"));
        return configuration;
    }

    @Override
    public InternalDirectoryConfiguration toInternalConfiguration(Directory directory) {
        InternalDirectoryConfiguration configuration = new InternalDirectoryConfiguration();
        configuration.setDirectoryId(directory.getId() != null ? directory.getId() : 0L);
        configuration.setActive(directory.isActive());
        configuration.setName(directory.getName());
        Map attributes = directory.getAttributes();
        String useNestedGroups = (String)attributes.get("useNestedGroups");
        if (useNestedGroups != null) {
            configuration.setNestedGroupsEnabled(Boolean.valueOf(useNestedGroups));
        } else {
            configuration.setNestedGroupsEnabled(false);
        }
        return configuration;
    }

    public static String pipeSeparatedGroupsToCommaSeparatedGroups(String pipeSeparated) {
        return StringUtils.replaceChars(pipeSeparated, '|', ',');
    }

    public static String commaWhitespaceSeparatedGroupsToPipeSeparatedGroups(String commaSeparated) {
        if (commaSeparated == null) {
            return "";
        }
        String[] untrimmedGroups = StringUtils.split(commaSeparated, ',');
        LinkedHashSet<String> uniqueGroups = new LinkedHashSet<String>(untrimmedGroups.length);
        for (String untrimmedGroup : untrimmedGroups) {
            uniqueGroups.add(untrimmedGroup.trim());
        }
        return StringUtils.join(uniqueGroups, '|');
    }
}

