/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.browsermetrics.components;

import com.atlassian.fugue.Option;
import com.atlassian.studio.common.manifestohash.ManifestoHashService;
import javax.annotation.Nonnull;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class ManifestoHashAdapter
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(ManifestoHashAdapter.class);
    private static final String MANIFESTO_SERVICE_NAME = "com.atlassian.studio.common.manifestohash.ManifestoHashService";
    private final BundleContext bundleContext;
    private Option<ServiceTracker> manifestoHashServiceTracker;

    public ManifestoHashAdapter(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Nonnull
    public String getManifestoHash() {
        return (String)this.manifestoHashServiceTracker.fold(() -> "", manifestoHashServiceTracker -> (String)Option.option((Object)((ManifestoHashService)manifestoHashServiceTracker.getService())).flatMap(ManifestoHashService::getManifestoHash).getOrElse((Object)""));
    }

    public void afterPropertiesSet() throws Exception {
        try {
            Class<?> aClass = Class.forName(MANIFESTO_SERVICE_NAME);
            ServiceTracker serviceTracker = new ServiceTracker(this.bundleContext, aClass.getName(), null);
            serviceTracker.open();
            this.manifestoHashServiceTracker = Option.some((Object)serviceTracker);
        }
        catch (ClassNotFoundException e) {
            log.info("Class {} not found. The manifestoHash won't be reported", (Object)MANIFESTO_SERVICE_NAME);
            this.manifestoHashServiceTracker = Option.none();
        }
    }

    public void destroy() throws Exception {
        if (this.manifestoHashServiceTracker.isDefined()) {
            ((ServiceTracker)this.manifestoHashServiceTracker.get()).close();
        }
    }
}

