/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.validator.html.scan;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.batik.css.parser.ParseException;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xml.serialize.HTMLSerializer;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XHTMLSerializer;
import org.cyberneko.html.parsers.DOMFragmentParser;
import org.owasp.validator.css.CssScanner;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;
import org.owasp.validator.html.model.Attribute;
import org.owasp.validator.html.model.Tag;
import org.owasp.validator.html.scan.AbstractAntiSamyScanner;
import org.owasp.validator.html.scan.Constants;
import org.owasp.validator.html.util.HTMLEntityEncoder;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;

public class AntiSamyDOMScanner
extends AbstractAntiSamyScanner {
    private Document document = new DocumentImpl();
    private DocumentFragment dom = this.document.createDocumentFragment();
    private CleanResults results = null;

    public CleanResults scan(String html, String inputEncoding, String outputEncoding) throws ScanException {
        if (html == null) {
            throw new ScanException(new NullPointerException("Null input"));
        }
        int maxInputSize = this.policy.getMaxInputSize();
        if (maxInputSize < html.length()) {
            this.addError("error.size.toolarge", new Object[]{new Integer(html.length()), new Integer(maxInputSize)});
            throw new ScanException(this.errorMessages.get(0).toString());
        }
        this.isNofollowAnchors = "true".equals(this.policy.getDirective("nofollowAnchors"));
        this.isValidateParamAsEmbed = "true".equals(this.policy.getDirective("validateParamAsEmbed"));
        Date start = new Date();
        try {
            HTMLSerializer serializer;
            html = this.stripNonValidXMLCharacters(html);
            DOMFragmentParser parser = new DOMFragmentParser();
            parser.setProperty("http://cyberneko.org/html/properties/names/elems", (Object)"lower");
            parser.setProperty("http://cyberneko.org/html/properties/default-encoding", (Object)inputEncoding);
            parser.setFeature("http://cyberneko.org/html/features/scanner/style/strip-cdata-delims", false);
            parser.setFeature("http://cyberneko.org/html/features/scanner/cdata-sections", true);
            try {
                parser.setFeature("http://cyberneko.org/html/features/enforce-strict-attribute-names", true);
            }
            catch (SAXNotRecognizedException se) {
                // empty catch block
            }
            try {
                parser.parse(new InputSource(new StringReader(html)), this.dom);
            }
            catch (Exception e) {
                throw new ScanException(e);
            }
            for (int i = 0; i < this.dom.getChildNodes().getLength(); ++i) {
                Node tmp = this.dom.getChildNodes().item(i);
                this.recursiveValidateTag(tmp);
                if (tmp.getParentNode() != null) continue;
                --i;
            }
            OutputFormat format = new OutputFormat();
            format.setEncoding(outputEncoding);
            StringWriter sw = new StringWriter();
            format.setEncoding(outputEncoding);
            format.setOmitXMLDeclaration("true".equals(this.policy.getDirective("omitXmlDeclaration")));
            format.setOmitDocumentType("true".equals(this.policy.getDirective("omitDoctypeDeclaration")));
            format.setPreserveEmptyAttributes(true);
            if ("true".equals(this.policy.getDirective("formatOutput"))) {
                format.setLineWidth(80);
                format.setIndenting(true);
                format.setIndent(2);
            }
            boolean preserveSpace = this.policy.getDirective("preserveSpace") != null ? "true".equals(this.policy.getDirective("preserveSpace")) : true;
            format.setPreserveSpace(preserveSpace);
            if ("true".equals(this.policy.getDirective("useXHTML"))) {
                serializer = new XHTMLSerializer(sw, format);
                serializer.serialize(this.dom);
            } else {
                serializer = new HTMLSerializer(sw, format);
                serializer.serialize(this.dom);
            }
            String finalCleanHTML = sw.getBuffer().toString();
            if (finalCleanHTML.endsWith("\n") && !html.endsWith("\n")) {
                if (finalCleanHTML.endsWith("\r\n")) {
                    finalCleanHTML = finalCleanHTML.substring(0, finalCleanHTML.length() - 2);
                } else if (finalCleanHTML.endsWith("\n")) {
                    finalCleanHTML = finalCleanHTML.substring(0, finalCleanHTML.length() - 1);
                }
            }
            this.results = new CleanResults(start, new Date(), finalCleanHTML, this.dom, this.errorMessages);
            return this.results;
        }
        catch (SAXException e) {
            throw new ScanException(e);
        }
        catch (IOException e) {
            throw new ScanException(e);
        }
    }

    private void recursiveValidateTag(Node node) {
        Tag embedPolicy;
        if (node instanceof Comment) {
            String preserveComments = this.policy.getDirective("preserveComments");
            if (preserveComments == null || !"true".equals(preserveComments)) {
                node.getParentNode().removeChild(node);
            } else {
                String value = ((Comment)node).getData();
                if (value != null) {
                    ((Comment)node).setData(value.replaceAll("<?!?\\[\\s*(?:end)?if[^]]*\\]>?", ""));
                }
            }
            return;
        }
        if (node instanceof Element && node.getChildNodes().getLength() == 0) {
            boolean isEmptyAllowed = false;
            for (int i = 0; i < Constants.allowedEmptyTags.length; ++i) {
                if (!Constants.allowedEmptyTags[i].equalsIgnoreCase(node.getNodeName())) continue;
                isEmptyAllowed = true;
                i = Constants.allowedEmptyTags.length;
            }
            if (!isEmptyAllowed) {
                this.addError("error.tag.empty", new Object[]{HTMLEntityEncoder.htmlEntityEncode(node.getNodeName())});
                node.getParentNode().removeChild(node);
                return;
            }
        }
        if (node instanceof Text && 4 == node.getNodeType()) {
            this.addError("error.cdata.found", new Object[]{HTMLEntityEncoder.htmlEntityEncode(node.getTextContent())});
            Text text = this.document.createTextNode(node.getTextContent());
            node.getParentNode().insertBefore(text, node);
            node.getParentNode().removeChild(node);
            return;
        }
        if (node instanceof ProcessingInstruction) {
            this.addError("error.pi.found", new Object[]{HTMLEntityEncoder.htmlEntityEncode(node.getTextContent())});
            node.getParentNode().removeChild(node);
        }
        if (!(node instanceof Element)) {
            return;
        }
        Element ele = (Element)node;
        Node parentNode = ele.getParentNode();
        Node tmp = null;
        String tagName = ele.getNodeName();
        Tag tag = this.policy.getTagByName(tagName.toLowerCase());
        boolean masqueradingParam = false;
        if (tag == null && this.isValidateParamAsEmbed && "param".equals(tagName.toLowerCase()) && (embedPolicy = this.policy.getTagByName("embed")) != null && "validate".equals(embedPolicy.getAction())) {
            tag = Constants.BASIC_PARAM_TAG_RULE;
            masqueradingParam = true;
        }
        if (tag == null && "encode".equals(this.policy.getDirective("onUnknownTag")) || tag != null && "encode".equals(tag.getAction())) {
            this.addError("error.tag.encoded", new Object[]{HTMLEntityEncoder.htmlEntityEncode(tagName)});
            for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                tmp = node.getChildNodes().item(i);
                this.recursiveValidateTag(tmp);
                if (tmp.getParentNode() != null) continue;
                --i;
            }
            this.encodeAndPromoteChildren(ele);
            return;
        }
        if (tag == null || "filter".equals(tag.getAction())) {
            if (tag == null) {
                this.addError("error.tag.notfound", new Object[]{HTMLEntityEncoder.htmlEntityEncode(tagName)});
            } else {
                this.addError("error.tag.filtered", new Object[]{HTMLEntityEncoder.htmlEntityEncode(tagName)});
            }
            for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                tmp = node.getChildNodes().item(i);
                this.recursiveValidateTag(tmp);
                if (tmp.getParentNode() != null) continue;
                --i;
            }
            this.promoteChildren(ele);
            return;
        }
        if ("validate".equals(tag.getAction())) {
            String nameValue = null;
            if (masqueradingParam && (nameValue = ele.getAttribute("name")) != null && !"".equals(nameValue)) {
                String valueValue = ele.getAttribute("value");
                ele.setAttribute(nameValue, valueValue);
                ele.removeAttribute("name");
                ele.removeAttribute("value");
                tag = this.policy.getTagByName("embed");
            }
            if ("style".equals(tagName.toLowerCase()) && this.policy.getTagByName("style") != null) {
                CssScanner styleScanner = new CssScanner(this.policy, this.messages);
                try {
                    if (node.getFirstChild() != null) {
                        String toScan = node.getFirstChild().getNodeValue();
                        CleanResults cr = styleScanner.scanStyleSheet(toScan, this.policy.getMaxInputSize());
                        this.errorMessages.addAll(cr.getErrorMessages());
                        String cleanHTML = cr.getCleanHTML();
                        if (cleanHTML == null || cleanHTML.equals("")) {
                            node.getFirstChild().setNodeValue("/* */");
                        } else {
                            node.getFirstChild().setNodeValue(cleanHTML);
                        }
                    }
                }
                catch (DOMException e) {
                    this.addError("error.css.tag.malformed", new Object[]{HTMLEntityEncoder.htmlEntityEncode(node.getFirstChild().getNodeValue())});
                    parentNode.removeChild(node);
                    return;
                }
                catch (ScanException e) {
                    this.addError("error.css.tag.malformed", new Object[]{HTMLEntityEncoder.htmlEntityEncode(node.getFirstChild().getNodeValue())});
                    parentNode.removeChild(node);
                    return;
                }
                catch (ParseException e) {
                    this.addError("error.css.tag.malformed", new Object[]{HTMLEntityEncoder.htmlEntityEncode(node.getFirstChild().getNodeValue())});
                    parentNode.removeChild(node);
                    return;
                }
                catch (NumberFormatException e) {
                    this.addError("error.css.tag.malformed", new Object[]{HTMLEntityEncoder.htmlEntityEncode(node.getFirstChild().getNodeValue())});
                    parentNode.removeChild(node);
                    return;
                }
            }
            Node attribute = null;
            for (int currentAttributeIndex = 0; currentAttributeIndex < ele.getAttributes().getLength(); ++currentAttributeIndex) {
                attribute = ele.getAttributes().item(currentAttributeIndex);
                String name = attribute.getNodeName();
                String value = attribute.getNodeValue();
                Attribute attr = tag.getAttributeByName(name.toLowerCase());
                if (attr == null) {
                    attr = this.policy.getGlobalAttributeByName(name);
                }
                boolean isAttributeValid = false;
                if ("style".equals(name.toLowerCase()) && attr != null) {
                    CssScanner styleScanner = new CssScanner(this.policy, this.messages);
                    try {
                        CleanResults cr = styleScanner.scanInlineStyle(value, tagName, this.policy.getMaxInputSize());
                        attribute.setNodeValue(cr.getCleanHTML());
                        ArrayList cssScanErrorMessages = cr.getErrorMessages();
                        this.errorMessages.addAll(cssScanErrorMessages);
                    }
                    catch (DOMException e) {
                        this.addError("error.css.attribute.malformed", new Object[]{tagName, HTMLEntityEncoder.htmlEntityEncode(node.getNodeValue())});
                        ele.removeAttribute(attribute.getNodeName());
                        --currentAttributeIndex;
                    }
                    catch (ScanException e) {
                        this.addError("error.css.attribute.malformed", new Object[]{tagName, HTMLEntityEncoder.htmlEntityEncode(node.getNodeValue())});
                        ele.removeAttribute(attribute.getNodeName());
                        --currentAttributeIndex;
                    }
                    continue;
                }
                if (attr != null) {
                    int i;
                    Iterator allowedValues = attr.getAllowedValues().iterator();
                    while (allowedValues.hasNext() && !isAttributeValid) {
                        String allowedValue = (String)allowedValues.next();
                        if (allowedValue == null || !allowedValue.toLowerCase().equals(value.toLowerCase())) continue;
                        isAttributeValid = true;
                    }
                    Iterator allowedRegexps = attr.getAllowedRegExp().iterator();
                    while (allowedRegexps.hasNext() && !isAttributeValid) {
                        Pattern pattern = (Pattern)allowedRegexps.next();
                        if (pattern == null || !pattern.matcher(value.toLowerCase()).matches()) continue;
                        isAttributeValid = true;
                    }
                    if (isAttributeValid) continue;
                    String onInvalidAction = attr.getOnInvalid();
                    if ("removeTag".equals(onInvalidAction)) {
                        parentNode.removeChild(ele);
                        this.addError("error.attribute.invalid.removed", new Object[]{tagName, HTMLEntityEncoder.htmlEntityEncode(name), HTMLEntityEncoder.htmlEntityEncode(value)});
                        return;
                    }
                    if ("filterTag".equals(onInvalidAction)) {
                        for (i = 0; i < node.getChildNodes().getLength(); ++i) {
                            tmp = node.getChildNodes().item(i);
                            this.recursiveValidateTag(tmp);
                            if (tmp.getParentNode() != null) continue;
                            --i;
                        }
                        this.promoteChildren(ele);
                        this.addError("error.attribute.invalid.filtered", new Object[]{tagName, HTMLEntityEncoder.htmlEntityEncode(name), HTMLEntityEncoder.htmlEntityEncode(value)});
                        continue;
                    }
                    if ("encodeTag".equals(onInvalidAction)) {
                        for (i = 0; i < node.getChildNodes().getLength(); ++i) {
                            tmp = node.getChildNodes().item(i);
                            this.recursiveValidateTag(tmp);
                            if (tmp.getParentNode() != null) continue;
                            --i;
                        }
                        this.encodeAndPromoteChildren(ele);
                        this.addError("error.attribute.invalid.encoded", new Object[]{tagName, HTMLEntityEncoder.htmlEntityEncode(name), HTMLEntityEncoder.htmlEntityEncode(value)});
                        continue;
                    }
                    ele.removeAttribute(attribute.getNodeName());
                    --currentAttributeIndex;
                    this.addError("error.attribute.invalid", new Object[]{tagName, HTMLEntityEncoder.htmlEntityEncode(name), HTMLEntityEncoder.htmlEntityEncode(value)});
                    if (!"removeTag".equals(onInvalidAction) && !"filterTag".equals(onInvalidAction)) continue;
                    return;
                }
                this.addError("error.attribute.notfound", new Object[]{tagName, HTMLEntityEncoder.htmlEntityEncode(name), HTMLEntityEncoder.htmlEntityEncode(value)});
                ele.removeAttribute(attribute.getNodeName());
                --currentAttributeIndex;
            }
            if (this.isNofollowAnchors && "a".equals(tagName.toLowerCase())) {
                ele.setAttribute("rel", "nofollow");
            }
            for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                tmp = node.getChildNodes().item(i);
                this.recursiveValidateTag(tmp);
                if (tmp.getParentNode() != null) continue;
                --i;
            }
            if (masqueradingParam && nameValue != null && !"".equals(nameValue)) {
                String valueValue = ele.getAttribute(nameValue);
                ele.setAttribute("name", nameValue);
                ele.setAttribute("value", valueValue);
                ele.removeAttribute(nameValue);
            }
            return;
        }
        if ("truncate".equals(tag.getAction())) {
            NamedNodeMap nnmap = ele.getAttributes();
            while (nnmap.getLength() > 0) {
                this.addError("error.attribute.notfound", new Object[]{tagName, HTMLEntityEncoder.htmlEntityEncode(nnmap.item(0).getNodeName())});
                ele.removeAttribute(nnmap.item(0).getNodeName());
            }
            NodeList cList = ele.getChildNodes();
            int j = 0;
            int length = cList.getLength();
            for (int i = 0; i < length; ++i) {
                Node nodeToRemove = cList.item(j);
                if (nodeToRemove.getNodeType() != 3) {
                    ele.removeChild(nodeToRemove);
                    continue;
                }
                ++j;
            }
        } else {
            this.addError("error.tag.removed", new Object[]{HTMLEntityEncoder.htmlEntityEncode(tagName)});
            parentNode.removeChild(ele);
        }
    }

    public static void main(String[] args) throws PolicyException {
    }

    public AntiSamyDOMScanner(Policy policy) {
        super(policy);
    }

    public AntiSamyDOMScanner() throws PolicyException {
    }

    private void promoteChildren(Element ele) {
        NodeList nodeList = ele.getChildNodes();
        Node parent = ele.getParentNode();
        while (nodeList.getLength() > 0) {
            Node node = ele.removeChild(nodeList.item(0));
            parent.insertBefore(node, ele);
        }
        parent.removeChild(ele);
    }

    private String stripNonValidXMLCharacters(String in) {
        if (in == null || "".equals(in)) {
            return "";
        }
        return in.replaceAll("[\\u0000-\\u001F\\uD800-\\uDFFF\\uFFFE-\\uFFFF&&[^\\u0009\\u000A\\u000D]]", "");
    }

    private void encodeAndPromoteChildren(Element ele) {
        Node parent = ele.getParentNode();
        String tagName = ele.getTagName();
        Text openingTag = parent.getOwnerDocument().createTextNode(this.toString(ele));
        parent.insertBefore(openingTag, ele);
        if (ele.hasChildNodes()) {
            Text closingTag = parent.getOwnerDocument().createTextNode("</" + tagName + ">");
            parent.insertBefore(closingTag, ele.getNextSibling());
        }
        this.promoteChildren(ele);
    }

    private String toString(Element ele) {
        StringBuffer eleAsString = new StringBuffer("<" + ele.getNodeName());
        NamedNodeMap attributes = ele.getAttributes();
        Node attribute = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            attribute = attributes.item(i);
            String name = attribute.getNodeName();
            String value = attribute.getNodeValue();
            eleAsString.append(" ");
            eleAsString.append(HTMLEntityEncoder.htmlEntityEncode(name));
            eleAsString.append("=\"");
            eleAsString.append(HTMLEntityEncoder.htmlEntityEncode(value));
            eleAsString.append("\"");
        }
        if (ele.hasChildNodes()) {
            eleAsString.append(">");
        } else {
            eleAsString.append("/>");
        }
        return eleAsString.toString();
    }

    public CleanResults getResults() {
        return this.results;
    }
}

