/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.regexp;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.javascript.regexp.RegExpJsToJavaConverter;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.RegExpProxy;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.regexp.NativeRegExp;
import net.sourceforge.htmlunit.corejs.javascript.regexp.RegExpImpl;
import net.sourceforge.htmlunit.corejs.javascript.regexp.SubString;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HtmlUnitRegExpProxy
extends RegExpImpl {
    private static final Log LOG = LogFactory.getLog(HtmlUnitRegExpProxy.class);
    private static final Pattern REPLACE_PATTERN = Pattern.compile("\\$\\$");
    private final RegExpProxy wrapped_;
    private final BrowserVersion browserVersion_;

    public HtmlUnitRegExpProxy(RegExpProxy wrapped, BrowserVersion browserVersion) {
        this.wrapped_ = wrapped;
        this.browserVersion_ = browserVersion;
    }

    @Override
    public Object action(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, int actionType) {
        try {
            return this.doAction(cx, scope, thisObj, args, actionType);
        }
        catch (StackOverflowError e) {
            LOG.warn(e.getMessage(), e);
            return this.wrapped_.action(cx, scope, thisObj, args, actionType);
        }
    }

    private Object doAction(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, int actionType) {
        if (2 == actionType && args.length == 2 && args[1] instanceof String) {
            String thisString = Context.toString(thisObj);
            String replacement = (String)args[1];
            Object arg0 = args[0];
            if (arg0 instanceof String) {
                replacement = REPLACE_PATTERN.matcher(replacement).replaceAll("\\$");
                return StringUtils.replaceOnce(thisString, (String)arg0, replacement);
            }
            if (arg0 instanceof NativeRegExp) {
                try {
                    NativeRegExp regexp = (NativeRegExp)arg0;
                    RegExpData reData = new RegExpData(regexp);
                    String regex = reData.getJavaPattern();
                    int flags = reData.getJavaFlags();
                    Pattern pattern = Pattern.compile(regex, flags);
                    Matcher matcher = pattern.matcher(thisString);
                    return this.doReplacement(thisString, replacement, matcher, reData.hasFlag('g'));
                }
                catch (PatternSyntaxException e) {
                    LOG.warn(e.getMessage(), e);
                }
            }
        } else if (1 == actionType || 3 == actionType) {
            if (args.length == 0) {
                return null;
            }
            Object arg0 = args[0];
            String thisString = Context.toString(thisObj);
            RegExpData reData = arg0 instanceof NativeRegExp ? new RegExpData((NativeRegExp)arg0) : new RegExpData(Context.toString(arg0));
            Pattern pattern = Pattern.compile(reData.getJavaPattern(), reData.getJavaFlags());
            Matcher matcher = pattern.matcher(thisString);
            boolean found = matcher.find();
            if (3 == actionType) {
                if (found) {
                    this.setProperties(matcher, thisString, matcher.start(), matcher.end());
                    return matcher.start();
                }
                return -1;
            }
            if (!found) {
                return null;
            }
            int index = matcher.start(0);
            ArrayList<Object> groups = new ArrayList<Object>();
            if (reData.hasFlag('g')) {
                groups.add(matcher.group(0));
                this.setProperties(matcher, thisString, matcher.start(0), matcher.end(0));
                while (matcher.find()) {
                    groups.add(matcher.group(0));
                    this.setProperties(matcher, thisString, matcher.start(0), matcher.end(0));
                }
            } else {
                for (int i = 0; i <= matcher.groupCount(); ++i) {
                    Object group = matcher.group(i);
                    if (group == null) {
                        group = Context.getUndefinedValue();
                    }
                    groups.add(group);
                }
                this.setProperties(matcher, thisString, matcher.start(), matcher.end());
            }
            Scriptable response = cx.newArray(scope, groups.toArray());
            response.put("index", response, (Object)index);
            response.put("input", response, (Object)thisString);
            return response;
        }
        return this.wrappedAction(cx, scope, thisObj, args, actionType);
    }

    private String doReplacement(String originalString, String replacement, Matcher matcher, boolean replaceAll) {
        StringBuilder sb = new StringBuilder();
        int previousIndex = 0;
        while (matcher.find()) {
            sb.append(originalString, previousIndex, matcher.start());
            String localReplacement = replacement;
            if (replacement.contains("$")) {
                localReplacement = this.computeReplacementValue(replacement, originalString, matcher);
            }
            sb.append(localReplacement);
            previousIndex = matcher.end();
            this.setProperties(matcher, originalString, matcher.start(), previousIndex);
            if (replaceAll) continue;
            break;
        }
        sb.append(originalString, previousIndex, originalString.length());
        return sb.toString();
    }

    String computeReplacementValue(String replacement, String originalString, Matcher matcher) {
        int i;
        int lastIndex = 0;
        StringBuilder result = new StringBuilder();
        while ((i = replacement.indexOf(36, lastIndex)) > -1) {
            if (i > 0) {
                result.append(replacement, lastIndex, i);
            }
            String ss = null;
            if (i < replacement.length() - 1 && (i == lastIndex || replacement.charAt(i - 1) != '$')) {
                char next = replacement.charAt(i + 1);
                if (next >= '1' && next <= '9') {
                    int num1digit = next - 48;
                    int next2 = i + 2 < replacement.length() ? (int)replacement.charAt(i + 2) : 120;
                    int num2digits = next2 >= 49 && next2 <= 57 ? num1digit * 10 + (next2 - 48) : Integer.MAX_VALUE;
                    if (num2digits <= matcher.groupCount()) {
                        ss = matcher.group(num2digits);
                        ++i;
                    } else if (num1digit <= matcher.groupCount()) {
                        ss = StringUtils.defaultString(matcher.group(num1digit));
                    }
                } else {
                    switch (next) {
                        case '&': {
                            ss = matcher.group();
                            break;
                        }
                        case '0': {
                            if (!this.browserVersion_.hasFeature(BrowserVersionFeatures.JS_REGEXP_GROUP0_RETURNS_WHOLE_MATCH)) break;
                            ss = matcher.group();
                            break;
                        }
                        case '`': {
                            ss = originalString.substring(0, matcher.start());
                            break;
                        }
                        case '\'': {
                            ss = originalString.substring(matcher.end());
                            break;
                        }
                        case '$': {
                            ss = "$";
                            break;
                        }
                    }
                }
            }
            if (ss == null) {
                result.append('$');
                lastIndex = i + 1;
                continue;
            }
            result.append(ss);
            lastIndex = i + 2;
        }
        result.append(replacement, lastIndex, replacement.length());
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object wrappedAction(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, int actionType) {
        try {
            ScriptRuntime.setRegExpProxy(cx, this.wrapped_);
            Object object = this.wrapped_.action(cx, scope, thisObj, args, actionType);
            return object;
        }
        finally {
            ScriptRuntime.setRegExpProxy(cx, this);
        }
    }

    private void setProperties(Matcher matcher, String thisString, int startPos, int endPos) {
        String match = matcher.group();
        this.lastMatch = match == null ? SubString.emptySubString : new FixedSubString(match);
        int groupCount = matcher.groupCount();
        if (groupCount == 0) {
            this.parens = null;
        } else {
            int count = Math.min(9, groupCount);
            this.parens = new SubString[count];
            for (int i = 0; i < count; ++i) {
                String group = matcher.group(i + 1);
                this.parens[i] = group == null ? SubString.emptySubString : new FixedSubString(group);
            }
        }
        if (groupCount > 0) {
            String last;
            this.lastParen = groupCount > 9 && this.browserVersion_.hasFeature(BrowserVersionFeatures.JS_REGEXP_EMPTY_LASTPAREN_IF_TOO_MANY_GROUPS) ? SubString.emptySubString : ((last = matcher.group(groupCount)) == null ? SubString.emptySubString : new FixedSubString(last));
        }
        this.leftContext = startPos > 0 ? new SubString(thisString, 0, startPos) : SubString.emptySubString;
        int length = thisString.length();
        this.rightContext = endPos < length ? new SubString(thisString, endPos, length - endPos) : SubString.emptySubString;
    }

    @Override
    public Object compileRegExp(Context cx, String source, String flags) {
        try {
            return this.wrapped_.compileRegExp(cx, source, flags);
        }
        catch (Exception e) {
            LOG.warn("compileRegExp() threw for >" + source + "<, flags: >" + flags + "<. " + "Replacing with a '####shouldNotFindAnything###'");
            return this.wrapped_.compileRegExp(cx, "####shouldNotFindAnything###", "");
        }
    }

    @Override
    public int find_split(Context cx, Scriptable scope, String target, String separator, Scriptable re, int[] ip, int[] matchlen, boolean[] matched, String[][] parensp) {
        return this.wrapped_.find_split(cx, scope, target, separator, re, ip, matchlen, matched, parensp);
    }

    @Override
    public boolean isRegExp(Scriptable obj) {
        return this.wrapped_.isRegExp(obj);
    }

    @Override
    public Scriptable wrapRegExp(Context cx, Scriptable scope, Object compiled) {
        return this.wrapped_.wrapRegExp(cx, scope, compiled);
    }

    static String jsRegExpToJavaRegExp(String re) {
        RegExpJsToJavaConverter regExpJsToJavaFSM = new RegExpJsToJavaConverter();
        return regExpJsToJavaFSM.convert(re);
    }

    private static class FixedSubString
    extends SubString {
        private String value_;

        public FixedSubString(String str) {
            this.value_ = str;
        }

        @Override
        public String toString() {
            return this.value_;
        }
    }

    private static class RegExpData {
        private final String jsSource_;
        private final String jsFlags_;

        RegExpData(NativeRegExp re) {
            String str = re.toString();
            this.jsSource_ = StringUtils.substringBeforeLast(str.substring(1), "/");
            this.jsFlags_ = StringUtils.substringAfterLast(str, "/");
        }

        public RegExpData(String string) {
            this.jsSource_ = string;
            this.jsFlags_ = "";
        }

        public int getJavaFlags() {
            int flags = 0;
            if (this.jsFlags_.contains("i")) {
                flags |= 2;
            }
            if (this.jsFlags_.contains("m")) {
                flags |= 8;
            }
            return flags;
        }

        public String getJavaPattern() {
            return HtmlUnitRegExpProxy.jsRegExpToJavaRegExp(this.jsSource_);
        }

        boolean hasFlag(char c) {
            return this.jsFlags_.indexOf(c) != -1;
        }
    }
}

