/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.css;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.html.BaseFrameElement;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlCheckBoxInput;
import com.gargoylesoftware.htmlunit.html.HtmlDivision;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlFileInput;
import com.gargoylesoftware.htmlunit.html.HtmlHiddenInput;
import com.gargoylesoftware.htmlunit.html.HtmlInlineFrame;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlPasswordInput;
import com.gargoylesoftware.htmlunit.html.HtmlRadioButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlResetInput;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.html.HtmlSubmitInput;
import com.gargoylesoftware.htmlunit.html.HtmlTableRow;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.html.HtmlTextInput;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSS2Properties;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.css.SelectorSpecificity;
import com.gargoylesoftware.htmlunit.javascript.host.css.StyleAttributes;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Text;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLBodyElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCanvasElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import org.apache.commons.lang3.StringUtils;
import org.w3c.css.sac.Selector;

@JsxClass(isJSObject=false, isDefinedInStandardsMode=false, browsers={@WebBrowser(value=BrowserName.FF)})
public class ComputedCSSStyleDeclaration
extends CSSStyleDeclaration {
    private static final int PIXELS_PER_CHAR = 10;
    private static final Set<String> INHERITABLE_ATTRIBUTES = new HashSet<String>(Arrays.asList("azimuth", "border-collapse", "border-spacing", "caption-side", "color", "cursor", "direction", "elevation", "empty-cells", "font-family", "font-size", "font-style", "font-variant", "font-weight", "font", "letter-spacing", "line-height", "list-style-image", "list-style-position", "list-style-type", "list-style", "orphans", "pitch-range", "pitch", "quotes", "richness", "speak-header", "speak-numeral", "speak-punctuation", "speak", "speech-rate", "stress", "text-align", "text-indent", "text-transform", "visibility", "voice-fFamily", "volume", "white-space", "widows", "word-spacing"));
    private final SortedMap<String, CSSStyleDeclaration.StyleElement> localModifications_ = new TreeMap<String, CSSStyleDeclaration.StyleElement>();
    private Integer width_;
    private Integer height_;
    private Integer height2_;
    private Integer paddingHorizontal_;
    private Integer paddingVertical_;
    private Integer borderHorizontal_;
    private Integer borderVertical_;
    private Integer top_;

    public ComputedCSSStyleDeclaration() {
    }

    public ComputedCSSStyleDeclaration(CSSStyleDeclaration style) {
        super(style.getElement());
        this.getElement().setDefaults(this);
    }

    @Override
    protected String getStyleAttribute(String name) {
        Element parent;
        String s = super.getStyleAttribute(name);
        if (s.isEmpty() && this.isInheritable(name) && (parent = this.getElement().getParentElement()) != null) {
            s = this.getWindow().getComputedStyle(parent, null).getStyleAttribute(name);
        }
        return s;
    }

    private boolean isInheritable(String name) {
        return INHERITABLE_ATTRIBUTES.contains(name);
    }

    @Override
    protected void setStyleAttribute(String name, String newValue) {
    }

    public void applyStyleFromSelector(org.w3c.dom.css.CSSStyleDeclaration declaration, Selector selector) {
        SelectorSpecificity specificity = new SelectorSpecificity(selector);
        for (int k = 0; k < declaration.getLength(); ++k) {
            String name = declaration.item(k);
            String value = declaration.getPropertyValue(name);
            String priority = declaration.getPropertyPriority(name);
            this.applyLocalStyleAttribute(name, value, priority, specificity);
        }
    }

    private void applyLocalStyleAttribute(String name, String newValue, String priority, SelectorSpecificity specificity) {
        CSSStyleDeclaration.StyleElement existingElement;
        if (!"important".equals(priority) && (existingElement = (CSSStyleDeclaration.StyleElement)this.localModifications_.get(name)) != null) {
            if ("important".equals(existingElement.getPriority())) {
                return;
            }
            if (specificity.compareTo(existingElement.getSpecificity()) < 0) {
                return;
            }
        }
        CSSStyleDeclaration.StyleElement element = new CSSStyleDeclaration.StyleElement(name, newValue, priority, specificity, this.getCurrentElementIndex());
        this.localModifications_.put(name, element);
    }

    public void setDefaultLocalStyleAttribute(String name, String newValue) {
        CSSStyleDeclaration.StyleElement element = new CSSStyleDeclaration.StyleElement(name, newValue);
        this.localModifications_.put(name, element);
    }

    @Override
    protected CSSStyleDeclaration.StyleElement getStyleElement(String name) {
        CSSStyleDeclaration.StyleElement existent = super.getStyleElement(name);
        if (this.localModifications_ != null) {
            CSSStyleDeclaration.StyleElement localStyleMod = (CSSStyleDeclaration.StyleElement)this.localModifications_.get(name);
            if (localStyleMod == null) {
                return existent;
            }
            if (existent == null) {
                return localStyleMod;
            }
            if ("important".equals(localStyleMod.getPriority())) {
                if ("important".equals(existent.getPriority())) {
                    if (existent.getSpecificity().compareTo(localStyleMod.getSpecificity()) < 0) {
                        return localStyleMod;
                    }
                } else {
                    return localStyleMod;
                }
            }
        }
        return existent;
    }

    private String defaultIfEmpty(String str, StyleAttributes.Definition definition) {
        return this.defaultIfEmpty(str, definition, false);
    }

    private String defaultIfEmpty(String str, StyleAttributes.Definition definition, boolean isPixel) {
        if (str == null || str.isEmpty()) {
            return definition.getDefaultComputedValue(this.getBrowserVersion());
        }
        if (isPixel) {
            return this.pixelString(str);
        }
        return str;
    }

    private String defaultIfEmpty(String str, String defaultStr) {
        if (str == null || str.isEmpty()) {
            return defaultStr;
        }
        return str;
    }

    @Override
    public String getAccelerator() {
        return this.defaultIfEmpty(this.getStyleAttribute("accelerator"), StyleAttributes.Definition.ACCELERATOR);
    }

    @Override
    public String getBackground() {
        return this.defaultIfEmpty(super.getBackground(), StyleAttributes.Definition.BACKGROUND);
    }

    @Override
    public String getBackgroundAttachment() {
        return this.defaultIfEmpty(super.getBackgroundAttachment(), StyleAttributes.Definition.BACKGROUND_ATTACHMENT);
    }

    @Override
    public String getBackgroundColor() {
        String value = super.getBackgroundColor();
        if (StringUtils.isEmpty(value)) {
            value = StyleAttributes.Definition.BACKGROUND_COLOR.getDefaultComputedValue(this.getBrowserVersion());
        } else if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_GET_BACKGROUND_COLOR_FOR_COMPUTED_STYLE_AS_RGB)) {
            value = ComputedCSSStyleDeclaration.toRGBColor(value);
        }
        return value;
    }

    @Override
    public String getBackgroundImage() {
        return this.defaultIfEmpty(super.getBackgroundImage(), StyleAttributes.Definition.BACKGROUND_IMAGE);
    }

    @Override
    public String getBackgroundPosition() {
        return this.defaultIfEmpty(super.getBackgroundPosition(), StyleAttributes.Definition.BACKGROUND_POSITION);
    }

    @Override
    public String getBackgroundPositionX() {
        return this.defaultIfEmpty(super.getBackgroundPositionX(), StyleAttributes.Definition.BACKGROUND_POSITION_X);
    }

    @Override
    public String getBackgroundPositionY() {
        return this.defaultIfEmpty(super.getBackgroundPositionY(), StyleAttributes.Definition.BACKGROUND_POSITION_Y);
    }

    @Override
    public String getBackgroundRepeat() {
        return this.defaultIfEmpty(super.getBackgroundRepeat(), StyleAttributes.Definition.BACKGROUND_REPEAT);
    }

    @Override
    public String getBorder() {
        return this.defaultIfEmpty(super.getBorderBottomColor(), StyleAttributes.Definition.BORDER);
    }

    @Override
    public String getBorderBottom() {
        return this.defaultIfEmpty(super.getBorderBottom(), StyleAttributes.Definition.BORDER_BOTTOM);
    }

    @Override
    public String getBorderColor() {
        return this.defaultIfEmpty(super.getBorderColor(), StyleAttributes.Definition.BORDER_COLOR);
    }

    @Override
    public String getBorderBottomColor() {
        return this.defaultIfEmpty(super.getBorderBottomColor(), StyleAttributes.Definition.BORDER_BOTTOM_COLOR);
    }

    @Override
    public String getBorderBottomStyle() {
        return this.defaultIfEmpty(super.getBorderBottomStyle(), StyleAttributes.Definition.BORDER_BOTTOM_STYLE);
    }

    @Override
    public String getBorderBottomWidth() {
        return this.pixelString(this.defaultIfEmpty(super.getBorderBottomWidth(), StyleAttributes.Definition.BORDER_BOTTOM_WIDTH));
    }

    @Override
    public String getBorderCollapse() {
        return this.defaultIfEmpty(super.getBorderCollapse(), StyleAttributes.Definition.BORDER_COLLAPSE);
    }

    @Override
    public String getBorderLeft() {
        return this.defaultIfEmpty(super.getBorderLeft(), StyleAttributes.Definition.BORDER_LEFT);
    }

    @Override
    public String getBorderLeftColor() {
        return this.defaultIfEmpty(super.getBorderLeftColor(), StyleAttributes.Definition.BORDER_LEFT_COLOR);
    }

    @Override
    public String getBorderLeftStyle() {
        return this.defaultIfEmpty(super.getBorderLeftStyle(), StyleAttributes.Definition.BORDER_LEFT_STYLE);
    }

    @Override
    public String getBorderLeftWidth() {
        return this.pixelString(this.defaultIfEmpty(super.getBorderLeftWidth(), "0px"));
    }

    @Override
    public String getBorderRight() {
        return this.defaultIfEmpty(super.getBorderRight(), StyleAttributes.Definition.BORDER_RIGHT);
    }

    @Override
    public String getBorderRightColor() {
        return this.defaultIfEmpty(super.getBorderRightColor(), "rgb(0, 0, 0)");
    }

    @Override
    public String getBorderRightStyle() {
        return this.defaultIfEmpty(super.getBorderRightStyle(), "none");
    }

    @Override
    public String getBorderRightWidth() {
        return this.pixelString(this.defaultIfEmpty(super.getBorderRightWidth(), "0px"));
    }

    @Override
    public String getBorderSpacing() {
        return this.defaultIfEmpty(super.getBorderSpacing(), "0px 0px");
    }

    @Override
    public String getBorderStyle() {
        return this.defaultIfEmpty(super.getBorderStyle(), StyleAttributes.Definition.BORDER_STYLE);
    }

    @Override
    public String getBorderTop() {
        return this.defaultIfEmpty(super.getBorderTop(), StyleAttributes.Definition.BORDER_TOP);
    }

    @Override
    public String getBorderTopColor() {
        return this.defaultIfEmpty(super.getBorderTopColor(), "rgb(0, 0, 0)");
    }

    @Override
    public String getBorderTopStyle() {
        return this.defaultIfEmpty(super.getBorderTopStyle(), "none");
    }

    @Override
    public String getBorderTopWidth() {
        return this.pixelString(this.defaultIfEmpty(super.getBorderTopWidth(), "0px"));
    }

    @Override
    public String getBorderWidth() {
        return this.defaultIfEmpty(super.getBorderWidth(), StyleAttributes.Definition.BORDER_WIDTH);
    }

    @Override
    public String getBottom() {
        return this.defaultIfEmpty(super.getBottom(), "auto");
    }

    @Override
    public String getBoxSizing() {
        return this.defaultIfEmpty(super.getBoxSizing(), StyleAttributes.Definition.BOX_SIZING);
    }

    @Override
    public String getCaptionSide() {
        return this.defaultIfEmpty(super.getCaptionSide(), "top");
    }

    @Override
    public String getClear() {
        return this.defaultIfEmpty(super.getClear(), "none");
    }

    @Override
    public String getClip() {
        return this.defaultIfEmpty(super.getClip(), "auto");
    }

    @Override
    public String getContent() {
        return this.defaultIfEmpty(super.getContent(), StyleAttributes.Definition.CONTENT);
    }

    @Override
    public String getColor() {
        String value = this.defaultIfEmpty(super.getColor(), "rgb(0, 0, 0)");
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_GET_BACKGROUND_COLOR_FOR_COMPUTED_STYLE_AS_RGB)) {
            value = ComputedCSSStyleDeclaration.toRGBColor(value);
        }
        return value;
    }

    @Override
    public String getCounterIncrement() {
        return this.defaultIfEmpty(super.getCounterIncrement(), "none");
    }

    @Override
    public String getCounterReset() {
        return this.defaultIfEmpty(super.getCounterReset(), "none");
    }

    @Override
    public String getCssFloat() {
        return this.defaultIfEmpty(super.getCssFloat(), StyleAttributes.Definition.CSS_FLOAT);
    }

    @Override
    public String getCursor() {
        return this.defaultIfEmpty(super.getCursor(), "auto");
    }

    @Override
    public String getDirection() {
        return this.defaultIfEmpty(super.getDirection(), "ltr");
    }

    @Override
    public String getDisplay() {
        String value = super.getDisplay();
        if (StringUtils.isEmpty(value)) {
            Element elem = this.getElement();
            if (elem instanceof HTMLElement) {
                return ((HTMLElement)elem).getDefaultStyleDisplay();
            }
            return "";
        }
        return value;
    }

    @Override
    public String getEmptyCells() {
        return this.defaultIfEmpty(super.getEmptyCells(), StyleAttributes.Definition.EMPTY_CELLS);
    }

    @Override
    public String getFont() {
        return this.defaultIfEmpty(super.getFont(), StyleAttributes.Definition.FONT);
    }

    @Override
    public String getFontFamily() {
        return this.defaultIfEmpty(super.getFontFamily(), StyleAttributes.Definition.FONT_FAMILY);
    }

    @Override
    public String getFontSize() {
        Element parent;
        String value = super.getFontSize();
        if (value.isEmpty() && (parent = this.getElement().getParentElement()) != null) {
            CSS2Properties style = parent.getWindow().getComputedStyle(parent, null);
            value = style.getFontSize();
        }
        if (value.isEmpty()) {
            value = "16px";
        }
        return value;
    }

    @Override
    public String getFontSizeAdjust() {
        return this.defaultIfEmpty(super.getFontSizeAdjust(), "none");
    }

    @Override
    public String getFontStretch() {
        String defaultStretch = "";
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_FONT_STRECH_DEFAULT_NORMAL)) {
            defaultStretch = "normal";
        }
        return this.defaultIfEmpty(super.getFontStretch(), defaultStretch);
    }

    @Override
    public String getFontStyle() {
        return this.defaultIfEmpty(super.getFontStyle(), "normal");
    }

    @Override
    public String getFontVariant() {
        return this.defaultIfEmpty(super.getFontVariant(), "normal");
    }

    @Override
    public String getFontWeight() {
        return this.defaultIfEmpty(super.getFontWeight(), StyleAttributes.Definition.FONT_WEIGHT);
    }

    @Override
    public String getHeight() {
        Element elem = this.getElement();
        if (!elem.getDomNodeOrDie().isDirectlyAttachedToPage()) {
            return "auto";
        }
        int windowHeight = elem.getWindow().getWebWindow().getInnerHeight();
        return this.pixelString(elem, new CSSStyleDeclaration.CssValue(windowHeight){

            @Override
            public String get(ComputedCSSStyleDeclaration style) {
                return ComputedCSSStyleDeclaration.this.defaultIfEmpty(style.getStyleAttribute("height"), "362px");
            }
        });
    }

    @Override
    public String getImeMode() {
        return this.defaultIfEmpty(super.getImeMode(), StyleAttributes.Definition.IME_MODE);
    }

    @Override
    public String getLayoutFlow() {
        return this.defaultIfEmpty(super.getLayoutFlow(), StyleAttributes.Definition.LAYOUT_FLOW);
    }

    @Override
    public String getLayoutGrid() {
        return this.defaultIfEmpty(super.getLayoutGrid(), StyleAttributes.Definition.LAYOUT_GRID);
    }

    @Override
    public String getLayoutGridChar() {
        return this.defaultIfEmpty(super.getLayoutGridChar(), StyleAttributes.Definition.LAYOUT_GRID_CHAR);
    }

    @Override
    public String getLayoutGridLine() {
        return this.defaultIfEmpty(super.getLayoutGridLine(), StyleAttributes.Definition.LAYOUT_GRID_LINE);
    }

    @Override
    public String getLayoutGridMode() {
        return this.defaultIfEmpty(super.getLayoutGridMode(), StyleAttributes.Definition.LAYOUT_GRID_MODE);
    }

    @Override
    public String getLayoutGridType() {
        return this.defaultIfEmpty(super.getLayoutGridType(), StyleAttributes.Definition.LAYOUT_GRID_TYPE);
    }

    @Override
    public String getLeft() {
        return this.defaultIfEmpty(super.getLeft(), "auto");
    }

    @Override
    public String getLetterSpacing() {
        return this.defaultIfEmpty(super.getLetterSpacing(), "normal");
    }

    @Override
    public String getLineBreak() {
        return this.defaultIfEmpty(super.getLineBreak(), StyleAttributes.Definition.LINE_BREAK);
    }

    @Override
    public String getListStyle() {
        return this.defaultIfEmpty(super.getListStyle(), StyleAttributes.Definition.LIST_STYLE);
    }

    @Override
    public String getListStyleImage() {
        return this.defaultIfEmpty(super.getListStyleImage(), "none");
    }

    @Override
    public String getListStylePosition() {
        return this.defaultIfEmpty(super.getListStylePosition(), "outside");
    }

    @Override
    public String getListStyleType() {
        return this.defaultIfEmpty(super.getListStyleType(), "disc");
    }

    @Override
    public String getMargin() {
        return this.defaultIfEmpty(super.getMargin(), StyleAttributes.Definition.MARGIN, true);
    }

    @Override
    public String getMarginBottom() {
        return this.pixelString(this.defaultIfEmpty(super.getMarginBottom(), "0px"));
    }

    @Override
    public String getMarginLeft() {
        return this.pixelString(this.defaultIfEmpty(super.getMarginLeft(), "0px"));
    }

    @Override
    public String getMarginRight() {
        return this.pixelString(this.defaultIfEmpty(super.getMarginRight(), "0px"));
    }

    @Override
    public String getMarginTop() {
        return this.pixelString(this.defaultIfEmpty(super.getMarginTop(), "0px"));
    }

    @Override
    public String getMarkerOffset() {
        return this.defaultIfEmpty(super.getMarkerOffset(), "auto");
    }

    @Override
    public String getMaxHeight() {
        return this.defaultIfEmpty(super.getMaxHeight(), "none");
    }

    @Override
    public String getMaxWidth() {
        return this.defaultIfEmpty(super.getMaxWidth(), "none");
    }

    @Override
    public String getMinHeight() {
        return this.defaultIfEmpty(super.getMinHeight(), "0px");
    }

    @Override
    public String getMinWidth() {
        return this.defaultIfEmpty(super.getMinWidth(), "0px");
    }

    @Override
    public String getMsBlockProgression() {
        return this.defaultIfEmpty(super.getMsBlockProgression(), StyleAttributes.Definition.MS_BLOCK_PROGRESSION);
    }

    @Override
    public String getMsContentZoomChaining() {
        return this.defaultIfEmpty(super.getMsContentZoomChaining(), StyleAttributes.Definition.MS_CONTENT_ZOOM_CHAINING);
    }

    @Override
    public String getMsContentZoomLimit() {
        return this.defaultIfEmpty(super.getMsContentZoomLimit(), StyleAttributes.Definition.MS_CONTENT_ZOOM_LIMIT);
    }

    @Override
    public String getMsContentZoomLimitMax() {
        return this.defaultIfEmpty(super.getMsContentZoomLimitMax(), StyleAttributes.Definition.MS_CONTENT_ZOOM_LIMIT_MAX);
    }

    @Override
    public String getMsContentZoomLimitMin() {
        return this.defaultIfEmpty(super.getMsContentZoomLimitMin(), StyleAttributes.Definition.MS_CONTENT_ZOOM_LIMIT_MIN);
    }

    @Override
    public String getMsContentZoomSnap() {
        return this.defaultIfEmpty(super.getMsContentZoomSnap(), StyleAttributes.Definition.MS_CONTENT_ZOOM_SNAP);
    }

    @Override
    public String getMsContentZoomSnapPoints() {
        return this.defaultIfEmpty(super.getMsContentZoomSnapPoints(), StyleAttributes.Definition.MS_CONTENT_ZOOM_SNAP_POINTS);
    }

    @Override
    public String getMsContentZoomSnapType() {
        return this.defaultIfEmpty(super.getMsContentZoomSnapType(), StyleAttributes.Definition.MS_CONTENT_ZOOM_SNAP_TYPE);
    }

    @Override
    public String getMsContentZooming() {
        return this.defaultIfEmpty(super.getMsContentZooming(), StyleAttributes.Definition.MS_CONTENT_ZOOMING);
    }

    @Override
    public String getMsFlex() {
        return this.defaultIfEmpty(super.getMsFlex(), StyleAttributes.Definition.MS_FLEX);
    }

    @Override
    public String getMsFlexAlign() {
        return this.defaultIfEmpty(super.getMsFlexAlign(), StyleAttributes.Definition.MS_FLEX_ALIGN);
    }

    @Override
    public String getMsFlexDirection() {
        return this.defaultIfEmpty(super.getMsFlexDirection(), StyleAttributes.Definition.MS_FLEX_DIRECTION);
    }

    @Override
    public String getMsFlexFlow() {
        return this.defaultIfEmpty(super.getMsFlexFlow(), StyleAttributes.Definition.MS_FLEX_FLOW);
    }

    @Override
    public String getMsFlexItemAlign() {
        return this.defaultIfEmpty(super.getMsFlexItemAlign(), StyleAttributes.Definition.MS_FLEX_ITEM_ALIGN);
    }

    @Override
    public String getMsFlexLinePack() {
        return this.defaultIfEmpty(super.getMsFlexLinePack(), StyleAttributes.Definition.MS_FLEX_LINE_PACK);
    }

    @Override
    public String getMsFlexNegative() {
        return this.defaultIfEmpty(super.getMsFlexNegative(), StyleAttributes.Definition.MS_FLEX_NEGATIVE);
    }

    @Override
    public String getMsFlexOrder() {
        return this.defaultIfEmpty(super.getMsFlexOrder(), StyleAttributes.Definition.MS_FLEX_ORDER);
    }

    @Override
    public String getMsFlexPack() {
        return this.defaultIfEmpty(super.getMsFlexPack(), StyleAttributes.Definition.MS_FLEX_PACK);
    }

    @Override
    public String getMsFlexPositive() {
        return this.defaultIfEmpty(super.getMsFlexPositive(), StyleAttributes.Definition.MS_FLEX_POSITIVE);
    }

    @Override
    public String getMsFlexPreferredSize() {
        return this.defaultIfEmpty(super.getMsFlexPreferredSize(), StyleAttributes.Definition.MS_FLEX_PREFERRED_SIZE);
    }

    @Override
    public String getMsFlexWrap() {
        return this.defaultIfEmpty(super.getMsFlexWrap(), StyleAttributes.Definition.MS_FLEX_WRAP);
    }

    @Override
    public String getMsFlowFrom() {
        return this.defaultIfEmpty(super.getMsFlowFrom(), StyleAttributes.Definition.MS_FLOW_FROM);
    }

    @Override
    public String getMsFlowInto() {
        return this.defaultIfEmpty(super.getMsFlowInto(), StyleAttributes.Definition.MS_FLOW_INTO);
    }

    @Override
    public String getMsFontFeatureSettings() {
        return this.defaultIfEmpty(super.getMsFontFeatureSettings(), StyleAttributes.Definition.MS_FONT_FEATURE_SETTINGS);
    }

    @Override
    public String getMsGridColumn() {
        return this.defaultIfEmpty(super.getMsGridColumn(), StyleAttributes.Definition.MS_GRID_COLUMN);
    }

    @Override
    public String getMsGridColumnAlign() {
        return this.defaultIfEmpty(super.getMsGridColumnAlign(), StyleAttributes.Definition.MS_GRID_COLUMN_ALIGN);
    }

    @Override
    public String getMsGridColumnSpan() {
        return this.defaultIfEmpty(super.getMsGridColumnSpan(), StyleAttributes.Definition.MS_GRID_COLUMN_SPAN);
    }

    @Override
    public String getMsGridColumns() {
        return this.defaultIfEmpty(super.getMsGridColumns(), StyleAttributes.Definition.MS_GRID_COLUMNS);
    }

    @Override
    public String getMsGridRow() {
        return this.defaultIfEmpty(super.getMsGridRow(), StyleAttributes.Definition.MS_GRID_ROW);
    }

    @Override
    public String getMsGridRowAlign() {
        return this.defaultIfEmpty(super.getMsGridRowAlign(), StyleAttributes.Definition.MS_GRID_ROW_ALIGN);
    }

    @Override
    public String getMsGridRowSpan() {
        return this.defaultIfEmpty(super.getMsGridRowSpan(), StyleAttributes.Definition.MS_GRID_ROW_SPAN);
    }

    @Override
    public String getMsGridRows() {
        return this.defaultIfEmpty(super.getMsGridRows(), StyleAttributes.Definition.MS_GRID_ROWS);
    }

    @Override
    public String getMsHighContrastAdjust() {
        return this.defaultIfEmpty(super.getMsHighContrastAdjust(), StyleAttributes.Definition.MS_HIGH_CONTRAST_ADJUST);
    }

    @Override
    public String getMsHyphenateLimitChars() {
        return this.defaultIfEmpty(super.getMsHyphenateLimitChars(), StyleAttributes.Definition.MS_HYPHENATE_LIMIT_CHARS);
    }

    @Override
    public String getMsHyphenateLimitLines() {
        return this.defaultIfEmpty(super.getMsHyphenateLimitLines(), StyleAttributes.Definition.MS_HYPHENATE_LIMIT_LINES);
    }

    @Override
    public String getMsHyphenateLimitZone() {
        return this.defaultIfEmpty(super.getMsHyphenateLimitZone(), StyleAttributes.Definition.MS_HYPHENATE_LIMIT_ZONE);
    }

    @Override
    public String getMsHyphens() {
        return this.defaultIfEmpty(super.getMsHyphens(), StyleAttributes.Definition.MS_HYPHENS);
    }

    @Override
    public String getMsImeAlign() {
        return this.defaultIfEmpty(super.getMsImeAlign(), StyleAttributes.Definition.MS_IME_ALIGN);
    }

    @Override
    public String getMsInterpolationMode() {
        return this.defaultIfEmpty(super.getMsInterpolationMode(), StyleAttributes.Definition.MS_INTERPOLATION_MODE);
    }

    @Override
    public String getMsOverflowStyle() {
        return this.defaultIfEmpty(super.getMsOverflowStyle(), StyleAttributes.Definition.MS_OVERFLOW_STYLE);
    }

    @Override
    public String getMsPerspective() {
        return this.defaultIfEmpty(super.getMsPerspective(), StyleAttributes.Definition.MS_PERSPECTIVE);
    }

    @Override
    public String getMsPerspectiveOrigin() {
        return this.defaultIfEmpty(super.getMsPerspectiveOrigin(), StyleAttributes.Definition.MS_PERSPECTIVE_ORIGIN);
    }

    @Override
    public String getMsScrollChaining() {
        return this.defaultIfEmpty(super.getMsScrollChaining(), StyleAttributes.Definition.MS_SCROLL_CHAINING);
    }

    @Override
    public String getMsScrollLimit() {
        return this.defaultIfEmpty(super.getMsScrollLimit(), StyleAttributes.Definition.MS_SCROLL_LIMIT);
    }

    @Override
    public String getMsScrollLimitXMax() {
        return this.defaultIfEmpty(super.getMsScrollLimitXMax(), StyleAttributes.Definition.MS_SCROLL_LIMIT_X_MAX);
    }

    @Override
    public String getMsScrollLimitXMin() {
        return this.defaultIfEmpty(super.getMsScrollLimitXMin(), StyleAttributes.Definition.MS_SCROLL_LIMIT_X_MIN);
    }

    @Override
    public String getMsScrollLimitYMax() {
        return this.defaultIfEmpty(super.getMsScrollLimitYMax(), StyleAttributes.Definition.MS_SCROLL_LIMIT_Y_MAX);
    }

    @Override
    public String getMsScrollLimitYMin() {
        return this.defaultIfEmpty(super.getMsScrollLimitYMin(), StyleAttributes.Definition.MS_SCROLL_LIMIT_Y_MIN);
    }

    @Override
    public String getMsScrollRails() {
        return this.defaultIfEmpty(super.getMsScrollRails(), StyleAttributes.Definition.MS_SCROLL_RAILS);
    }

    @Override
    public String getMsScrollSnapPointsX() {
        return this.defaultIfEmpty(super.getMsScrollSnapPointsX(), StyleAttributes.Definition.MS_SCROLL_SNAP_POINTS_X);
    }

    @Override
    public String getMsScrollSnapPointsY() {
        return this.defaultIfEmpty(super.getMsScrollSnapPointsY(), StyleAttributes.Definition.MS_SCROLL_SNAP_POINTS_Y);
    }

    @Override
    public String getMsScrollSnapType() {
        return this.defaultIfEmpty(super.getMsScrollSnapType(), StyleAttributes.Definition.MS_SCROLL_SNAP_TYPE);
    }

    @Override
    public String getMsScrollSnapX() {
        return this.defaultIfEmpty(super.getMsScrollSnapX(), StyleAttributes.Definition.MS_SCROLL_SNAP_X);
    }

    @Override
    public String getMsScrollSnapY() {
        return this.defaultIfEmpty(super.getMsScrollSnapY(), StyleAttributes.Definition.MS_SCROLL_SNAP_Y);
    }

    @Override
    public String getMsScrollTranslation() {
        return this.defaultIfEmpty(super.getMsScrollTranslation(), StyleAttributes.Definition.MS_SCROLL_TRANSLATION);
    }

    @Override
    public String getMsTextCombineHorizontal() {
        return this.defaultIfEmpty(super.getMsTextCombineHorizontal(), StyleAttributes.Definition.MS_TEXT_COMBINE_HORIZONTAL);
    }

    @Override
    public String getMsTouchAction() {
        return this.defaultIfEmpty(super.getMsTouchAction(), StyleAttributes.Definition.MS_TOUCH_ACTION);
    }

    @Override
    public String getMsTouchSelect() {
        return this.defaultIfEmpty(super.getMsTouchSelect(), StyleAttributes.Definition.MS_TOUCH_SELECT);
    }

    @Override
    public String getMsTransform() {
        return this.defaultIfEmpty(super.getMsTransform(), StyleAttributes.Definition.MS_TRANSFORM);
    }

    @Override
    public String getMsTransformOrigin() {
        return this.defaultIfEmpty(super.getMsTransformOrigin(), StyleAttributes.Definition.MS_TRANSFORM_ORIGIN);
    }

    @Override
    public String getMsTransformStyle() {
        return this.defaultIfEmpty(super.getMsTransformStyle(), StyleAttributes.Definition.MS_TRANSFORM_STYLE);
    }

    @Override
    public String getMsTransition() {
        return this.defaultIfEmpty(super.getMsTransition(), StyleAttributes.Definition.MS_TRANSITION);
    }

    @Override
    public String getMsTransitionDelay() {
        return this.defaultIfEmpty(super.getMsTransitionDelay(), StyleAttributes.Definition.MS_TRANSITION_DELAY);
    }

    @Override
    public String getMsTransitionDuration() {
        return this.defaultIfEmpty(super.getMsTransitionDuration(), StyleAttributes.Definition.MS_TRANSITION_DURATION);
    }

    @Override
    public String getMsTransitionProperty() {
        return this.defaultIfEmpty(super.getMsTransitionProperty(), StyleAttributes.Definition.MS_TRANSITION_PROPERTY);
    }

    @Override
    public String getMsTransitionTimingFunction() {
        return this.defaultIfEmpty(super.getMsTransitionTimingFunction(), StyleAttributes.Definition.MS_TRANSITION_TIMING_FUNCTION);
    }

    @Override
    public String getMsUserSelect() {
        return this.defaultIfEmpty(super.getMsUserSelect(), StyleAttributes.Definition.MS_USER_SELECT);
    }

    @Override
    public String getMsWrapFlow() {
        return this.defaultIfEmpty(super.getMsWrapFlow(), StyleAttributes.Definition.MS_WRAP_FLOW);
    }

    @Override
    public String getMsWrapMargin() {
        return this.defaultIfEmpty(super.getMsWrapMargin(), StyleAttributes.Definition.MS_WRAP_MARGIN);
    }

    @Override
    public String getMsWrapThrough() {
        return this.defaultIfEmpty(super.getMsWrapThrough(), StyleAttributes.Definition.MS_WRAP_THROUGH);
    }

    @Override
    public String getOpacity() {
        return this.defaultIfEmpty(super.getOpacity(), "1");
    }

    @Override
    public String getOrphans() {
        return this.defaultIfEmpty(super.getOrphans(), StyleAttributes.Definition.ORPHANS);
    }

    @Override
    public String getOutlineColor() {
        return this.defaultIfEmpty(super.getOutlineColor(), StyleAttributes.Definition.OUTLINE_COLOR);
    }

    @Override
    public String getOutlineOffset() {
        return this.defaultIfEmpty(super.getOutlineOffset(), "0px");
    }

    @Override
    public String getOutlineStyle() {
        return this.defaultIfEmpty(super.getOutlineStyle(), "none");
    }

    @Override
    public String getOutlineWidth() {
        return this.defaultIfEmpty(super.getOutlineWidth(), "0px");
    }

    @Override
    public String getOverflow() {
        return this.defaultIfEmpty(super.getOverflow(), "visible");
    }

    @Override
    public String getOverflowX() {
        return this.defaultIfEmpty(super.getOverflowX(), "visible");
    }

    @Override
    public String getOverflowY() {
        return this.defaultIfEmpty(super.getOverflowY(), "visible");
    }

    @Override
    public String getPageBreakAfter() {
        return this.defaultIfEmpty(super.getPageBreakAfter(), "auto");
    }

    @Override
    public String getPageBreakBefore() {
        return this.defaultIfEmpty(super.getPageBreakBefore(), "auto");
    }

    @Override
    public String getPageBreakInside() {
        return this.defaultIfEmpty(super.getPageBreakInside(), StyleAttributes.Definition.PAGE_BREAK_INSIDE);
    }

    @Override
    public String getPadding() {
        return this.defaultIfEmpty(super.getPadding(), StyleAttributes.Definition.PADDING, true);
    }

    @Override
    public String getPaddingBottom() {
        return this.pixelString(this.defaultIfEmpty(super.getPaddingBottom(), "0px"));
    }

    @Override
    public String getPaddingLeft() {
        return this.pixelString(this.defaultIfEmpty(super.getPaddingLeft(), "0px"));
    }

    @Override
    public String getPaddingRight() {
        return this.pixelString(this.defaultIfEmpty(super.getPaddingRight(), "0px"));
    }

    @Override
    public String getPaddingTop() {
        return this.pixelString(this.defaultIfEmpty(super.getPaddingTop(), "0px"));
    }

    @Override
    public String getPointerEvents() {
        return this.defaultIfEmpty(super.getPointerEvents(), StyleAttributes.Definition.POINTER_EVENTS);
    }

    @Override
    public String getPosition() {
        return this.defaultIfEmpty(super.getPosition(), "static");
    }

    @Override
    public String getRight() {
        return this.defaultIfEmpty(super.getRight(), "auto");
    }

    @Override
    public String getScrollbar3dLightColor() {
        return this.defaultIfEmpty(super.getScrollbar3dLightColor(), StyleAttributes.Definition.SCROLLBAR_3DLIGHT_COLOR);
    }

    @Override
    public String getScrollbarArrowColor() {
        return this.defaultIfEmpty(super.getScrollbarArrowColor(), StyleAttributes.Definition.SCROLLBAR_ARROW_COLOR);
    }

    @Override
    public String getScrollbarBaseColor() {
        return this.defaultIfEmpty(super.getScrollbarBaseColor(), StyleAttributes.Definition.SCROLLBAR_BASE_COLOR);
    }

    @Override
    public String getScrollbarDarkShadowColor() {
        return this.defaultIfEmpty(super.getScrollbarDarkShadowColor(), StyleAttributes.Definition.SCROLLBAR_DARKSHADOW_COLOR);
    }

    @Override
    public String getScrollbarFaceColor() {
        return this.defaultIfEmpty(super.getScrollbarFaceColor(), StyleAttributes.Definition.SCROLLBAR_FACE_COLOR);
    }

    @Override
    public String getScrollbarHighlightColor() {
        return this.defaultIfEmpty(super.getScrollbarHighlightColor(), StyleAttributes.Definition.SCROLLBAR_HIGHLIGHT_COLOR);
    }

    @Override
    public String getScrollbarShadowColor() {
        return this.defaultIfEmpty(super.getScrollbarShadowColor(), StyleAttributes.Definition.SCROLLBAR_SHADOW_COLOR);
    }

    @Override
    public String getScrollbarTrackColor() {
        return this.defaultIfEmpty(super.getScrollbarTrackColor(), StyleAttributes.Definition.SCROLLBAR_TRACK_COLOR);
    }

    @Override
    public String getStyleFloat() {
        return this.defaultIfEmpty(super.getStyleFloat(), StyleAttributes.Definition.STYLE_FLOAT);
    }

    @Override
    public String getTableLayout() {
        return this.defaultIfEmpty(super.getTableLayout(), "auto");
    }

    @Override
    public String getTextAlign() {
        return this.defaultIfEmpty(super.getTextAlign(), StyleAttributes.Definition.TEXT_ALIGN);
    }

    @Override
    public String getTextAlignLast() {
        return this.defaultIfEmpty(super.getTextAlignLast(), StyleAttributes.Definition.TEXT_ALIGN_LAST);
    }

    @Override
    public String getTextAutospace() {
        return this.defaultIfEmpty(super.getTextAutospace(), StyleAttributes.Definition.TEXT_AUTOSPACE);
    }

    @Override
    public String getTextDecoration() {
        return this.defaultIfEmpty(super.getTextDecoration(), "none");
    }

    @Override
    public String getTextIndent() {
        return this.defaultIfEmpty(super.getTextIndent(), "0px");
    }

    @Override
    public String getTextJustify() {
        return this.defaultIfEmpty(super.getTextJustify(), StyleAttributes.Definition.TEXT_JUSTIFY);
    }

    @Override
    public String getTextJustifyTrim() {
        return this.defaultIfEmpty(super.getTextJustifyTrim(), StyleAttributes.Definition.TEXT_JUSTIFY_TRIM);
    }

    @Override
    public String getTextKashida() {
        return this.defaultIfEmpty(super.getTextKashida(), StyleAttributes.Definition.TEXT_KASHIDA);
    }

    @Override
    public String getTextKashidaSpace() {
        return this.defaultIfEmpty(super.getTextKashidaSpace(), StyleAttributes.Definition.TEXT_KASHIDA_SPACE);
    }

    @Override
    public String getTextOverflow() {
        return this.defaultIfEmpty(super.getTextOverflow(), StyleAttributes.Definition.TEXT_OVERFLOW);
    }

    @Override
    public String getTextShadow() {
        return this.defaultIfEmpty(super.getTextShadow(), StyleAttributes.Definition.TEXT_SHADOW);
    }

    @Override
    public String getTextTransform() {
        return this.defaultIfEmpty(super.getTextTransform(), "none");
    }

    @Override
    public String getTextUnderlinePosition() {
        return this.defaultIfEmpty(super.getTextUnderlinePosition(), StyleAttributes.Definition.TEXT_UNDERLINE_POSITION);
    }

    @Override
    public String getTop() {
        return this.defaultIfEmpty(super.getTop(), "auto");
    }

    @Override
    public String getVerticalAlign() {
        return this.defaultIfEmpty(super.getVerticalAlign(), "baseline");
    }

    @Override
    public String getVisibility() {
        return this.defaultIfEmpty(super.getVisibility(), "visible");
    }

    @Override
    public String getWhiteSpace() {
        return this.defaultIfEmpty(super.getWhiteSpace(), "normal");
    }

    @Override
    public String getWidows() {
        return this.defaultIfEmpty(super.getWidows(), StyleAttributes.Definition.WIDOWS);
    }

    @Override
    public String getWritingMode() {
        return this.defaultIfEmpty(super.getWritingMode(), StyleAttributes.Definition.WRITING_MODE);
    }

    @Override
    public String getWidth() {
        if ("none".equals(this.getDisplay())) {
            return "auto";
        }
        Element elem = this.getElement();
        if (!elem.getDomNodeOrDie().isDirectlyAttachedToPage()) {
            return "auto";
        }
        int windowWidth = elem.getWindow().getWebWindow().getInnerWidth();
        return this.pixelString(elem, new CSSStyleDeclaration.CssValue(windowWidth){

            @Override
            public String get(ComputedCSSStyleDeclaration style) {
                String value = style.getStyleAttribute("width");
                if (StringUtils.isEmpty(value)) {
                    String content;
                    if (ComputedCSSStyleDeclaration.this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_DEFAULT_WIDTH_AUTO)) {
                        return "auto";
                    }
                    if ("absolute".equals(ComputedCSSStyleDeclaration.this.getStyleAttribute("position")) && null != (content = ComputedCSSStyleDeclaration.this.getDomNodeOrDie().getTextContent()) && content.length() < 13) {
                        return content.length() * 7 + "px";
                    }
                    return this.getWindowDefaultValue() + "px";
                }
                if ("auto".equals(value)) {
                    if (ComputedCSSStyleDeclaration.this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_DEFAULT_WIDTH_AUTO)) {
                        return "auto";
                    }
                    return this.getWindowDefaultValue() + "px";
                }
                return value;
            }
        });
    }

    public int getCalculatedWidth(boolean includeBorder, boolean includePadding) {
        int width = this.getCalculatedWidth();
        if (includeBorder) {
            width += this.getBorderHorizontal();
        }
        if (includePadding) {
            width += this.getPaddingHorizontal();
        }
        return width;
    }

    private int getCalculatedWidth() {
        int width;
        if (this.width_ != null) {
            return this.width_;
        }
        DomElement node = this.getElement().getDomNodeOrDie();
        if (!node.mayBeDisplayed()) {
            this.width_ = 0;
            return 0;
        }
        String display = this.getDisplay();
        if ("none".equals(display)) {
            this.width_ = 0;
            return 0;
        }
        int windowWidth = this.getElement().getWindow().getWebWindow().getInnerWidth();
        String styleWidth = super.getWidth();
        DomNode parent = node.getParentNode();
        if (StringUtils.isEmpty(styleWidth) && parent instanceof HtmlElement) {
            if (this.getElement() instanceof HTMLCanvasElement) {
                return 300;
            }
            String cssFloat = this.getCssFloat();
            if ("right".equals(cssFloat) || "left".equals(cssFloat)) {
                width = node.getTextContent().length() * 10;
            } else if ("block".equals(display)) {
                HTMLElement parentJS = (HTMLElement)parent.getScriptObject();
                String parentWidth = this.getWindow().getComputedStyle(parentJS, null).getWidth();
                width = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_DEFAULT_WIDTH_AUTO) && "auto".equals(parentWidth) ? windowWidth : ComputedCSSStyleDeclaration.pixelValue(parentJS, new CSSStyleDeclaration.CssValue(windowWidth){

                    @Override
                    public String get(ComputedCSSStyleDeclaration style) {
                        return style.getWidth();
                    }
                });
                width -= this.getBorderHorizontal() + this.getPaddingHorizontal();
            } else if (node instanceof HtmlSubmitInput || node instanceof HtmlResetInput || node instanceof HtmlButtonInput || node instanceof HtmlButton || node instanceof HtmlFileInput) {
                String text = node.asText();
                width = 10 + text.length() * 10;
            } else {
                width = node instanceof HtmlTextInput || node instanceof HtmlPasswordInput ? 50 : (node instanceof HtmlRadioButtonInput || node instanceof HtmlCheckBoxInput ? 20 : (node instanceof HtmlTextArea ? 100 : this.getContentWidth()));
            }
        } else {
            width = "auto".equals(styleWidth) ? windowWidth : ComputedCSSStyleDeclaration.pixelValue(this.getElement(), new CSSStyleDeclaration.CssValue(windowWidth){

                @Override
                public String get(ComputedCSSStyleDeclaration style) {
                    return style.getStyleAttribute("width");
                }
            });
        }
        this.width_ = width;
        return width;
    }

    public int getContentWidth() {
        Page enclosedPage;
        int width = 0;
        DomNode domNode = this.getDomNodeOrDie();
        Iterable<DomNode> childs = domNode.getChildren();
        if (domNode instanceof BaseFrameElement && (enclosedPage = ((BaseFrameElement)domNode).getEnclosedPage()) != null && enclosedPage.isHtmlPage()) {
            HtmlPage htmlPage = (HtmlPage)enclosedPage;
            childs = htmlPage.getChildren();
        }
        for (DomNode child : childs) {
            if (child.getScriptObject() instanceof HTMLElement) {
                HTMLElement e = (HTMLElement)child.getScriptObject();
                CSS2Properties style = e.getWindow().getComputedStyle(e, null);
                int w = style.getCalculatedWidth(true, true);
                width += w;
                continue;
            }
            if (!(child.getScriptObject() instanceof Text)) continue;
            width += child.getTextContent().length() * 10;
        }
        return width;
    }

    public int getCalculatedHeight(boolean includeBorder, boolean includePadding) {
        int height = this.getCalculatedHeight();
        if (includeBorder) {
            height += this.getBorderVertical();
        }
        if (includePadding) {
            height += this.getPaddingVertical();
        }
        return height;
    }

    private int getCalculatedHeight() {
        if (this.height_ != null) {
            return this.height_;
        }
        int elementHeight = this.getEmptyHeight();
        if (elementHeight == 0) {
            this.height_ = elementHeight;
            return elementHeight;
        }
        int contentHeight = this.getContentHeight();
        boolean useDefaultHeight = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_DEFAULT_ELEMENT_HEIGHT_MARKS_MIN);
        boolean explicitHeightSpecified = !super.getHeight().isEmpty();
        int height = contentHeight > 0 && (useDefaultHeight && contentHeight > elementHeight || !useDefaultHeight && !explicitHeightSpecified) ? contentHeight : elementHeight;
        this.height_ = height;
        return height;
    }

    private int getEmptyHeight() {
        boolean explicitHeightSpecified;
        if (this.height2_ != null) {
            return this.height2_;
        }
        DomElement node = this.getElement().getDomNodeOrDie();
        if (!node.mayBeDisplayed()) {
            this.height2_ = 0;
            return 0;
        }
        if ("none".equals(this.getDisplay())) {
            this.height2_ = 0;
            return 0;
        }
        int windowHeight = this.getElement().getWindow().getWebWindow().getInnerHeight();
        if (this.getElement() instanceof HTMLBodyElement) {
            this.height2_ = windowHeight;
            return windowHeight;
        }
        boolean bl = explicitHeightSpecified = !super.getHeight().isEmpty();
        int defaultHeight = node instanceof HtmlDivision && node.getTextContent().trim().isEmpty() ? 0 : (this.getElement().getFirstChild() == null ? (node instanceof HtmlButton || node instanceof HtmlInput && !(node instanceof HtmlHiddenInput) ? 20 : (node instanceof HtmlSelect ? 20 : (node instanceof HtmlTextArea ? 49 : (node instanceof HtmlInlineFrame ? 154 : 0)))) : (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_DEFAULT_ELEMENT_HEIGHT_19) ? 19 : (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_DEFAULT_ELEMENT_HEIGHT_18) ? 18 : 20)));
        int defaultValue = this.getElement() instanceof HTMLCanvasElement ? 150 : windowHeight;
        int height = ComputedCSSStyleDeclaration.pixelValue(this.getElement(), new CSSStyleDeclaration.CssValue(defaultValue){

            @Override
            public String get(ComputedCSSStyleDeclaration style) {
                Element element = style.getElement();
                if (element instanceof HTMLBodyElement) {
                    return String.valueOf(element.getWindow().getWebWindow().getInnerHeight());
                }
                return style.getStyleAttribute("height");
            }
        });
        boolean useDefaultHeight = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_DEFAULT_ELEMENT_HEIGHT_MARKS_MIN);
        if (height == 0 && !explicitHeightSpecified || useDefaultHeight && height < defaultHeight) {
            height = defaultHeight;
        }
        this.height2_ = height;
        return height;
    }

    public int getContentHeight() {
        DomElement node = this.getElement().getDomNodeOrDie();
        if (!node.mayBeDisplayed()) {
            return 0;
        }
        CSS2Properties lastFlowing = null;
        HashSet<CSS2Properties> styles = new HashSet<CSS2Properties>();
        for (DomNode child : node.getChildren()) {
            ScriptableObject scriptableObject;
            if (!child.mayBeDisplayed() || !((scriptableObject = child.getScriptObject()) instanceof HTMLElement)) continue;
            HTMLElement e = (HTMLElement)scriptableObject;
            CSS2Properties style = e.getWindow().getComputedStyle(e, null);
            String pos = style.getPositionWithInheritance();
            if ("static".equals(pos) || "relative".equals(pos)) {
                lastFlowing = style;
                continue;
            }
            if (!"absolute".equals(pos)) continue;
            styles.add(style);
        }
        if (lastFlowing != null) {
            styles.add(lastFlowing);
        }
        int max = 0;
        for (ComputedCSSStyleDeclaration computedCSSStyleDeclaration : styles) {
            int h = computedCSSStyleDeclaration.getTop(true, false, false) + computedCSSStyleDeclaration.getCalculatedHeight(true, true);
            if (h <= max) continue;
            max = h;
        }
        return max;
    }

    public boolean isScrollable(boolean horizontal) {
        Element node = this.getElement();
        String overflow = this.getOverflow();
        boolean scrollable = horizontal ? (node instanceof HTMLBodyElement || "scroll".equals(overflow) || "auto".equals(overflow)) && this.getContentWidth() > this.getCalculatedWidth() : (node instanceof HTMLBodyElement || "scroll".equals(overflow) || "auto".equals(overflow)) && this.getContentHeight() > this.getEmptyHeight();
        return scrollable;
    }

    public int getTop(boolean includeMargin, boolean includeBorder, boolean includePadding) {
        int top = 0;
        if (null == this.top_) {
            String p = this.getPositionWithInheritance();
            if ("absolute".equals(p)) {
                String t = this.getTopWithInheritance();
                if (!"auto".equals(t)) {
                    top = ComputedCSSStyleDeclaration.pixelValue(t);
                } else {
                    String b = this.getBottomWithInheritance();
                    if (!"auto".equals(b)) {
                        top = 0;
                        for (DomNode child = this.getElement().getDomNodeOrDie().getParentNode().getFirstChild(); child != null; child = child.getNextSibling()) {
                            if (!(child instanceof HtmlElement) || !child.mayBeDisplayed()) continue;
                            top += 20;
                        }
                        top -= ComputedCSSStyleDeclaration.pixelValue(b);
                    }
                }
            } else {
                DomNode prev;
                for (prev = this.getElement().getDomNodeOrDie().getPreviousSibling(); prev != null && !(prev instanceof HtmlElement); prev = prev.getPreviousSibling()) {
                }
                if (prev != null) {
                    HTMLElement e = (HTMLElement)((HtmlElement)prev).getScriptObject();
                    CSS2Properties style = e.getWindow().getComputedStyle(e, null);
                    top = style.getTop(true, false, false) + style.getCalculatedHeight(true, true);
                }
                if ("relative".equals(p)) {
                    String t = this.getTopWithInheritance();
                    top += ComputedCSSStyleDeclaration.pixelValue(t);
                }
            }
            this.top_ = top;
        } else {
            top = this.top_;
        }
        if (includeMargin) {
            int margin = ComputedCSSStyleDeclaration.pixelValue(this.getMarginTop());
            top += margin;
        }
        if (includeBorder) {
            int border = ComputedCSSStyleDeclaration.pixelValue(this.getBorderTopWidth());
            top += border;
        }
        if (includePadding) {
            int padding = this.getPaddingTopValue();
            top += padding;
        }
        return top;
    }

    public int getLeft(boolean includeMargin, boolean includeBorder, boolean includePadding) {
        HTMLElement parent;
        int left;
        String p = this.getPositionWithInheritance();
        String l = this.getLeftWithInheritance();
        String r = this.getRightWithInheritance();
        if ("fixed".equals(p) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.TREATS_POSITION_FIXED_LIKE_POSITION_STATIC)) {
            p = "static";
        }
        if ("absolute".equals(p) && !"auto".equals(l)) {
            left = ComputedCSSStyleDeclaration.pixelValue(l);
        } else if ("absolute".equals(p) && !"auto".equals(r)) {
            parent = (HTMLElement)this.getElement().getParentElement();
            CSS2Properties style = parent.getWindow().getComputedStyle(parent, null);
            int parentWidth = style.getCalculatedWidth(false, false);
            left = parentWidth - ComputedCSSStyleDeclaration.pixelValue(r);
        } else if ("fixed".equals(p) && "auto".equals(l)) {
            parent = (HTMLElement)this.getElement().getParentElement();
            CSS2Properties style = parent.getWindow().getComputedStyle(parent, null);
            left = ComputedCSSStyleDeclaration.pixelValue(style.getLeftWithInheritance());
        } else if ("static".equals(p)) {
            left = 0;
            for (DomNode n = this.getDomNodeOrDie(); n != null; n = n.getPreviousSibling()) {
                if (n.getScriptObject() instanceof HTMLElement) {
                    HTMLElement e = (HTMLElement)n.getScriptObject();
                    CSS2Properties style = e.getWindow().getComputedStyle(e, null);
                    String d = style.getDisplay();
                    if ("block".equals(d)) break;
                    if (!"none".equals(d)) {
                        left += style.getCalculatedWidth(true, true);
                    }
                } else if (n.getScriptObject() instanceof Text) {
                    left += n.getTextContent().length() * 10;
                }
                if (!(n instanceof HtmlTableRow)) {
                    continue;
                }
                break;
            }
        } else {
            left = ComputedCSSStyleDeclaration.pixelValue(l);
        }
        if (includeMargin) {
            int margin = this.getMarginLeftValue();
            left += margin;
        }
        if (includeBorder) {
            int border = ComputedCSSStyleDeclaration.pixelValue(this.getBorderLeftWidth());
            left += border;
        }
        if (includePadding) {
            int padding = this.getPaddingLeftValue();
            left += padding;
        }
        return left;
    }

    public String getPositionWithInheritance() {
        String p = this.getPosition();
        if ("inherit".equals(p)) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CAN_INHERIT_CSS_PROPERTY_VALUES)) {
                HTMLElement parent = (HTMLElement)this.getElement().getParentElement();
                if (parent == null) {
                    p = "static";
                } else {
                    CSS2Properties style = parent.getWindow().getComputedStyle(parent, null);
                    p = style.getPositionWithInheritance();
                }
            } else {
                p = "static";
            }
        }
        return p;
    }

    public String getLeftWithInheritance() {
        String left = this.getLeft();
        if ("inherit".equals(left)) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CAN_INHERIT_CSS_PROPERTY_VALUES)) {
                HTMLElement parent = (HTMLElement)this.getElement().getParentElement();
                if (parent == null) {
                    left = "auto";
                } else {
                    CSS2Properties style = parent.getWindow().getComputedStyle(parent, null);
                    left = style.getLeftWithInheritance();
                }
            } else {
                left = "auto";
            }
        }
        return left;
    }

    public String getRightWithInheritance() {
        String right = this.getRight();
        if ("inherit".equals(right)) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CAN_INHERIT_CSS_PROPERTY_VALUES)) {
                HTMLElement parent = (HTMLElement)this.getElement().getParentElement();
                if (parent == null) {
                    right = "auto";
                } else {
                    CSS2Properties style = parent.getWindow().getComputedStyle(parent, null);
                    right = style.getRightWithInheritance();
                }
            } else {
                right = "auto";
            }
        }
        return right;
    }

    public String getTopWithInheritance() {
        String top = this.getTop();
        if ("inherit".equals(top)) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CAN_INHERIT_CSS_PROPERTY_VALUES)) {
                HTMLElement parent = (HTMLElement)this.getElement().getParentElement();
                if (parent == null) {
                    top = "auto";
                } else {
                    CSS2Properties style = parent.getWindow().getComputedStyle(parent, null);
                    top = style.getTopWithInheritance();
                }
            } else {
                top = "auto";
            }
        }
        return top;
    }

    public String getBottomWithInheritance() {
        String bottom = this.getBottom();
        if ("inherit".equals(bottom)) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CAN_INHERIT_CSS_PROPERTY_VALUES)) {
                HTMLElement parent = (HTMLElement)this.getElement().getParentElement();
                if (parent == null) {
                    bottom = "auto";
                } else {
                    CSS2Properties style = parent.getWindow().getComputedStyle(parent, null);
                    bottom = style.getBottomWithInheritance();
                }
            } else {
                bottom = "auto";
            }
        }
        return bottom;
    }

    @Override
    public String getRubyOverhang() {
        return this.defaultIfEmpty(super.getRubyOverhang(), StyleAttributes.Definition.RUBY_OVERHANG);
    }

    @Override
    public String getRubyPosition() {
        return this.defaultIfEmpty(super.getRubyPosition(), StyleAttributes.Definition.RUBY_POSITION);
    }

    public int getMarginLeftValue() {
        return ComputedCSSStyleDeclaration.pixelValue(this.getMarginLeft());
    }

    public int getMarginRightValue() {
        return ComputedCSSStyleDeclaration.pixelValue(this.getMarginRight());
    }

    public int getMarginTopValue() {
        return ComputedCSSStyleDeclaration.pixelValue(this.getMarginTop());
    }

    public int getMarginBottomValue() {
        return ComputedCSSStyleDeclaration.pixelValue(this.getMarginBottom());
    }

    public int getPaddingLeftValue() {
        return ComputedCSSStyleDeclaration.pixelValue(this.getPaddingLeft());
    }

    public int getPaddingRightValue() {
        return ComputedCSSStyleDeclaration.pixelValue(this.getPaddingRight());
    }

    public int getPaddingTopValue() {
        return ComputedCSSStyleDeclaration.pixelValue(this.getPaddingTop());
    }

    public int getPaddingBottomValue() {
        return ComputedCSSStyleDeclaration.pixelValue(this.getPaddingBottom());
    }

    private int getPaddingHorizontal() {
        if (this.paddingHorizontal_ == null) {
            this.paddingHorizontal_ = "none".equals(this.getDisplay()) ? 0 : this.getPaddingLeftValue() + this.getPaddingRightValue();
        }
        return this.paddingHorizontal_;
    }

    private int getPaddingVertical() {
        if (this.paddingVertical_ == null) {
            this.paddingVertical_ = "none".equals(this.getDisplay()) ? 0 : this.getPaddingTopValue() + this.getPaddingBottomValue();
        }
        return this.paddingVertical_;
    }

    public int getBorderLeftValue() {
        return ComputedCSSStyleDeclaration.pixelValue(this.getBorderLeftWidth());
    }

    public int getBorderRightValue() {
        return ComputedCSSStyleDeclaration.pixelValue(this.getBorderRightWidth());
    }

    public int getBorderTopValue() {
        return ComputedCSSStyleDeclaration.pixelValue(this.getBorderTopWidth());
    }

    public int getBorderBottomValue() {
        return ComputedCSSStyleDeclaration.pixelValue(this.getBorderBottomWidth());
    }

    private int getBorderHorizontal() {
        if (this.borderHorizontal_ == null) {
            this.borderHorizontal_ = "none".equals(this.getDisplay()) ? 0 : this.getBorderLeftValue() + this.getBorderRightValue();
        }
        return this.borderHorizontal_;
    }

    private int getBorderVertical() {
        if (this.borderVertical_ == null) {
            this.borderVertical_ = "none".equals(this.getDisplay()) ? 0 : this.getBorderTopValue() + this.getBorderBottomValue();
        }
        return this.borderVertical_;
    }

    @Override
    public String getWordSpacing() {
        return this.defaultIfEmpty(super.getWordSpacing(), StyleAttributes.Definition.WORD_SPACING);
    }

    @Override
    public String getWordWrap() {
        return this.defaultIfEmpty(super.getWordWrap(), StyleAttributes.Definition.WORD_WRAP);
    }

    @Override
    protected String getStyleAttributeValue(StyleAttributes.Definition style) {
        String value = super.getStyleAttributeValue(style);
        if (StringUtils.isEmpty(value)) {
            return style.getDefaultComputedValue(this.getBrowserVersion());
        }
        return value;
    }

    @Override
    public Object getZIndex() {
        Object response = super.getZIndex();
        if (response.toString().isEmpty()) {
            return "auto";
        }
        return response;
    }

    @Override
    public String getZoom() {
        return this.defaultIfEmpty(super.getZoom(), StyleAttributes.Definition.ZOOM);
    }

    @Override
    public String getPropertyValue(String name) {
        Object property = ComputedCSSStyleDeclaration.getProperty((Scriptable)this, ComputedCSSStyleDeclaration.camelize(name));
        if (property == NOT_FOUND) {
            return super.getPropertyValue(name);
        }
        return Context.toString(property);
    }

    protected String pixelString(String value) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_LENGTH_WITHOUT_PX)) {
            return value;
        }
        if (value.endsWith("px")) {
            return value;
        }
        return ComputedCSSStyleDeclaration.pixelValue(value) + "px";
    }

    protected String pixelString(Element element, CSSStyleDeclaration.CssValue value) {
        String s = value.get(element);
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_LENGTH_WITHOUT_PX)) {
            return s;
        }
        if (s.endsWith("px")) {
            return s;
        }
        return ComputedCSSStyleDeclaration.pixelValue(element, value) + "px";
    }
}

