/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.internal.feed;

import com.atlassian.streams.api.common.Either;
import com.atlassian.streams.api.common.Iterables;
import com.atlassian.streams.api.common.Option;
import com.atlassian.streams.api.common.Options;
import com.atlassian.streams.api.common.uri.Uri;
import com.atlassian.streams.internal.ActivityProvider;
import com.atlassian.streams.internal.atom.abdera.AtomConstants;
import com.atlassian.streams.internal.atom.abdera.StreamsAbdera;
import com.atlassian.streams.internal.feed.ActivitySourceBannedFeedHeader;
import com.atlassian.streams.internal.feed.ActivitySourceTimeOutFeedHeader;
import com.atlassian.streams.internal.feed.FeedEntry;
import com.atlassian.streams.internal.feed.FeedHeader;
import com.atlassian.streams.internal.feed.FeedModel;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.joda.time.DateTime;

public class FeedAggregator {
    private Function<FeedModel, Option<DateTime>> toUpdated = new Function<FeedModel, Option<DateTime>>(){

        public Option<DateTime> apply(FeedModel feedModel) {
            return feedModel.getUpdated();
        }
    };
    private Predicate<FeedHeader> timezoneOffset = new Predicate<FeedHeader>(){

        public boolean apply(FeedHeader header) {
            if (header instanceof StreamsAbdera.AtomParsedFeedHeader) {
                return ((StreamsAbdera.AtomParsedFeedHeader)header).getElement().getQName().equals(AtomConstants.ATLASSIAN_TIMEZONE_OFFSET);
            }
            return false;
        }
    };
    private Predicate<Either<ActivityProvider.Error, FeedModel>> successesAndTimeoutErrors = new Predicate<Either<ActivityProvider.Error, FeedModel>>(){

        public boolean apply(Either<ActivityProvider.Error, FeedModel> either) {
            return either.isRight() || ((ActivityProvider.Error)either.left().get()).getType().equals((Object)ActivityProvider.Error.Type.TIMEOUT) || ((ActivityProvider.Error)either.left().get()).getType().equals((Object)ActivityProvider.Error.Type.BANNED);
        }
    };
    private static final Comparator<FeedEntry> REVERSE_CHRONOLOGICAL = new Comparator<FeedEntry>(){

        @Override
        public int compare(FeedEntry entry1, FeedEntry entry2) {
            return entry2.getEntryDate().compareTo((Object)entry1.getEntryDate());
        }
    };

    public FeedModel aggregate(Iterable<Either<ActivityProvider.Error, FeedModel>> feedResponses, Uri selfUri, int maxResults, Option<String> title) {
        FeedModel feed;
        Either onlyResponse;
        if (this.sizeEquals(feedResponses, 1) && (onlyResponse = (Either)com.google.common.collect.Iterables.getOnlyElement(feedResponses)).isRight() && (feed = (FeedModel)onlyResponse.right().get()).getUri().equals((Object)selfUri)) {
            return feed;
        }
        Iterable feeds = com.google.common.collect.Iterables.filter(feedResponses, this.successesAndTimeoutErrors);
        FeedModel.Builder builder = FeedModel.builder(selfUri);
        builder.title(title);
        ArrayList entries = new ArrayList();
        for (ActivityProvider.Error error : Either.getLefts((Iterable)feeds)) {
            if (error.getType().equals((Object)ActivityProvider.Error.Type.TIMEOUT) && error.getApplicationLinkName().isDefined()) {
                builder.addHeaders(Lists.newArrayList((Object[])new FeedHeader[]{new ActivitySourceTimeOutFeedHeader((String)error.getApplicationLinkName().get())}));
            }
            if (!error.getType().equals((Object)ActivityProvider.Error.Type.BANNED) || !error.getApplicationLinkName().isDefined()) continue;
            builder.addHeaders(Lists.newArrayList((Object[])new FeedHeader[]{new ActivitySourceBannedFeedHeader((String)error.getApplicationLinkName().get())}));
        }
        for (FeedModel feed2 : Either.getRights((Iterable)feeds)) {
            builder.addHeaders(com.google.common.collect.Iterables.filter(feed2.getHeaders(), (Predicate)Predicates.not(this.timezoneOffset)));
            com.google.common.collect.Iterables.addAll(entries, (Iterable)com.google.common.collect.Iterables.transform(feed2.getEntries(), this.fromFeedSource(feed2)));
        }
        try {
            builder.updated((Option<DateTime>)Option.some((Object)Ordering.natural().max(Options.catOptions((Iterable)com.google.common.collect.Iterables.transform((Iterable)Either.getRights((Iterable)feeds), this.toUpdated)))));
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        Collections.sort(entries, REVERSE_CHRONOLOGICAL);
        builder.addEntries(Iterables.take((int)maxResults, entries));
        return builder.build();
    }

    private Function<FeedEntry, FeedEntry> fromFeedSource(final FeedModel feed) {
        return new Function<FeedEntry, FeedEntry>(){
            private final Option<FeedModel> sourceFeed;
            {
                this.sourceFeed = Option.some((Object)feed);
            }

            public FeedEntry apply(FeedEntry from) {
                return from.toAggregatedEntry(this.sourceFeed);
            }
        };
    }

    private boolean sizeEquals(Iterable<?> iterable, int size) {
        int i;
        Iterator<?> it = iterable.iterator();
        for (i = 0; it.hasNext() && i < size; ++i) {
            it.next();
        }
        return !it.hasNext() && i == size;
    }
}

