/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.internal;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.streams.api.ActivityRequest;
import com.atlassian.streams.api.StreamsEntry;
import com.atlassian.streams.api.StreamsException;
import com.atlassian.streams.api.StreamsFeed;
import com.atlassian.streams.api.common.Either;
import com.atlassian.streams.api.common.Option;
import com.atlassian.streams.internal.ActivityProvider;
import com.atlassian.streams.internal.ActivityRequestImpl;
import com.atlassian.streams.internal.feed.FeedEntry;
import com.atlassian.streams.internal.feed.FeedModel;
import com.atlassian.streams.internal.rest.representations.ProviderFilterRepresentation;
import com.atlassian.streams.internal.rest.representations.StreamsKeysRepresentation;
import com.atlassian.streams.spi.ActivityProviderModuleDescriptor;
import com.atlassian.streams.spi.CancellableTask;
import com.atlassian.streams.spi.CancelledException;
import com.atlassian.streams.spi.SessionManager;
import com.atlassian.streams.spi.StreamsActivityProvider;
import com.atlassian.streams.spi.StreamsCommentHandler;
import com.atlassian.streams.spi.StreamsFilterOptionProvider;
import com.atlassian.streams.spi.StreamsI18nResolver;
import com.atlassian.streams.spi.StreamsKeyProvider;
import com.atlassian.streams.spi.StreamsValidator;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.net.URI;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LocalActivityProvider
implements ActivityProvider {
    public static final String ACCEPT_LANGUAGE_KEY = "Accept-Language";
    private static final Logger logger = LoggerFactory.getLogger(LocalActivityProvider.class);
    private final String key;
    private final String name;
    private final StreamsActivityProvider activityProvider;
    private final StreamsFilterOptionProvider filterOptionProvider;
    private final StreamsKeyProvider keyProvider;
    private final StreamsValidator validator;
    private final StreamsCommentHandler commentHandler;
    private final TransactionTemplate transactionTemplate;
    private final StreamsI18nResolver i18nResolver;
    private final SessionManager sessionManager;
    private final ApplicationProperties applicationProperties;
    private final Predicate<String> areValid = new Predicate<String>(){

        public boolean apply(String key) {
            return LocalActivityProvider.this.validator.isValidKey(key);
        }
    };

    public LocalActivityProvider(ActivityProviderModuleDescriptor descriptor, SessionManager sessionManager, TransactionTemplate transactionTemplate, StreamsI18nResolver i18nResolver, ApplicationProperties applicationProperties) {
        this.key = (String)Preconditions.checkNotNull((Object)descriptor.getKey(), (Object)"key");
        this.name = (String)Preconditions.checkNotNull((Object)(descriptor.getI18nNameKey() != null ? i18nResolver.getText(descriptor.getI18nNameKey()) : descriptor.getName()), (Object)"name");
        this.activityProvider = (StreamsActivityProvider)Preconditions.checkNotNull((Object)descriptor.getModule(), (Object)"activityProvider");
        this.sessionManager = (SessionManager)Preconditions.checkNotNull((Object)sessionManager, (Object)"sessionManager");
        this.transactionTemplate = (TransactionTemplate)Preconditions.checkNotNull((Object)transactionTemplate, (Object)"transactionTemplate");
        this.i18nResolver = (StreamsI18nResolver)Preconditions.checkNotNull((Object)i18nResolver, (Object)"i18nResolver");
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties, (Object)"applicationProperties");
        this.filterOptionProvider = descriptor.getFilterOptionProvider();
        this.keyProvider = descriptor.getKeyProvider();
        this.validator = descriptor.getValidator();
        this.commentHandler = descriptor.getCommentHandler();
    }

    @Override
    public boolean matches(String key) {
        return this.getKey().equals(key);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getBaseUrl() {
        return this.applicationProperties.getBaseUrl();
    }

    @Override
    public String getType() {
        return this.applicationProperties.getDisplayName();
    }

    @Override
    public CancellableTask<Either<ActivityProvider.Error, FeedModel>> getActivityFeed(final ActivityRequestImpl request) throws StreamsException {
        final CancellableTask task = this.activityProvider.getActivityFeed((ActivityRequest)request);
        return new CancellableTask<Either<ActivityProvider.Error, FeedModel>>(){

            public Either<ActivityProvider.Error, FeedModel> call() throws Exception {
                return (Either)LocalActivityProvider.this.sessionManager.withSession((Supplier)new Supplier<Either<ActivityProvider.Error, FeedModel>>(){

                    public Either<ActivityProvider.Error, FeedModel> get() {
                        return (Either)LocalActivityProvider.this.transactionTemplate.execute((TransactionCallback)LocalActivityProvider.this.fetchFeed(request, (CancellableTask<StreamsFeed>)task));
                    }
                });
            }

            public CancellableTask.Result cancel() {
                return task.cancel();
            }
        };
    }

    @Override
    public Either<ActivityProvider.Error, Iterable<ProviderFilterRepresentation>> getFilters(boolean addApplinkName) {
        if (this.filterOptionProvider == null) {
            return Either.right((Object)ImmutableList.of());
        }
        return Either.right((Object)ImmutableList.of((Object)new ProviderFilterRepresentation(this.key, this.name, "", this.filterOptionProvider, (I18nResolver)this.i18nResolver)));
    }

    @Override
    public StreamsKeysRepresentation getKeys() {
        if (this.keyProvider == null) {
            return new StreamsKeysRepresentation((Iterable<StreamsKeyProvider.StreamsKey>)ImmutableList.of());
        }
        return new StreamsKeysRepresentation(this.keyProvider.getKeys());
    }

    @Override
    public boolean allKeysAreValid(Iterable<String> keys) {
        if (this.validator == null) {
            return false;
        }
        return Iterables.all(keys, this.areValid);
    }

    public Either<StreamsCommentHandler.PostReplyError, URI> postReply(URI baseUri, Iterable<String> itemPath, String comment) {
        return this.commentHandler.postReply(baseUri, itemPath, comment);
    }

    private FeedFetcher fetchFeed(ActivityRequest request, CancellableTask<StreamsFeed> task) {
        return new FeedFetcher(request, task, this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalActivityProvider that = (LocalActivityProvider)o;
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    private final class FeedFetcher
    implements TransactionCallback<Either<ActivityProvider.Error, FeedModel>> {
        private final ActivityRequest request;
        private final CancellableTask<StreamsFeed> task;
        private final ActivityProvider activityProvider;

        private FeedFetcher(ActivityRequest request, CancellableTask<StreamsFeed> task, ActivityProvider activityProvider) {
            this.request = request;
            this.task = task;
            this.activityProvider = activityProvider;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Either<ActivityProvider.Error, FeedModel> doInTransaction() {
            try {
                LocalActivityProvider.this.i18nResolver.setRequestLanguages(this.request.getRequestLanguages());
                StreamsFeed stream = (StreamsFeed)this.task.call();
                Iterable entries = stream.getEntries();
                FeedModel.Builder builder = FeedModel.builder(this.request.getUri()).title((Option<String>)Option.option((Object)stream.getTitle())).subtitle((Option<String>)stream.getSubtitle()).updated((Option<DateTime>)Option.some((Object)this.getUpdatedDate(this.request, entries)));
                builder.addEntries(Iterables.transform((Iterable)entries, FeedEntry.fromStreamsEntry()));
                Either either = Either.right((Object)builder.build());
                return either;
            }
            catch (CancelledException e) {
                Either either = Either.left((Object)ActivityProvider.Error.timeout(this.activityProvider));
                return either;
            }
            catch (Exception e) {
                logger.error("Exception building feed", (Throwable)e);
                Either either = Either.left((Object)ActivityProvider.Error.other(this.activityProvider));
                return either;
            }
            finally {
                LocalActivityProvider.this.i18nResolver.setRequestLanguages(null);
            }
        }

        private DateTime getUpdatedDate(ActivityRequest request, Iterable<StreamsEntry> entries) {
            if (Iterables.isEmpty(entries)) {
                return new DateTime();
            }
            return new DateTime(((StreamsEntry)Iterables.get(entries, (int)0)).getPostedDate().getMillis());
        }
    }
}

